/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.TimeZone;
import org.traccar.BaseProtocolEncoder;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class CityeasyProtocolEncoder
extends BaseProtocolEncoder {
    private ByteBuf encodeContent(int type, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(83);
        buf.writeByte(83);
        buf.writeShort(6 + content.readableBytes() + 4 + 2 + 2);
        buf.writeShort(type);
        buf.writeBytes(content);
        buf.writeInt(11);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_KERMIT, buf.nioBuffer()));
        buf.writeByte(13);
        buf.writeByte(10);
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        ByteBuf content = Unpooled.buffer();
        switch (command.getType()) {
            case "positionSingle": {
                return this.encodeContent(4, content);
            }
            case "positionPeriodic": {
                content.writeShort(command.getInteger("frequency"));
                return this.encodeContent(5, content);
            }
            case "positionStop": {
                content.writeShort(0);
                return this.encodeContent(5, content);
            }
            case "setTimezone": {
                int timezone = TimeZone.getTimeZone(command.getString("timezone")).getRawOffset() / 60000;
                if (timezone < 0) {
                    content.writeByte(1);
                } else {
                    content.writeByte(0);
                }
                content.writeShort(Math.abs(timezone));
                return this.encodeContent(8, content);
            }
        }
        return null;
    }
}

