/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

public class GSMBitPacker {
    public static byte[] pack(byte[] unpacked) {
        if (unpacked == null) {
            return null;
        }
        int packedLen = unpacked.length - unpacked.length / 8;
        byte[] packed = new byte[packedLen];
        int len = unpacked.length;
        int current = 0;
        int bitpos = 0;
        for (int i = 0; i < len; ++i) {
            byte b = (byte)(unpacked[i] & 0x7F);
            int n = current++;
            packed[n] = (byte)(packed[n] | (byte)((b & 0xFF) << bitpos));
            if (bitpos >= 2) {
                int n2 = current;
                packed[n2] = (byte)(packed[n2] | b >> 8 - bitpos);
            }
            if ((bitpos = (bitpos + 7) % 8) != 0) continue;
            ++current;
        }
        return packed;
    }

    public static byte[] unpack(byte[] packed) {
        if (packed == null) {
            return null;
        }
        int unpackedLen = packed.length * 8 / 7;
        byte[] unpacked = new byte[unpackedLen];
        int len = unpacked.length;
        int current = 0;
        int bitpos = 0;
        for (int i = 0; i < len; ++i) {
            unpacked[i] = (byte)((packed[current] & 0xFF) >> bitpos & 0x7F);
            if (bitpos >= 2) {
                int n = i;
                unpacked[n] = (byte)(unpacked[n] | (byte)(packed[++current] << 8 - bitpos & 0x7F));
            }
            if ((bitpos = (bitpos + 7) % 8) != 0) continue;
            ++current;
        }
        if (len % 8 == 0 && len > 0 && unpacked[len - 1] == 0) {
            byte[] fixed = new byte[len - 1];
            System.arraycopy(unpacked, 0, fixed, 0, len - 1);
            unpacked = fixed;
        }
        return unpacked;
    }
}

