/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools.ico.impl;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.jnlp.tools.ico.impl.IcoException;

public class IcoHeaderEntry {
    private int width;
    private int height;
    private int colorCount;
    private final int reserved;
    private final int planes;
    private final int bitCount;
    private final int sizeInBytes;
    private final int fileOffset;

    public IcoHeaderEntry(ImageInputStream src) throws IOException, IcoException {
        this.width = src.read();
        this.height = src.read();
        this.colorCount = src.read();
        if (this.colorCount == 0) {
            this.colorCount = 256;
        }
        this.reserved = src.read();
        this.planes = src.readUnsignedShort();
        this.isIcoHeader();
        this.bitCount = src.readUnsignedShort();
        this.sizeInBytes = src.readInt();
        this.fileOffset = src.readInt();
    }

    private IcoHeaderEntry(int width, int height, int colorCount, int planes, int bitCount, int sizeInBytes, int fileOffset) {
        this.width = width;
        this.height = height;
        this.colorCount = colorCount;
        this.reserved = 0;
        this.planes = planes;
        this.bitCount = bitCount;
        this.sizeInBytes = sizeInBytes;
        this.fileOffset = fileOffset;
    }

    private IcoHeaderEntry provideMonochromeHeader() {
        return new IcoHeaderEntry(this.width, this.height, 1, this.planes, 1, this.width * this.height / 8, this.fileOffset + this.sizeInBytes);
    }

    private void isIcoHeader() throws IcoException {
        if (this.reserved != 0 || this.planes != 1 && this.planes != 0) {
            throw new IcoException("Invalid header. Expected 0 and 1(0?), got " + this.reserved + " and " + this.planes);
        }
    }

    int getColorCount() {
        return this.colorCount;
    }

    void setColorCount(int colorCount) {
        this.colorCount = colorCount;
    }

    public int getWidth() {
        return this.width;
    }

    void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    void setHeight(int height) {
        this.height = height;
    }

    int getSizeInBytes() {
        return this.sizeInBytes;
    }

    int getFileOffset() {
        return this.fileOffset;
    }
}

