/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;
import resources.icons.FileBasedIcon;

public class ImageIconWrapper
extends ImageIcon
implements FileBasedIcon {
    private boolean loaded;
    private ImageIcon imageIcon;
    private Image image;
    private Image baseImage;
    private Icon baseIcon;
    private byte[] imageBytes;
    private URL imageURL;
    private String imageName;

    public ImageIconWrapper(byte[] imageBytes, String imageName) {
        if (imageBytes == null) {
            throw new NullPointerException("Cannot create an ImageIconWrapper from a null URL");
        }
        if (imageBytes.length == 0) {
            throw new IllegalArgumentException("Cannot create an image from 0 bytes");
        }
        this.imageBytes = imageBytes;
        this.imageName = imageName;
    }

    public ImageIconWrapper(Image image, String imageName) {
        Objects.requireNonNull(image, "Cannot create an ImageIconWrapper from a null image");
        this.baseImage = image;
        this.imageName = imageName;
    }

    public ImageIconWrapper(Icon icon) {
        this.baseIcon = icon;
    }

    public ImageIconWrapper(URL url) {
        Objects.requireNonNull(url, "Cannot create an ImageIconWrapper from a null URL");
        this.imageURL = url;
        this.imageName = this.imageURL.toExternalForm();
    }

    private synchronized void init() {
        if (!this.loaded) {
            this.loaded = true;
            this.imageIcon = this.createImageIcon();
            this.image = this.imageIcon.getImage();
            super.setImage(this.image);
        }
    }

    @Override
    public String getFilename() {
        return this.getImageName();
    }

    public String getImageName() {
        if (this.imageName == null && this.baseIcon != null) {
            this.imageName = ResourceManager.getIconName(this.baseIcon);
        }
        return this.imageName;
    }

    @Override
    public Image getImage() {
        this.init();
        return this.image;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        this.init();
        return this.imageIcon.getAccessibleContext();
    }

    @Override
    public String getDescription() {
        this.init();
        return this.imageIcon.getDescription();
    }

    @Override
    public int getIconHeight() {
        this.init();
        return this.imageIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.init();
        return this.imageIcon.getIconWidth();
    }

    @Override
    public int getImageLoadStatus() {
        this.init();
        return this.imageIcon.getImageLoadStatus();
    }

    @Override
    public ImageObserver getImageObserver() {
        this.init();
        return this.imageIcon.getImageObserver();
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.init();
        super.paintIcon(c, g, x, y);
    }

    @Override
    public void setDescription(String description) {
        this.init();
        this.imageIcon.setDescription(description);
    }

    @Override
    public void setImage(Image image) {
        this.init();
        this.image = image;
        super.setImage(image);
    }

    @Override
    public String toString() {
        this.init();
        return this.imageIcon.toString();
    }

    private byte[] loadBytesFromURL(URL url) {
        byte[] byArray;
        block9: {
            InputStream is = url.openStream();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int length = 0;
                byte[] buf = new byte[1024];
                while ((length = is.read(buf)) > 0) {
                    os.write(buf, 0, length);
                }
                byArray = os.toByteArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Exception loading image bytes: " + url.toExternalForm()), (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return byArray;
    }

    protected final Image createIconBaseImage() {
        if (this.baseImage != null) {
            return this.baseImage;
        }
        if (this.baseIcon != null) {
            BufferedImage bufferedImage = new BufferedImage(this.baseIcon.getIconWidth(), this.baseIcon.getIconHeight(), 2);
            Graphics graphics = bufferedImage.getGraphics();
            this.baseIcon.paintIcon(null, graphics, 0, 0);
            graphics.dispose();
            return bufferedImage;
        }
        if (this.imageBytes == null || this.imageBytes.length == 0) {
            this.imageBytes = this.loadBytesFromURL(this.imageURL);
            if (this.imageBytes == null) {
                return null;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(this.imageBytes);
    }

    protected ImageIcon createImageIcon() {
        if (this.baseIcon instanceof ImageIcon) {
            return (ImageIcon)this.baseIcon;
        }
        Image iconImage = this.createIconBaseImage();
        if (iconImage == null) {
            return this.getDefaultIcon();
        }
        String name = this.getImageName();
        if (!ImageUtils.waitForImage(name, iconImage)) {
            return this.getDefaultIcon();
        }
        return new ImageIcon(iconImage, name);
    }

    private ImageIcon getDefaultIcon() {
        ImageIcon defaultIcon = ResourceManager.getDefaultIcon();
        if (this == defaultIcon) {
            throw new IllegalStateException("Unexpected failure loading the default icon!");
        }
        return defaultIcon;
    }
}

