/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DependencyGraph<T> {
    private Map<T, DependencyNode> nodeMap = new HashMap<T, DependencyNode>();
    private Set<T> unvisitedIndependentSet = new HashSet<T>();
    private int visitedButNotDeletedCount = 0;

    public DependencyGraph() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyGraph(DependencyGraph<T> other) {
        DependencyGraph<T> dependencyGraph = other;
        synchronized (dependencyGraph) {
            for (DependencyNode node : other.nodeMap.values()) {
                this.addValue(node.value);
                if (node.setOfNodesThatDependOnMe == null) continue;
                for (DependencyNode child : node.setOfNodesThatDependOnMe) {
                    this.addDependency(child.value, node.value);
                }
            }
        }
    }

    public synchronized void addValue(T value) {
        this.getOrCreateDependencyNode(value);
    }

    public synchronized int size() {
        return this.nodeMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    public synchronized boolean contains(T value) {
        return this.nodeMap.containsKey(value);
    }

    public synchronized Set<T> getValues() {
        return new HashSet<T>(this.nodeMap.keySet());
    }

    public synchronized DependencyGraph<T> copy() {
        return new DependencyGraph<T>(this);
    }

    private DependencyNode getOrCreateDependencyNode(T value) {
        DependencyNode dependencyNode = this.nodeMap.get(value);
        if (dependencyNode == null) {
            dependencyNode = new DependencyNode(value);
            this.nodeMap.put(value, dependencyNode);
            this.unvisitedIndependentSet.add(value);
        }
        return dependencyNode;
    }

    public synchronized void addDependency(T value1, T value2) {
        DependencyNode valueNode1 = this.getOrCreateDependencyNode(value1);
        DependencyNode valueNode2 = this.getOrCreateDependencyNode(value2);
        valueNode2.addNodeThatDependsOnMe(valueNode1);
    }

    public synchronized boolean hasUnVisitedIndependentValues() {
        if (!this.unvisitedIndependentSet.isEmpty()) {
            return true;
        }
        this.checkCycleState();
        return false;
    }

    public synchronized T pop() {
        this.checkCycleState();
        if (this.unvisitedIndependentSet.isEmpty()) {
            return null;
        }
        T value = this.unvisitedIndependentSet.iterator().next();
        this.unvisitedIndependentSet.remove(value);
        this.remove(value);
        return value;
    }

    private void checkCycleState() {
        if (!this.isEmpty() && this.unvisitedIndependentSet.isEmpty() && this.visitedButNotDeletedCount == 0) {
            throw new IllegalStateException("Cycle detected!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasCycles() {
        try {
            HashSet<T> visited = new HashSet<T>();
            while (!this.unvisitedIndependentSet.isEmpty()) {
                Set<T> values = this.getUnvisitedIndependentValues();
                visited.addAll(values);
                for (Object k : values) {
                    DependencyNode node = this.nodeMap.get(k);
                    node.releaseDependencies();
                }
            }
            if (visited.size() != this.nodeMap.size()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.reset();
        }
        return false;
    }

    private void reset() {
        this.visitedButNotDeletedCount = 0;
        for (DependencyNode node : this.nodeMap.values()) {
            node.numberOfNodesThatIDependOn = 0;
        }
        for (DependencyNode node : this.nodeMap.values()) {
            if (node.setOfNodesThatDependOnMe == null) continue;
            for (DependencyNode child : node.setOfNodesThatDependOnMe) {
                this.unvisitedIndependentSet.remove(child.value);
                ++child.numberOfNodesThatIDependOn;
            }
        }
        this.unvisitedIndependentSet = this.getAllIndependentValues();
    }

    public synchronized Set<T> getUnvisitedIndependentValues() {
        this.checkCycleState();
        this.visitedButNotDeletedCount += this.unvisitedIndependentSet.size();
        Set<T> returnCollection = this.unvisitedIndependentSet;
        this.unvisitedIndependentSet = new HashSet<T>();
        return returnCollection;
    }

    public synchronized Set<T> getAllIndependentValues() {
        HashSet set = new HashSet();
        for (DependencyNode node : this.nodeMap.values()) {
            if (node.numberOfNodesThatIDependOn != 0) continue;
            set.add(node.value);
        }
        return set;
    }

    public synchronized void remove(T value) {
        DependencyNode node = this.nodeMap.remove(value);
        if (node != null) {
            node.releaseDependencies();
            if (this.unvisitedIndependentSet.remove(value)) {
                --this.visitedButNotDeletedCount;
            }
        }
    }

    public synchronized Set<T> getDependentValues(T value) {
        HashSet set = new HashSet();
        DependencyNode node = this.nodeMap.get(value);
        if (node != null && node.setOfNodesThatDependOnMe != null) {
            for (DependencyNode child : node.setOfNodesThatDependOnMe) {
                set.add(child.value);
            }
        }
        return set;
    }

    private class DependencyNode {
        private final T value;
        private Set<DependencyNode> setOfNodesThatDependOnMe;
        private int numberOfNodesThatIDependOn = 0;

        DependencyNode(T value) {
            this.value = value;
        }

        public void releaseDependencies() {
            if (this.setOfNodesThatDependOnMe == null) {
                return;
            }
            for (DependencyNode node : this.setOfNodesThatDependOnMe) {
                if (--node.numberOfNodesThatIDependOn != 0) continue;
                DependencyGraph.this.unvisitedIndependentSet.add(node.value);
            }
        }

        public void addNodeThatDependsOnMe(DependencyNode node) {
            if (this.setOfNodesThatDependOnMe == null) {
                this.setOfNodesThatDependOnMe = new HashSet<DependencyNode>();
            }
            if (this.setOfNodesThatDependOnMe.add(node)) {
                ++node.numberOfNodesThatIDependOn;
                DependencyGraph.this.unvisitedIndependentSet.remove(node.value);
            }
        }

        public String toString() {
            return this.value == null ? "" : this.value.toString();
        }
    }
}

