/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.datastruct.PropertySetIndexRangeIterator;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.LongPropertySet;
import java.io.Serializable;

public class LongRangeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    LongPropertySet map = new LongPropertySet("RangeMap");

    public LongRangeMap() {
        this.map.putLong(0L, 0L);
    }

    public void paintRange(long start, long end, long value) {
        if (end != Long.MAX_VALUE) {
            long origEndValue = this.getValue(end + 1L);
            if (origEndValue != value) {
                this.map.putLong(end + 1L, origEndValue);
            } else {
                this.map.remove(end + 1L);
            }
        }
        LongIterator it = this.map.getPropertyIterator(start);
        while (it.hasNext()) {
            long next = it.next();
            if (next > end) continue;
            this.map.remove(next);
        }
        if (start == 0L) {
            this.map.putLong(0L, value);
        } else {
            long startValue = this.getValue(start);
            if (startValue != value) {
                this.map.putLong(start, value);
            }
        }
    }

    public long getValue(long index) {
        try {
            return this.map.getLong(index);
        }
        catch (NoValueException e) {
            try {
                index = this.map.getPreviousPropertyIndex(index);
                return this.map.getLong(index);
            }
            catch (NoSuchIndexException noSuchIndexException) {
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            return 0L;
        }
    }

    public IndexRangeIterator getIndexRangeIterator(long index) {
        return new PropertySetIndexRangeIterator(this.map, index);
    }

    public LongIterator getChangePointIterator(long start, long end) {
        return this.map.getPropertyIterator(start, end);
    }
}

