/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.VariableStorageDBAdapterNoTable;
import ghidra.program.database.symbol.VariableStorageDBAdapterV2;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class VariableStorageDBAdapter {
    static final String VARIABLE_STORAGE_TABLE_NAME = "Variable Storage";
    static final Schema VARIABLE_STORAGE_SCHEMA = new Schema(2, "Key", new Class[]{LongField.class, StringField.class}, new String[]{"Hash", "Storage"});
    static final int HASH_COL = 0;
    static final int STORAGE_COL = 1;

    VariableStorageDBAdapter() {
    }

    static VariableStorageDBAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new VariableStorageDBAdapterV2(dbHandle, true);
        }
        try {
            VariableStorageDBAdapterV2 adapter = new VariableStorageDBAdapterV2(dbHandle, false);
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            VariableStorageDBAdapter adapter = VariableStorageDBAdapter.findReadOnlyAdapter(dbHandle, addrMap, openMode);
            if (openMode == 3) {
                adapter = VariableStorageDBAdapterV2.upgrade(dbHandle, adapter, monitor);
            }
            return adapter;
        }
    }

    private static VariableStorageDBAdapter findReadOnlyAdapter(DBHandle dbHandle, AddressMap addrMap, int openMode) {
        Table table = dbHandle.getTable(VARIABLE_STORAGE_TABLE_NAME);
        if (table == null) {
            return new VariableStorageDBAdapterNoTable();
        }
        throw new AssertException("Variable storage table is from newer version");
    }

    abstract void updateRecord(Record var1) throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract long findRecordKey(long var1) throws IOException;

    abstract long getNextStorageID();

    abstract void deleteRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract int getRecordCount();
}

