/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.Record;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MappedMemoryBlock;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;

class OverlayMemoryBlockDB
extends MemoryBlockDB
implements MappedMemoryBlock {
    private boolean ioPending;
    private static final MemoryAccessException IOPENDING_EXCEPTION = new MemoryAccessException("Cyclic Access");
    private static final MemoryAccessException MEMORY_ACCESS_EXCEPTION = new MemoryAccessException("No memory at address");
    private Address overlayStart;
    private Address overlayEnd;
    private boolean bitOverlay;

    OverlayMemoryBlockDB(MemoryMapDBAdapter adapter, Record record, MemoryMapDB memMap) throws IOException {
        super(adapter, record, null, memMap);
    }

    @Override
    void refresh(Record lRecord) throws IOException {
        super.refresh(lRecord);
        this.bitOverlay = this.blockType == MemoryBlockType.BIT_MAPPED;
        long base = this.record.getLongValue(6);
        this.overlayStart = this.addrMap.decodeAddress(base);
        try {
            this.overlayEnd = this.overlayStart.addNoWrap(this.bitOverlay ? (this.length - 1L) / 8L : this.length - 1L);
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException("Overlay range extends beyond address space");
        }
    }

    @Override
    public Address getOverlayedMinAddress() {
        return this.overlayStart;
    }

    @Override
    Address getOverlayAddress(long offset) {
        return this.overlayStart.add(this.bitOverlay ? offset / 8L : offset);
    }

    private byte getBitOverlayByte(long blockOffset) throws AddressOverflowException, MemoryAccessException {
        Address otherAddr = this.overlayStart.addNoWrap(blockOffset / 8L);
        byte b = this.memMap.getByte(otherAddr);
        return (byte)(b >> (int)(blockOffset % 8L) & 1);
    }

    @Override
    public byte getByte(Address addr) throws MemoryAccessException {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            if (this.ioPending) {
                throw IOPENDING_EXCEPTION;
            }
            this.ioPending = true;
            long offset = this.getBlockOffset(addr);
            if (this.bitOverlay) {
                byte by = this.getBitOverlayByte(offset);
                return by;
            }
            byte by = this.memMap.getByte(this.overlayStart.addNoWrap(offset));
            return by;
        }
        catch (AddressOverflowException e) {
            throw MEMORY_ACCESS_EXCEPTION;
        }
        finally {
            this.ioPending = false;
            this.memMap.lock.release();
        }
    }

    @Override
    public int getBytes(Address addr, byte[] bytes, int off, int len) throws MemoryAccessException {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            if (this.ioPending) {
                throw IOPENDING_EXCEPTION;
            }
            this.ioPending = true;
            long offset = this.getBlockOffset(addr);
            long size = this.getSize();
            if ((long)len > size - addr.subtract(this.startAddress)) {
                len = (int)(size - addr.subtract(this.startAddress));
            }
            if (this.bitOverlay) {
                for (int i = 0; i < len; ++i) {
                    bytes[i + off] = this.getBitOverlayByte(offset++);
                }
                int n = len;
                return n;
            }
            int n = this.memMap.getBytes(this.overlayStart.addNoWrap(offset), bytes, off, len);
            return n;
        }
        catch (AddressOverflowException e) {
            throw MEMORY_ACCESS_EXCEPTION;
        }
        finally {
            this.ioPending = false;
            this.memMap.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByte(Address addr, byte b) throws MemoryAccessException {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            if (this.ioPending) {
                throw IOPENDING_EXCEPTION;
            }
            this.ioPending = true;
            long offset = this.getBlockOffset(addr);
            if (this.bitOverlay) {
                this.checkValid();
                this.doPutByte(this.overlayStart.add(offset / 8L), (int)(offset % 8L), b);
            } else {
                this.memMap.setByte(this.overlayStart.add(offset), b);
            }
        }
        finally {
            this.ioPending = false;
            this.memMap.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        this.memMap.lock.acquire();
        try {
            this.checkValid();
            if (this.ioPending) {
                throw IOPENDING_EXCEPTION;
            }
            this.ioPending = true;
            long offset = this.getBlockOffset(addr);
            long size = this.getSize();
            if ((long)len > size - addr.subtract(this.startAddress)) {
                len = (int)(size - addr.subtract(this.startAddress));
            }
            if (this.bitOverlay) {
                for (int i = 0; i < len; ++i) {
                    this.doPutByte(this.overlayStart.add(offset / 8L), (int)(offset % 8L), b[off + i]);
                    addr = addr.add(1L);
                    ++offset;
                }
            } else {
                this.memMap.setBytes(this.overlayStart.add(offset), b, off, len);
            }
            int n = len;
            return n;
        }
        finally {
            this.ioPending = false;
            this.memMap.lock.release();
        }
    }

    private void doPutByte(Address addr, int bitIndex, byte b) throws MemoryAccessException {
        this.ioPending = true;
        byte value = this.memMap.getByte(addr);
        int mask = 1 << bitIndex % 8;
        value = b == 0 ? (byte)(value & ~mask) : (byte)(value | mask);
        this.memMap.setByte(addr, value);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public AddressRange getOverlayedAddressRange() {
        return new AddressRangeImpl(this.overlayStart, this.overlayEnd);
    }
}

