/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.EnumDBAdapter;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.program.model.data.BitGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.EnumValuePartitioner;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.UniversalID;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.datastruct.ObjectLongHashtable;
import ghidra.util.exception.NoValueException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

class EnumDB
extends DataTypeDB
implements Enum {
    private EnumDBAdapter adapter;
    private EnumValueDBAdapter valueAdapter;
    private ObjectLongHashtable<String> nameMap;
    private LongObjectHashtable<String> valueMap;
    private List<BitGroup> bitGroups;

    EnumDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, EnumDBAdapter adapter, EnumValueDBAdapter valueAdapter, Record record) throws IOException {
        super(dataMgr, cache, record);
        this.adapter = adapter;
        this.valueAdapter = valueAdapter;
        this.nameMap = new ObjectLongHashtable();
        this.valueMap = new LongObjectHashtable();
        this.initialize();
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(2);
    }

    @Override
    protected String doGetName() {
        return this.record.getString(0);
    }

    private void initialize() throws IOException {
        this.bitGroups = null;
        this.nameMap.removeAll();
        this.valueMap.removeAll();
        long[] ids = this.valueAdapter.getValueIdsInEnum(this.key);
        for (int i = 0; i < ids.length; ++i) {
            Record rec = this.valueAdapter.getRecord(ids[i]);
            String valueName = rec.getString(0);
            long value = rec.getLongValue(1);
            this.nameMap.put((Object)valueName, value);
            this.valueMap.put(value, (Object)valueName);
        }
    }

    @Override
    public long getValue(String name) throws NoSuchElementException {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long l = this.nameMap.get((Object)name);
            return l;
        }
        catch (NoValueException e) {
            throw new NoSuchElementException(name + " does not exist in this enum");
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(long value) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = (String)this.valueMap.get(value);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    @Override
    public long[] getValues() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long[] values = this.valueMap.getKeys();
            Arrays.sort(values);
            long[] lArray = values;
            return lArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String[] getNames() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            Object[] names = (String[])this.nameMap.getKeys((Object[])new String[this.nameMap.size()]);
            Arrays.sort(names);
            Object[] objectArray = names;
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getCount() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.nameMap.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String name, long value) {
        this.lock.acquire();
        this.bitGroups = null;
        try {
            this.checkDeleted();
            if (this.nameMap.contains((Object)name)) {
                throw new IllegalArgumentException(name + " already exists in this enum");
            }
            try {
                this.valueAdapter.createRecord(this.key, name, value);
                this.nameMap.put((Object)name, value);
                if (!this.valueMap.contains(value)) {
                    this.valueMap.put(value, (Object)name);
                }
                this.adapter.updateRecord(this.record, true);
                this.dataMgr.dataTypeChanged(this);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String name) {
        this.lock.acquire();
        this.bitGroups = null;
        try {
            this.checkDeleted();
            if (!this.nameMap.contains((Object)name)) {
                return;
            }
            long value = this.nameMap.get((Object)name);
            this.nameMap.remove((Object)name);
            if (name.equals(this.valueMap.get(value))) {
                this.valueMap.remove(value);
            }
            long[] ids = this.valueAdapter.getValueIdsInEnum(this.key);
            for (int i = 0; i < ids.length; ++i) {
                Record rec = this.valueAdapter.getRecord(ids[i]);
                if (!name.equals(rec.getString(0))) continue;
                this.valueAdapter.removeRecord(ids[i]);
                break;
            }
            this.adapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        catch (NoValueException noValueException) {
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Enum)) {
            throw new IllegalArgumentException();
        }
        Enum enumm = (Enum)dataType;
        this.lock.acquire();
        this.bitGroups = null;
        try {
            this.checkDeleted();
            int oldLength = this.getLength();
            this.nameMap.removeAll();
            this.valueMap.removeAll();
            long[] ids = this.valueAdapter.getValueIdsInEnum(this.key);
            for (int i = 0; i < ids.length; ++i) {
                this.valueAdapter.removeRecord(ids[i]);
            }
            String[] names = enumm.getNames();
            for (int i = 0; i < names.length; ++i) {
                if (this.nameMap.contains((Object)names[i])) {
                    throw new IllegalArgumentException(names[i] + " already exists in this Enum");
                }
                long value = enumm.getValue(names[i]);
                this.valueAdapter.createRecord(this.key, names[i], value);
                this.nameMap.put((Object)names[i], value);
                this.valueMap.put(value, (Object)names[i]);
            }
            int newLength = enumm.getLength();
            this.record.setByteValue(3, (byte)newLength);
            this.adapter.updateRecord(this.record, true);
            if (oldLength != newLength) {
                this.notifySizeChanged();
            } else {
                this.dataMgr.dataTypeChanged(this);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        EnumDataType enumDataType = new EnumDataType(this.getCategoryPath(), this.getName(), this.getLength(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        enumDataType.setDescription(this.getDescription());
        enumDataType.replaceWith(this);
        return enumDataType;
    }

    @Override
    public String getMnemonic(Settings settings) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.getDisplayName();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            byte by = this.record.getByteValue(3);
            return by;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDescription() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String s = this.record.getString(1);
            String string = s == null ? "" : s;
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setDescription(String description) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setString(1, description);
            this.adapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long value = 0L;
            switch (this.getLength()) {
                case 1: {
                    value = buf.getByte(0);
                    break;
                }
                case 2: {
                    value = buf.getShort(0);
                    break;
                }
                case 4: {
                    value = buf.getInt(0);
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            Scalar scalar = new Scalar(length * 8, value);
            return scalar;
        }
        catch (MemoryAccessException e) {
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Scalar.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long value = 0L;
            switch (this.getLength()) {
                case 1: {
                    value = (long)buf.getByte(0) & 0xFFL;
                    break;
                }
                case 2: {
                    value = (long)buf.getShort(0) & 0xFFFFL;
                    break;
                }
                case 4: {
                    value = (long)buf.getInt(0) & 0xFFFFFFFFL;
                    break;
                }
                case 8: {
                    value = buf.getLong(0);
                }
            }
            String valueName = this.getName(value);
            if (valueName == null) {
                valueName = this.getCompoundValue(value);
            }
            String string = valueName;
            return string;
        }
        catch (MemoryAccessException e) {
            String string = "??";
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    private String getCompoundValue(long value) {
        if (value == 0L) {
            return "0";
        }
        List<BitGroup> list = this.getBitGroups();
        StringBuffer buf = new StringBuffer();
        for (BitGroup bitGroup : list) {
            long subValue = bitGroup.getMask() & value;
            if (subValue == 0L) continue;
            String part = this.getName(subValue);
            if (part == null) {
                part = this.getStringForNoMatchingValue(subValue);
            }
            if (buf.length() != 0) {
                buf.append(" | ");
            }
            buf.append(part);
        }
        return buf.toString();
    }

    private List<BitGroup> getBitGroups() {
        if (this.bitGroups == null) {
            this.bitGroups = EnumValuePartitioner.partition(this.getValues());
        }
        return this.bitGroups;
    }

    private String getStringForNoMatchingValue(long value) {
        Object valueStr = value < 0L || value >= 32L ? "0x" + Long.toHexString(value) : Long.toString(value);
        String valueName = (String)valueStr;
        return valueName;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Enum)) {
            return false;
        }
        this.checkIsValid();
        Enum enumm = (Enum)dt;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getName(), enumm.getName()) || this.getLength() != enumm.getLength() || this.getCount() != enumm.getCount()) {
            return false;
        }
        String[] names = this.getNames();
        String[] otherNames = enumm.getNames();
        try {
            for (int i = 0; i < names.length; ++i) {
                long value = this.getValue(names[i]);
                long otherValue = enumm.getValue(names[i]);
                if (names[i].equals(otherNames[i]) && value == otherValue) continue;
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean refresh() {
        try {
            Record rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.initialize();
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(2, categoryID);
        this.adapter.updateRecord(this.record, false);
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(0, name);
        this.adapter.updateRecord(this.record, true);
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(7);
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(6);
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(5));
    }

    @Override
    protected void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(5, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(4));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(4, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, lastChangeTime);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, lastChangeTimeInSourceArchive);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }
}

