/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakHashMap2<K, V>
extends AbstractMap<K, V> {
    private Map<K, WeakValue<V>> hash;
    private Map<WeakValue<V>, K> reverseHash;
    private ReferenceQueue<V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet = null;

    private void processQueue() {
        WeakValue wk;
        while ((wk = (WeakValue)this.queue.poll()) != null) {
            K k = this.reverseHash.remove(wk);
            if (k == null) continue;
            this.hash.remove(k);
        }
    }

    public WeakHashMap2(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, WeakValue<V>>(initialCapacity, loadFactor);
        this.reverseHash = new HashMap<WeakValue<V>, K>(initialCapacity, loadFactor);
    }

    public WeakHashMap2(int initialCapacity) {
        this.hash = new HashMap<K, WeakValue<V>>(initialCapacity);
        this.reverseHash = new HashMap<WeakValue<V>, K>(initialCapacity);
    }

    public WeakHashMap2() {
        this.hash = new HashMap<K, WeakValue<V>>();
        this.reverseHash = new HashMap<WeakValue<V>, K>();
    }

    public WeakHashMap2(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    @Override
    public V get(Object key) {
        WeakValue<V> v = this.hash.get(key);
        return v != null ? (V)v.get() : null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValue<V> v = this.hash.get(key);
        V oldValue = null;
        if (v != null) {
            this.reverseHash.remove(v);
            oldValue = (V)v.get();
        }
        v = WeakValue.create(value, this.queue);
        this.reverseHash.put((WeakValue<K>)v, (WeakValue<V>)key);
        this.hash.put(key, v);
        return oldValue;
    }

    public K reverseGet(V value) {
        WeakValue<V> v = WeakValue.create(value, this.queue);
        return this.reverseHash.get(v);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        WeakValue<V> v = this.hash.get(key);
        V oldValue = null;
        if (v != null) {
            this.reverseHash.remove(v);
            this.hash.remove(key);
            oldValue = (V)v.get();
        }
        return oldValue;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.reverseHash.clear();
        this.hash.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private Set<Map.Entry<K, WeakValue<V>>> hashEntrySet;

        public EntrySet() {
            this.hashEntrySet = WeakHashMap2.this.hash.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, WeakValue<V>>> hashIterator;
                Entry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        WeakValue wv = ent.getValue();
                        Object v = null;
                        if (wv != null) {
                            Object t = wv.get();
                            v = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent.getKey(), v);
                        return true;
                    }
                    return false;
                }

                @Override
                public Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            WeakHashMap2.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object key = e.getKey();
            WeakValue v = WeakHashMap2.this.hash.get(key);
            if (v != null) {
                WeakHashMap2.this.reverseHash.remove(v);
                WeakHashMap2.this.hash.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                WeakValue v;
                h += ent.getKey().hashCode() ^ ((v = ent.getValue()) == null ? 0 : ((Object)v).hashCode());
            }
            return h;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class WeakValue<Z>
    extends WeakReference<Z> {
        private int hash;

        private WeakValue(Z z, ReferenceQueue<Z> q) {
            super(z, q);
            this.hash = z.hashCode();
        }

        private static <Z> WeakValue<Z> create(Z z, ReferenceQueue<Z> q) {
            if (z == null) {
                return null;
            }
            return new WeakValue<Z>(z, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            WeakValue other = (WeakValue)o;
            return this.get() == other.get();
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

