/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolUtf8Info
extends AbstractConstantPoolInfoJava {
    private short length;
    private byte[] bytes;

    public ConstantPoolUtf8Info(BinaryReader reader) throws IOException {
        super(reader);
        this.length = reader.readNextShort();
        this.bytes = reader.readNextByteArray((int)this.length);
    }

    public short getLength() {
        return this.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getString() {
        return new String(this.bytes);
    }

    public String toString() {
        return this.getString();
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_Utf8_info|" + this.length + "|";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "length", null);
        if (this.length > 0) {
            structure.add(UTF8, (int)this.length, "data", null);
        }
        return structure;
    }
}

