/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jnacontrib.win32.Win32Service;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.StopableService;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessFactory;
import org.rzo.yajsw.wrapper.WrappedProcessList;

public class WrapperMainServiceWin
extends Win32Service
implements StopableService {
    static volatile WrappedProcessList wList = new WrappedProcessList();
    static volatile WrappedProcess w;
    static volatile boolean _waitOnStop;
    static WrapperMainServiceWin service;
    static ExecutorService pool;

    private static int getPriority(YajswConfigurationImpl config) {
        String priority = config.getString("wrapper.ntservice.process_priority", "");
        if ("LOW".equals(priority)) {
            return -2;
        }
        if ("BELOW_NORMAL".equals(priority)) {
            return -1;
        }
        if ("NORMAL".equals(priority)) {
            return 0;
        }
        if ("ABOVE_NORMAL".equals(priority)) {
            return 1;
        }
        if ("HIGH".equals(priority)) {
            return 2;
        }
        return -99;
    }

    public static void main(String[] args) {
        YajswConfigurationImpl _config;
        boolean dbg;
        String wrapperJar = WrapperLoader.getWrapperJar();
        String homeDir = new File(wrapperJar).getParent();
        if (!OperatingSystem.instance().setWorkingDir(homeDir)) {
            System.out.println("could not set working dir. pls check configuration or user rights :" + homeDir);
        }
        int debug = (dbg = (_config = new YajswConfigurationImpl(false)).getBoolean("wrapper.debug", false)) ? _config.getInt("wrapper.debug.level", 3) : 0;
        service = new WrapperMainServiceWin();
        service.setServiceName(_config.getString("wrapper.ntservice.name"));
        long timeout = _config.getInt("wrapper.shutdown.timeout", 30) * 1000;
        int t1 = _config.getInt("wrapper.script.STOP.timeout", 0) * 1000;
        int t2 = _config.getInt("wrapper.script.SHUTDOWN.timeout", 0) * 1000;
        int t3 = _config.getInt("wrapper.script.IDLE.timeout", 0) * 1000;
        int t4 = _config.getInt("wrapper.script.ABORT.timeout", 0) * 1000;
        timeout += (long)t1;
        timeout += (long)t2;
        timeout += (long)t3;
        if ((timeout += (long)t4) > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        service.setStopTimeout((int)timeout);
        timeout = _config.getInt("wrapper.startup.timeout", 30) * 1000;
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        service.setStartupTimeout((int)timeout);
        service.setAutoReportStartup(_config.getBoolean("wrapper.ntservice.autoreport.startup", true));
        if (_config.containsKey("wrapperx.config")) {
            List configs = _config.getList("wrapperx.config");
            wList = WrappedProcessFactory.createProcessList(new HashMap(), (List)configs, (boolean)true);
            for (WrappedProcess p : wList) {
                p.setService((Object)service);
            }
        } else {
            WrappedProcess w = WrappedProcessFactory.createProcess((YajswConfiguration)_config);
            w.setService((Object)service);
            w.init();
            wList.add((Object)w);
        }
        w = (WrappedProcess)wList.get(0);
        int priority = WrapperMainServiceWin.getPriority(_config);
        if (priority != -1) {
            int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
            WindowsXPProcess.setProcessPriority((int)myPid, (int)priority);
        }
        final long maxStartTime = w.getMaxStartTime();
        long startDelay = _config.getLong("wrapper.ntservice.delay", 0L);
        w.getWrapperLogger().info("start delay: " + startDelay);
        long bootDelay = 0L;
        if (startDelay > 0L) {
            long uptime = OperatingSystem.instance().getUptime();
            long d = startDelay - uptime;
            w.getWrapperLogger().info("d: " + d + " uptime " + uptime);
            if (d > 0L) {
                bootDelay = d * 1000L;
            }
        }
        final long delay = bootDelay;
        final Future<?> future = pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (delay > 0L) {
                        w.getWrapperLogger().info("delay app startup: " + delay / 1000L + " sec");
                        Thread.sleep(delay);
                    }
                    Thread.yield();
                    wList.startAll();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    w.getWrapperLogger().info("Win Service: error starting wrapper " + ex.getMessage());
                    Runtime.getRuntime().halt(999);
                }
            }
        });
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    future.get(maxStartTime + delay, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    w.getWrapperLogger().info("Win Service: wrapper did not start within " + (maxStartTime + delay) + " ms " + ex.getMessage());
                    Runtime.getRuntime().halt(999);
                }
            }
        });
        if (debug > 2) {
            w.getWrapperLogger().info("Win service: before service init");
        }
        service.setDebug(debug);
        service.init();
        if (debug > 0) {
            w.getWrapperLogger().info("Win service: terminated correctly");
        }
        try {
            if (_config.getBoolean("wrapper.update.auto", false)) {
                w.update(null, false);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Runtime.getRuntime().halt(0);
    }

    public void onStart() {
        this.log("onstart", 2);
    }

    public void onStop() {
        pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    w.getWrapperLogger().info("Win service stop - timeout: " + service.getStopTimeout());
                    if (w.isHaltAppOnWrapper()) {
                        w.getWrapperLogger().info("Win service wrapper.control -> stopping application");
                        wList.removeStateChangeListener(0);
                        wList.stopAll(WrapperMainServiceWin.this._stopReason);
                    }
                    wList.shutdown();
                    w.getWrapperLogger().info("Win service stop - after shutdown");
                    Object object = WrapperMainServiceWin.this.waitObject;
                    synchronized (object) {
                        w.getWrapperLogger().info("Win service stop - before notify");
                        WrapperMainServiceWin.this.waitObject.notifyAll();
                    }
                    w.getWrapperLogger().info("Win service terminated");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    w.getWrapperLogger().throwing(this.getClass().getName(), "error in win service doStop", e);
                }
            }
        });
    }

    public void log(String txt, int level) {
        if (this._debug > level && w != null && w.getWrapperLogger() != null) {
            w.getWrapperLogger().info(txt);
        }
    }

    public void waitOnStop() {
        int i = 0;
        try {
            while (!_waitOnStop && i++ < 20) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        _waitOnStop = false;
        pool = Executors.newFixedThreadPool(5);
    }
}

