/*
 * Decompiled with CFR 0.152.
 */
package help;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class JavaHelpSetBuilder {
    private static final String TAB = "\t";
    private static final Set<String> searchFileNames = new HashSet<String>(Arrays.asList("DOCS", "DOCS.TAB", "OFFSETS", "POSITIONS", "SCHEMA", "TMAP"));
    private static int indentionLevel;
    private final String moduleName;
    private final Path mapFile;
    private final Path tocFile;
    private final Path searchDirectory;
    private final Path helpSetFile;

    public JavaHelpSetBuilder(String moduleName, Path helpMapFile, Path helpTOCFile, Path indexerOutputDirectory, Path helpSetFile2) {
        this.moduleName = moduleName;
        this.mapFile = helpMapFile;
        this.tocFile = helpTOCFile;
        this.searchDirectory = indexerOutputDirectory;
        this.helpSetFile = helpSetFile2;
    }

    public void writeHelpSetFile() throws IOException {
        BufferedWriter writer = null;
        try {
            OutputStreamWriter osw = new OutputStreamWriter(Files.newOutputStream(this.helpSetFile, new OpenOption[0]));
            writer = new BufferedWriter(osw);
            JavaHelpSetBuilder.generateFileHeader(writer, this.moduleName);
            JavaHelpSetBuilder.writeMapEntry(this.mapFile, writer);
            JavaHelpSetBuilder.writeTOCEntry(this.tocFile, writer);
            JavaHelpSetBuilder.writeSearchEntry(this.searchDirectory, writer);
            JavaHelpSetBuilder.writeFavoritesEntry(writer);
            JavaHelpSetBuilder.generateFileFooter(writer);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeMapEntry(Path helpSetMapFile, BufferedWriter writer) throws IOException {
        JavaHelpSetBuilder.writeLine("<maps>", writer);
        ++indentionLevel;
        JavaHelpSetBuilder.writeLine("<mapref location=\"" + helpSetMapFile.getFileName() + "\" />", writer);
        --indentionLevel;
        JavaHelpSetBuilder.writeLine("</maps>", writer);
    }

    private static void writeTOCEntry(Path helpSetTOCFile, BufferedWriter writer) throws IOException {
        JavaHelpSetBuilder.writeLine("<view mergetype=\"javax.help.UniteAppendMerge\">", writer);
        ++indentionLevel;
        JavaHelpSetBuilder.writeLine("<name>TOC</name>", writer);
        JavaHelpSetBuilder.writeLine("<label>Ghidra Table of Contents</label>", writer);
        JavaHelpSetBuilder.writeLine("<type>docking.help.CustomTOCView</type>", writer);
        JavaHelpSetBuilder.writeLine("<data>" + helpSetTOCFile.getFileName() + "</data>", writer);
        --indentionLevel;
        JavaHelpSetBuilder.writeLine("</view>", writer);
    }

    private static void writeSearchEntry(Path helpSearchDirectory, BufferedWriter writer) throws IOException {
        if (!Files.exists(helpSearchDirectory, new LinkOption[0])) {
            return;
        }
        JavaHelpSetBuilder.writeLine("<view>", writer);
        ++indentionLevel;
        JavaHelpSetBuilder.writeLine("<name>Search</name>", writer);
        JavaHelpSetBuilder.writeLine("<label>Search for Keywords</label>", writer);
        JavaHelpSetBuilder.writeLine("<type>docking.help.CustomSearchView</type>", writer);
        if (JavaHelpSetBuilder.hasIndexerFiles(helpSearchDirectory)) {
            JavaHelpSetBuilder.writeLine("<data engine=\"com.sun.java.help.search.DefaultSearchEngine\">" + helpSearchDirectory.getFileName() + "</data>", writer);
        }
        --indentionLevel;
        JavaHelpSetBuilder.writeLine("</view>", writer);
    }

    private static boolean hasIndexerFiles(Path helpSearchDirectory) {
        HashSet<String> found = new HashSet<String>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(helpSearchDirectory);){
            for (Path file : ds) {
                found.add(file.getFileName().toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return searchFileNames.equals(found);
    }

    private static void writeFavoritesEntry(BufferedWriter writer) throws IOException {
        JavaHelpSetBuilder.writeLine("<view>", writer);
        ++indentionLevel;
        JavaHelpSetBuilder.writeLine("<name>Favorites</name>", writer);
        JavaHelpSetBuilder.writeLine("<label>Ghidra Favorites</label>", writer);
        JavaHelpSetBuilder.writeLine("<type>docking.help.CustomFavoritesView</type>", writer);
        --indentionLevel;
        JavaHelpSetBuilder.writeLine("</view>", writer);
    }

    private static void generateFileHeader(BufferedWriter writer, String moduleName) throws IOException {
        writer.write("<?xml version='1.0' encoding='ISO-8859-1' ?>");
        writer.newLine();
        writer.write("<!DOCTYPE helpset PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 2.0//EN\" \"http://java.sun.com/products/javahelp/helpset_2_0.dtd\">");
        writer.newLine();
        writer.newLine();
        writer.write("<!-- HelpSet auto-generated on " + new Date().toString() + " -->");
        writer.newLine();
        writer.write("<helpset version=\"2.0\">");
        writer.newLine();
        ++indentionLevel;
        JavaHelpSetBuilder.writeIndentation(writer);
        writer.write("<title>" + moduleName + " HelpSet</title>");
        writer.newLine();
    }

    private static void generateFileFooter(BufferedWriter writer) throws IOException {
        --indentionLevel;
        writer.write("</helpset>");
        writer.newLine();
    }

    private static void writeLine(String text, BufferedWriter writer) throws IOException {
        JavaHelpSetBuilder.writeIndentation(writer);
        writer.write(text);
        writer.newLine();
    }

    private static void writeIndentation(BufferedWriter writer) throws IOException {
        for (int i = 0; i < indentionLevel; ++i) {
            writer.write(TAB);
        }
    }
}

