/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.util.exception.DuplicateNameException;

class OffsetAddressFactory
extends DefaultAddressFactory {
    OffsetAddressFactory(AddressFactory baseFactory) {
        super(baseFactory.getAllAddressSpaces());
    }

    private int getNextUniqueID() {
        int maxID = 0;
        AddressSpace[] spaces = this.getAllAddressSpaces();
        for (int i = 0; i < spaces.length; ++i) {
            maxID = Math.max(maxID, spaces[i].getUnique());
        }
        return maxID + 1;
    }

    public AddressSpace createNewOffsetSpace(String name) {
        AddressSpace space = null;
        try {
            space = new GenericAddressSpace(name, this.getConstantSpace().getSize(), 9, this.getNextUniqueID());
            super.addAddressSpace(space);
        }
        catch (DuplicateNameException e) {
            space = this.getAddressSpace(name);
        }
        return space;
    }

    public static boolean isSymbolSpace(int spaceID) {
        int type = 0xF & spaceID;
        return type == 9;
    }
}

