/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SegmentCommand
extends LoadCommand {
    private String segname;
    private long vmaddr;
    private long vmsize;
    private long fileoff;
    private long filesize;
    private int maxprot;
    private int initprot;
    private int nsects;
    private int flags;
    private boolean is32bit;
    private List<Section> sections = new ArrayList<Section>();

    public static SegmentCommand createSegmentCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        SegmentCommand segmentCommand = (SegmentCommand)reader.getFactory().create(SegmentCommand.class, new Object[0]);
        segmentCommand.initSegmentCommand(reader, is32bit);
        return segmentCommand;
    }

    private void initSegmentCommand(FactoryBundledWithBinaryReader reader, boolean is32bit) throws IOException {
        this.initLoadCommand(reader);
        this.is32bit = is32bit;
        this.segname = reader.readNextAsciiString(16);
        if (is32bit) {
            this.vmaddr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.vmsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.fileoff = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.filesize = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else {
            this.vmaddr = reader.readNextLong();
            this.vmsize = reader.readNextLong();
            this.fileoff = reader.readNextLong();
            this.filesize = reader.readNextLong();
        }
        this.maxprot = reader.readNextInt();
        this.initprot = reader.readNextInt();
        this.nsects = reader.readNextInt();
        this.flags = reader.readNextInt();
        for (int i = 0; i < this.nsects; ++i) {
            this.sections.add(Section.createSection(reader, is32bit));
        }
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public Section getSectionContaining(Address address) {
        long offset = address.getOffset();
        for (Section section : this.sections) {
            long start = section.getAddress();
            long end = start + section.getSize();
            if (offset < start || offset > end) continue;
            return section;
        }
        return null;
    }

    public Section getSectionByName(String sectionName) {
        for (Section section : this.sections) {
            if (!section.getSectionName().equals(sectionName)) continue;
            return section;
        }
        return null;
    }

    public String getSegmentName() {
        return this.segname;
    }

    public long getVMaddress() {
        return this.vmaddr;
    }

    public long getVMsize() {
        return this.vmsize;
    }

    public long getFileOffset() {
        return this.fileoff;
    }

    public long getFileSize() {
        return this.filesize;
    }

    public int getMaxProtection() {
        return this.maxprot;
    }

    public int getInitProtection() {
        return this.initprot;
    }

    public boolean isRead() {
        return (this.initprot & 1) != 0;
    }

    public boolean isWrite() {
        return (this.initprot & 2) != 0;
    }

    public boolean isExecute() {
        return (this.initprot & 4) != 0;
    }

    public int getNumberOfSections() {
        return this.nsects;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isAppleProtected() {
        return (this.flags & 8) != 0;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add((DataType)new StringDataType(), 16, "segname", null);
        if (this.is32bit) {
            struct.add(DWORD, "vmaddr", null);
            struct.add(DWORD, "vmsize", null);
            struct.add(DWORD, "fileoff", null);
            struct.add(DWORD, "filesize", null);
        } else {
            struct.add(QWORD, "vmaddr", null);
            struct.add(QWORD, "vmsize", null);
            struct.add(QWORD, "fileoff", null);
            struct.add(QWORD, "filesize", null);
        }
        struct.add(DWORD, "maxprot", null);
        struct.add(DWORD, "initprot", null);
        struct.add(DWORD, "nsects", null);
        struct.add(DWORD, "flags", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "segment_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                DataType segmentDT = this.toDataType();
                api.createData(addr, segmentDT);
                api.setPlateComment(addr, this.getSegmentName());
                Address sectionAddress = addr.add((long)segmentDT.getLength());
                for (Section section : this.sections) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    DataType sectionDT = section.toDataType();
                    api.createData(sectionAddress, sectionDT);
                    api.setPlateComment(sectionAddress, section.toString());
                    sectionAddress = sectionAddress.add((long)sectionDT.getLength());
                    if (section.getType() == 1 || header.getFileType() == 9) continue;
                    Address sectionByteAddr = baseAddress.add((long)section.getOffset());
                    if (section.getSize() > 0L) {
                        api.createLabel(sectionByteAddr, section.getSectionName(), true, SourceType.IMPORTED);
                        api.createFragment(parentModule, "SECTION_BYTES", sectionByteAddr, section.getSize());
                    }
                    if (section.getRelocationOffset() <= 0) continue;
                    Address relocStartAddr = baseAddress.add((long)section.getRelocationOffset());
                    long offset = 0L;
                    List<RelocationInfo> relocations = section.getRelocations();
                    for (RelocationInfo reloc : relocations) {
                        if (monitor.isCancelled()) {
                            return;
                        }
                        DataType relocDT = reloc.toDataType();
                        Address relocAddr = relocStartAddr.add(offset);
                        api.createData(relocAddr, relocDT);
                        api.setPlateComment(relocAddr, reloc.toString());
                        offset += (long)relocDT.getLength();
                    }
                    api.createFragment(parentModule, section.getSectionName() + "_Relocations", relocStartAddr, offset);
                }
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    public String toString() {
        return this.getSegmentName();
    }
}

