/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.html.ArrayDataTypeHTMLRepresentation;
import ghidra.app.util.html.CompositeDataTypeHTMLRepresentation;
import ghidra.app.util.html.DefaultDataTypeHTMLRepresentation;
import ghidra.app.util.html.EnumDataTypeHTMLRepresentation;
import ghidra.app.util.html.FunctionDataTypeHTMLRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.NullDataTypeHTMLRepresentation;
import ghidra.app.util.html.PointerDataTypeHTMLRepresentation;
import ghidra.app.util.html.TypeDefDataTypeHTMLRepresentation;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ToolTipUtils {
    private static Color PARAM_NAME_COLOR = new Color(155, 50, 155);
    private static Color PARAM_CUSTOM_STORAGE_COLOR = OptionsGui.PARAMETER_CUSTOM.getDefaultColor();
    private static Color PARAM_DYNAMIC_STORAGE_COLOR = OptionsGui.PARAMETER_DYNAMIC.getDefaultColor();
    private static int PARAM_LENGTH_WRAP_THRESHOLD = 80;

    private ToolTipUtils() {
    }

    public static String getToolTipText(DataType dataType) {
        return ToolTipUtils.getHTMLRepresentation(dataType).getHTMLString();
    }

    public static HTMLDataTypeRepresentation getHTMLRepresentation(DataType dataType) {
        if (dataType != null) {
            if (dataType instanceof TypeDef) {
                return new TypeDefDataTypeHTMLRepresentation((TypeDef)dataType);
            }
            if (dataType instanceof Composite) {
                return new CompositeDataTypeHTMLRepresentation((Composite)dataType);
            }
            if (dataType instanceof Enum) {
                return new EnumDataTypeHTMLRepresentation((Enum)dataType);
            }
            if (dataType instanceof FunctionDefinition) {
                return new FunctionDataTypeHTMLRepresentation((FunctionDefinition)dataType);
            }
            if (dataType instanceof Pointer) {
                return new PointerDataTypeHTMLRepresentation((Pointer)dataType);
            }
            if (dataType instanceof Array) {
                return new ArrayDataTypeHTMLRepresentation((Array)dataType);
            }
            return new DefaultDataTypeHTMLRepresentation(dataType);
        }
        return new NullDataTypeHTMLRepresentation();
    }

    public static String getToolTipText(ExternalLocation extLoc, boolean includeSymbolDetails) {
        DataType dt;
        if (extLoc.isFunction()) {
            return ToolTipUtils.getToolTipText(extLoc.getFunction(), includeSymbolDetails);
        }
        Symbol s = extLoc.getSymbol();
        StringBuilder buf = new StringBuilder("<HTML>");
        buf.append("External").append(HTMLUtilities.HTML_SPACE);
        if (includeSymbolDetails) {
            buf.append("Data");
            buf.append(HTMLUtilities.HTML_SPACE).append("-").append(HTMLUtilities.HTML_SPACE);
            buf.append(HTMLUtilities.friendlyEncodeHTML((String)s.getName(true)));
            Address addr = extLoc.getAddress();
            if (addr != null) {
                buf.append(HTMLUtilities.HTML_SPACE).append("@").append(HTMLUtilities.HTML_SPACE);
                buf.append(addr.toString(true));
            }
            buf.append("<BR>");
        }
        if ((dt = extLoc.getDataType()) == null) {
            dt = DataType.DEFAULT;
        }
        buf.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)dt.getName())));
        buf.append(HTMLUtilities.HTML_SPACE);
        buf.append(HTMLUtilities.friendlyEncodeHTML((String)s.getName()));
        return buf.toString();
    }

    public static String getToolTipText(Function function, boolean includeSymbolDetails) {
        String originalImportedName;
        StringBuilder buf = new StringBuilder("<HTML>");
        ExternalLocation extLoc = function.getExternalLocation();
        if (extLoc != null) {
            buf.append("External").append(HTMLUtilities.HTML_SPACE);
        } else if (function.isThunk()) {
            buf.append("Thunk").append(HTMLUtilities.HTML_SPACE);
        }
        if (includeSymbolDetails) {
            Address addr;
            buf.append("Function");
            buf.append(HTMLUtilities.HTML_SPACE).append("-").append(HTMLUtilities.HTML_SPACE);
            buf.append(HTMLUtilities.friendlyEncodeHTML((String)function.getSymbol().getName(true)));
            if (extLoc != null && (addr = extLoc.getAddress()) != null) {
                buf.append(HTMLUtilities.HTML_SPACE).append("@").append(HTMLUtilities.HTML_SPACE);
                buf.append(addr.toString(true));
            }
            buf.append("<BR>");
        }
        buf.append(ToolTipUtils.getFunctionSignaturePreview(function));
        buf.append("<BR>");
        buf.append("<table cellspacing=0 callpadding=0 border=0>");
        buf.append(ToolTipUtils.getParameterDetailRow(function.getReturn()));
        for (Address p : function.getParameters()) {
            buf.append(ToolTipUtils.getParameterDetailRow((Parameter)p));
        }
        if (extLoc != null && (originalImportedName = extLoc.getOriginalImportedName()) != null) {
            buf.append("Imported").append(HTMLUtilities.HTML_SPACE).append("Name:").append(HTMLUtilities.HTML_SPACE).append(HTMLUtilities.friendlyEncodeHTML((String)originalImportedName));
        }
        buf.append("</table></html>");
        return buf.toString();
    }

    private static String getParameterDetailRow(Parameter param) {
        StringBuilder buf = new StringBuilder();
        buf.append("<tr><td width=10>&nbsp;</td>");
        buf.append("<td width=\"1%\">");
        buf.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)param.getDataType().getName())));
        buf.append("</td><td width=\"1%\">");
        Color paramColor = param.getFunction().hasCustomVariableStorage() ? PARAM_CUSTOM_STORAGE_COLOR : PARAM_DYNAMIC_STORAGE_COLOR;
        buf.append(HTMLUtilities.colorString((Color)paramColor, (String)HTMLUtilities.friendlyEncodeHTML((String)param.getVariableStorage().toString())));
        buf.append("</td><td width=\"1%\">");
        buf.append(HTMLUtilities.colorString((Color)PARAM_NAME_COLOR, (String)HTMLUtilities.friendlyEncodeHTML((String)param.getName())));
        buf.append("</td><td width=\"100%\">&nbsp;</td></tr>");
        return buf.toString();
    }

    private static String getFunctionSignaturePreview(Function function) {
        StringBuffer buf = new StringBuffer();
        if (function.hasNoReturn()) {
            buf.append("noreturn").append(HTMLUtilities.HTML_SPACE);
        }
        buf.append(HTMLUtilities.friendlyEncodeHTML((String)function.getReturnType().getName()));
        buf.append(HTMLUtilities.HTML_SPACE);
        PrototypeModel callingConvention = function.getCallingConvention();
        if (ToolTipUtils.isNonDefaultCallingConvention(callingConvention)) {
            buf.append(HTMLUtilities.friendlyEncodeHTML((String)callingConvention.getName()));
            buf.append(HTMLUtilities.HTML_SPACE);
        }
        buf.append(HTMLUtilities.colorString((Color)Color.BLUE, (String)HTMLUtilities.friendlyEncodeHTML((String)function.getName())));
        buf.append(HTMLUtilities.HTML_SPACE).append("(");
        ToolTipUtils.buildParameterPreview(function, buf);
        return buf.toString();
    }

    private static boolean isNonDefaultCallingConvention(PrototypeModel callingConvention) {
        if (callingConvention == null) {
            return false;
        }
        return !"default".equals(callingConvention.getName());
    }

    private static void buildParameterPreview(Function function, StringBuffer bufffy) {
        String s;
        int rawTextLength = 0;
        Parameter[] parameters = function.getParameters();
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter param : parameters) {
            StringBuilder pb = new StringBuilder();
            String type = param.getDataType().getName();
            pb.append(HTMLUtilities.colorString((Color)Color.BLACK, (String)HTMLUtilities.friendlyEncodeHTML((String)type)));
            pb.append(HTMLUtilities.HTML_SPACE);
            String name = param.getName();
            pb.append(HTMLUtilities.colorString((Color)PARAM_NAME_COLOR, (String)HTMLUtilities.friendlyEncodeHTML((String)name)));
            params.add(pb.toString());
            rawTextLength += type.length() + 1 + name.length();
        }
        if (function.hasVarArgs()) {
            s = "...";
            params.add(s);
            rawTextLength += s.length();
        } else if (parameters.length == 0) {
            s = "void";
            params.add(s);
            rawTextLength += s.length();
        }
        if (rawTextLength > PARAM_LENGTH_WRAP_THRESHOLD) {
            StringBuilder psb = new StringBuilder("<table cellspacing=0 callpadding=0 border=0>");
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                if (i == 0) {
                    bufffy.append(param).append(",");
                    continue;
                }
                psb.append("<tr><td width=75px></td><td>");
                psb.append(param).append(i < params.size() - 1 ? (char)',' : ')');
                psb.append("</td></tr>");
            }
            bufffy.append(psb.toString());
            bufffy.append("</table>");
        } else {
            bufffy.append(StringUtils.join(params, (String)("," + HTMLUtilities.HTML_SPACE)));
            bufffy.append(')');
        }
    }
}

