/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigationUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class SelectBlockDialog
extends DialogComponentProvider {
    private static final String OVERFLOW_SELECTION_WARNING = "Selection is larger than available bytes, using the end of the address space";
    private JTextField toAddressField;
    private IntegerTextField numberInputField;
    private JRadioButton forwardButton;
    private JRadioButton backwardButton;
    private JRadioButton allButton;
    private JRadioButton toButton;
    private Navigatable navigatable;
    private PluginTool tool;

    SelectBlockDialog(PluginTool tool, Navigatable navigatable) {
        super("Select Bytes", false);
        this.tool = tool;
        this.navigatable = navigatable;
        this.addWorkPanel(this.buildPanel());
        this.addOKButton();
        this.setOkButtonText("Select Bytes");
        this.addDismissButton();
        this.setHelpLocation(new HelpLocation("SelectBlockPlugin", "Select_Block_Help"));
        this.setItemsEnabled(false);
        this.forwardButton.doClick();
    }

    private JPanel buildPanel() {
        this.setDefaultButton(this.okButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        mainPanel.add((Component)this.methodPanel(), gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.buildBlockPanel(), gbc);
        return mainPanel;
    }

    private JPanel buildBlockPanel() {
        JPanel main = new JPanel();
        main.setBorder(BorderFactory.createTitledBorder("Byte Selection"));
        main.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        main.add((Component)new JLabel("Ending Address:"), gbc);
        ++gbc.gridx;
        this.toAddressField = new JTextField(10);
        main.add((Component)this.toAddressField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        main.add((Component)new JLabel("Length: "), gbc);
        ++gbc.gridx;
        this.numberInputField = new IntegerTextField(10);
        this.numberInputField.setMaxValue(BigInteger.valueOf(Integer.MAX_VALUE));
        this.numberInputField.setAllowNegativeValues(false);
        main.add((Component)this.numberInputField.getComponent(), gbc);
        return main;
    }

    private JPanel methodPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel main = new JPanel();
        main.setBorder(BorderFactory.createTitledBorder("By Method"));
        main.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.forwardButton = new JRadioButton("Select Forward", true);
        this.forwardButton.setName("forwardButton");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectBlockDialog.this.setStatusText("Enter number of bytes to highlight");
                SelectBlockDialog.this.setAddressFieldEnabled(false);
                SelectBlockDialog.this.setLengthInputEnabled(true);
            }
        });
        buttonGroup.add(this.forwardButton);
        this.backwardButton = new JRadioButton("Select Backward");
        this.backwardButton.setName("backwardButton");
        this.backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectBlockDialog.this.setStatusText("Enter number of bytes to highlight");
                SelectBlockDialog.this.setAddressFieldEnabled(false);
                SelectBlockDialog.this.setLengthInputEnabled(true);
            }
        });
        buttonGroup.add(this.backwardButton);
        this.allButton = new JRadioButton("Select All");
        this.allButton.setName("allButton");
        this.allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectBlockDialog.this.setItemsEnabled(false);
                SelectBlockDialog.this.clearStatusText();
            }
        });
        buttonGroup.add(this.allButton);
        this.toButton = new JRadioButton("To Address");
        this.toButton.setName("toButton");
        this.toButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectBlockDialog.this.setStatusText("Enter an Address to go to");
                SelectBlockDialog.this.setAddressFieldEnabled(true);
                SelectBlockDialog.this.setLengthInputEnabled(false);
            }
        });
        buttonGroup.add(this.toButton);
        gbc.gridx = 0;
        gbc.gridy = 0;
        main.add((Component)this.allButton, gbc);
        ++gbc.gridy;
        main.add((Component)this.toButton, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        main.add((Component)this.forwardButton, gbc);
        ++gbc.gridy;
        main.add((Component)this.backwardButton, gbc);
        this.setStatusText("Enter number of bytes to highlight");
        return main;
    }

    public void close() {
        super.close();
        this.navigatable = null;
    }

    void show(ComponentProvider provider) {
        this.tool.showDialog((DialogComponentProvider)this, provider);
        this.repack();
    }

    private void setItemsEnabled(boolean enabled) {
        this.setAddressFieldEnabled(enabled);
        this.setLengthInputEnabled(enabled);
    }

    private void setAddressFieldEnabled(boolean enabled) {
        this.toAddressField.setText("");
        this.toAddressField.setEditable(enabled);
        this.toAddressField.setEnabled(enabled);
    }

    private void setLengthInputEnabled(boolean enabled) {
        if (!enabled) {
            this.numberInputField.setValue(null);
        }
        this.numberInputField.setEnabled(enabled);
    }

    protected void okCallback() {
        if (this.toButton.isSelected()) {
            this.handleToAddressSelection();
        } else if (this.allButton.isSelected()) {
            this.handleAllSelection();
        } else if (this.forwardButton.isSelected()) {
            this.handleForwardSelection();
        } else if (this.backwardButton.isSelected()) {
            this.handleBackwardSelection();
        } else {
            this.setStatusText("You must choose the type of selection to make");
        }
    }

    private void handleAllSelection() {
        Memory addressSet = this.navigatable.getProgram().getMemory();
        ProgramSelection selection = new ProgramSelection((AddressSetView)addressSet);
        NavigationUtils.setSelection(this.tool, this.navigatable, selection);
        this.clearStatusText();
    }

    private void handleToAddressSelection() {
        Address toAddress = null;
        String addressValue = this.toAddressField.getText();
        this.clearStatusText();
        Address currentAddress = this.navigatable.getLocation().getAddress();
        try {
            toAddress = currentAddress.getAddress(addressValue);
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        if (toAddress == null) {
            this.setStatusText("Invalid address value, enter another address");
            return;
        }
        if (toAddress.compareTo((Object)currentAddress) < 0) {
            Address tmp = toAddress;
            toAddress = currentAddress;
            currentAddress = tmp;
        }
        AddressFactory addressFactory = this.navigatable.getProgram().getAddressFactory();
        AddressSet addressSet = new AddressSet(currentAddress, toAddress);
        ProgramSelection selection = new ProgramSelection((AddressSetView)addressSet);
        NavigationUtils.setSelection(this.tool, this.navigatable, selection);
    }

    private void handleForwardSelection() {
        int length = this.numberInputField.getIntValue();
        if (length == 0) {
            this.setStatusText("length must be > 0");
            return;
        }
        this.clearStatusText();
        Address currentAddress = this.navigatable.getLocation().getAddress();
        AddressFactory addressFactory = this.navigatable.getProgram().getAddressFactory();
        AddressSet addressSet = new AddressSet((AddressSetView)this.navigatable.getSelection());
        if (addressSet.isEmpty()) {
            addressSet.addRange(currentAddress, currentAddress);
        }
        length *= currentAddress.getAddressSpace().getAddressableUnitSize();
        AddressRangeIterator aiter = addressSet.getAddressRanges();
        AddressSet newSet = new AddressSet();
        while (aiter.hasNext()) {
            AddressRange range = (AddressRange)aiter.next();
            Address toAddress = this.createForwardToAddress(range.getMinAddress(), length - 1);
            newSet.addRange(range.getMinAddress(), toAddress);
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)newSet);
        NavigationUtils.setSelection(this.tool, this.navigatable, selection);
    }

    private void handleBackwardSelection() {
        int length = this.numberInputField.getIntValue();
        if (length == 0) {
            this.setStatusText("length must be > 0");
            return;
        }
        this.clearStatusText();
        Address currentAddress = this.navigatable.getLocation().getAddress();
        length *= currentAddress.getAddressSpace().getAddressableUnitSize();
        AddressFactory addressFactory = this.navigatable.getProgram().getAddressFactory();
        AddressSet addressSet = new AddressSet((AddressSetView)this.navigatable.getSelection());
        if (addressSet.isEmpty()) {
            addressSet.addRange(currentAddress, currentAddress);
        }
        AddressRangeIterator aiter = addressSet.getAddressRanges();
        AddressSet newSet = new AddressSet();
        while (aiter.hasNext()) {
            AddressRange range = (AddressRange)aiter.next();
            Address fromAddress = this.createBackwardToAddress(range.getMaxAddress(), length - 1);
            newSet.addRange(fromAddress, range.getMaxAddress());
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)newSet);
        NavigationUtils.setSelection(this.tool, this.navigatable, selection);
    }

    private Address createBackwardToAddress(Address startAddress, long length) {
        AddressSpace addressSpace = startAddress.getAddressSpace();
        if (addressSpace.isOverlaySpace()) {
            OverlayAddressSpace oas = (OverlayAddressSpace)addressSpace;
            if (startAddress.getOffset() - length < oas.getMinOffset()) {
                this.showWarningDialog(OVERFLOW_SELECTION_WARNING);
                return addressSpace.getAddress(oas.getMinOffset());
            }
        }
        Address toAddress = null;
        try {
            toAddress = startAddress.subtract(length);
        }
        catch (AddressOutOfBoundsException aoobe) {
            this.showWarningDialog(OVERFLOW_SELECTION_WARNING);
            toAddress = addressSpace.getMinAddress();
        }
        return toAddress;
    }

    private Address createForwardToAddress(Address startAddress, long length) {
        AddressSpace addressSpace = startAddress.getAddressSpace();
        if (addressSpace.isOverlaySpace()) {
            OverlayAddressSpace oas = (OverlayAddressSpace)addressSpace;
            if (startAddress.getOffset() + length > oas.getMaxOffset()) {
                this.showWarningDialog(OVERFLOW_SELECTION_WARNING);
                return addressSpace.getAddress(oas.getMaxOffset());
            }
        }
        Address toAddress = null;
        try {
            toAddress = startAddress.add(length);
        }
        catch (AddressOutOfBoundsException aoobe) {
            this.showWarningDialog(OVERFLOW_SELECTION_WARNING);
            toAddress = addressSpace.getMaxAddress();
        }
        return toAddress;
    }

    private void showWarningDialog(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(SelectBlockDialog.this.getComponent(), text);
            }
        });
    }

    public void setNavigatable(Navigatable navigatable) {
        this.navigatable = navigatable;
        this.setOkEnabled(navigatable != null);
    }
}

