/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import ghidra.app.plugin.core.console.CodeCompletion;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class CodeCompletionListCellRenderer
extends DefaultListCellRenderer {
    CodeCompletionListCellRenderer() {
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object completion, int index, boolean isSelected, boolean cellHasFocus) {
        CodeCompletion codeCompletion = (CodeCompletion)completion;
        if (null == codeCompletion.getComponent()) {
            return super.getListCellRendererComponent((JList<?>)list, codeCompletion.getDescription(), index, isSelected, cellHasFocus);
        }
        JComponent component = codeCompletion.getComponent();
        component.setOpaque(true);
        if (isSelected) {
            component.setBackground(list.getSelectionBackground());
        } else {
            component.setBackground(list.getBackground());
        }
        component.setEnabled(list.isEnabled());
        component.setFont(list.getFont());
        component.setComponentOrientation(list.getComponentOrientation());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = new EmptyBorder(1, 1, 1, 1);
        }
        component.setBorder(border);
        return component;
    }
}

