/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.plugin.core.compositeeditor.EditorListener;
import ghidra.app.plugin.core.compositeeditor.EditorProvider;
import ghidra.app.plugin.core.compositeeditor.StructureEditorOptionManager;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.app.plugin.core.compositeeditor.UnionEditorOptionManager;
import ghidra.app.plugin.core.compositeeditor.UnionEditorProvider;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.editor.EditorOptionManager;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorProvider;
import ghidra.app.plugin.core.function.EditFunctionSignatureDialog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataTypeEditorManager
implements EditorListener,
StructureEditorOptionManager,
UnionEditorOptionManager {
    private ArrayList<EditorProvider> editorList;
    private EditorOptionManager editorOptionMgr;
    private DataTypeManagerPlugin plugin;

    public DataTypeEditorManager(DataTypeManagerPlugin plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    public void dispose() {
        this.dismissEditors(null);
        this.editorOptionMgr.dispose();
    }

    public HelpLocation getEditorHelpLocation(DataType dataType) {
        if (dataType instanceof Enum) {
            return new HelpLocation("DataTypeEditors", "EnumEditor");
        }
        if (dataType instanceof Union || dataType instanceof Structure) {
            return new HelpLocation("DataTypeEditors", "Structure_Editor");
        }
        return new HelpLocation("DataTypeEditors", "Structure_Editor");
    }

    public boolean isEditable(DataType dataType) {
        return dataType instanceof Enum || dataType instanceof Union || dataType instanceof Structure;
    }

    public void edit(DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a data type manager specified.");
        }
        EditorProvider editor = this.getEditor(dataType);
        if (editor != null) {
            ComponentProvider componentProvider = editor.getComponentProvider();
            this.plugin.getTool().showComponentProvider(componentProvider, true);
            componentProvider.toFront();
            return;
        }
        if (dataType instanceof Enum) {
            editor = new EnumEditorProvider(this.plugin, (Enum)dataType);
        } else if (dataType instanceof Union) {
            editor = new UnionEditorProvider(this.plugin, (Union)dataType, this.showUnionNumbersInHex());
        } else if (dataType instanceof Structure) {
            editor = new StructureEditorProvider(this.plugin, (Structure)dataType, this.showStructureNumbersInHex());
        } else if (dataType instanceof FunctionDefinition) {
            this.editFunctionSignature((FunctionDefinition)dataType);
        }
        if (editor == null) {
            return;
        }
        editor.addEditorListener(this);
        this.editorList.add(editor);
    }

    boolean closeEditor(EditorProvider editor, boolean allowCancel) {
        if (this.checkEditor(editor, allowCancel)) {
            this.dismissEditor(editor);
            return true;
        }
        return false;
    }

    public List<DataTypePath> getEditsInProgress() {
        ArrayList<DataTypePath> paths = new ArrayList<DataTypePath>();
        for (EditorProvider editor : this.editorList) {
            paths.add(editor.getDtPath());
        }
        return paths;
    }

    public Category getEditedDataTypeCategory(DataTypePath dataTypePath) {
        CategoryPath categoryPath = dataTypePath.getCategoryPath();
        for (EditorProvider editor : this.editorList) {
            DataTypeManager dtMgr;
            if (!dataTypePath.equals((Object)editor.getDtPath()) || !(dtMgr = editor.getDataTypeManager()).containsCategory(categoryPath)) continue;
            return dtMgr.getCategory(categoryPath);
        }
        return null;
    }

    public boolean isEditInProgress() {
        return this.editorList.size() > 0;
    }

    public void dismissEditors(DataTypeManager dtMgr) {
        ArrayList<EditorProvider> list = new ArrayList<EditorProvider>();
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm) continue;
            list.add(editor);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.dismissEditor((EditorProvider)list.get(i));
        }
    }

    void dismissEditor(EditorProvider editor) {
        if (editor != null) {
            editor.dispose();
        }
        this.editorList.remove(editor);
    }

    public boolean checkEditors(DataTypeManager dtMgr, boolean allowCancel) {
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm || this.checkEditor(editor, allowCancel)) continue;
            return false;
        }
        return true;
    }

    boolean checkEditor(EditorProvider editor, boolean allowCancel) {
        if (editor != null && editor.needsSave()) {
            editor.show();
            if (!editor.checkForSave(allowCancel)) {
                return false;
            }
        }
        return true;
    }

    EditorOptionManager getEditorOptionManager() {
        return this.editorOptionMgr;
    }

    String getUniqueName(Category category, String baseName) {
        DataTypeManager dtm = category.getDataTypeManager();
        Object uniqueName = dtm.getUniqueName(category.getCategoryPath(), baseName);
        int oneUpNumber = 0;
        int pos = ((String)uniqueName).lastIndexOf(95);
        if (pos > 0) {
            try {
                String numStr = ((String)uniqueName).substring(pos + 1);
                oneUpNumber = Integer.parseInt(numStr);
                baseName = ((String)uniqueName).substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.nameExists(dtm, (String)uniqueName)) {
            uniqueName = baseName + "_" + ++oneUpNumber;
        }
        return uniqueName;
    }

    public boolean nameExists(DataTypeManager dtm, String dtName) {
        for (EditorProvider editor : this.editorList) {
            DataTypePath dtPath;
            if (editor.getDataTypeManager() != dtm || !(dtPath = editor.getDtPath()).getDataTypeName().equals(dtName)) continue;
            return true;
        }
        return false;
    }

    public void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        ArrayList<EditorProvider> list = new ArrayList<EditorProvider>(this.editorList);
        for (EditorProvider editor : list) {
            String name;
            DataTypeManager programDataTypeManager;
            DataTypeManager dataTypeManager = editor.getDataTypeManager();
            if (dataTypeManager != (programDataTypeManager = domainObject.getDataTypeManager())) continue;
            DataTypePath dtPath = editor.getDtPath();
            CategoryPath categoryPath = dtPath.getCategoryPath();
            DataType dataType = programDataTypeManager.getDataType(categoryPath, name = dtPath.getDataTypeName());
            if (dataType == null || dataType.isDeleted()) {
                this.dismissEditor(editor);
                continue;
            }
            editor.domainObjectRestored(domainObject);
        }
    }

    public EditorProvider getEditor(DataType dataType) {
        DataTypeManager catDtm = dataType.getDataTypeManager();
        DataTypePath dataTypePath = dataType.getDataTypePath();
        for (EditorProvider editor : this.editorList) {
            if (editor.getDataTypeManager() != catDtm || !editor.isEditing(dataTypePath)) continue;
            return editor;
        }
        return null;
    }

    private void initialize() {
        this.editorList = new ArrayList();
        this.editorOptionMgr = new EditorOptionManager(this.plugin);
    }

    @Override
    public void closed(EditorProvider editor) {
        this.editorList.remove(editor);
    }

    boolean hasEditorChanges(DataTypeManager dtMgr) {
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm || !editor.needsSave()) continue;
            return true;
        }
        return false;
    }

    void close() {
        this.dismissEditors(null);
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (dObj instanceof Program) {
            Program p = (Program)dObj;
            return this.checkEditors(p.getListing().getDataTypeManager(), true);
        }
        return true;
    }

    @Override
    public boolean showStructureNumbersInHex() {
        return this.editorOptionMgr.showStructureNumbersInHex();
    }

    @Override
    public boolean showUnionNumbersInHex() {
        return this.editorOptionMgr.showUnionNumbersInHex();
    }

    public void createNewStructure(Category category, boolean isInternallyAligned) {
        String newName = this.getUniqueName(category, "struct");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        StructureDataType structureDataType = new StructureDataType(category.getCategoryPath(), newName, 0, dataTypeManager);
        structureDataType.setSourceArchive(sourceArchive);
        structureDataType.setInternallyAligned(isInternallyAligned);
        this.edit((DataType)structureDataType);
    }

    public void createNewUnion(Category category, boolean isInternallyAligned) {
        String newName = this.getUniqueName(category, "union");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        UnionDataType unionDataType = new UnionDataType(category.getCategoryPath(), newName, dataTypeManager);
        unionDataType.setSourceArchive(sourceArchive);
        unionDataType.setInternallyAligned(isInternallyAligned);
        this.edit((DataType)unionDataType);
    }

    public void createNewEnum(Category category) {
        String newName = this.getUniqueName(category, "enum");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        EnumDataType dataType = new EnumDataType(category.getCategoryPath(), newName, 1, dataTypeManager);
        dataType.setSourceArchive(sourceArchive);
        this.edit((DataType)dataType);
    }

    public void createNewFunctionDefinition(Category cat) {
        this.editFunctionSignature(cat, null);
    }

    public void editFunctionSignature(FunctionDefinition functionDefinition) {
        DataTypeManager dataTypeManager = functionDefinition.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("DataType " + functionDefinition.getPathName() + " has no DataTypeManager!  Make sure the given DataType has been resolved by a DataTypeManager");
        }
        CategoryPath categoryPath = functionDefinition.getCategoryPath();
        Category category = dataTypeManager.getCategory(categoryPath);
        if (categoryPath == null) {
            throw new IllegalArgumentException("DataType " + functionDefinition.getName() + " has no category path!");
        }
        this.editFunctionSignature(category, functionDefinition);
    }

    private void editFunctionSignature(Category category, final FunctionDefinition functionDefinition) {
        UndefinedFunction function = new UndefinedFunction(this.plugin.getProgram(), this.plugin.getProgram().getMinAddress()){

            @Override
            public String getCallingConventionName() {
                if (functionDefinition == null) {
                    return super.getCallingConventionName();
                }
                return functionDefinition.getGenericCallingConvention().toString();
            }

            @Override
            public void setCallingConvention(String name) throws InvalidInputException {
            }

            @Override
            public void setInline(boolean isInline) {
            }

            @Override
            public void setNoReturn(boolean hasNoReturn) {
            }

            @Override
            public FunctionSignature getSignature() {
                if (functionDefinition != null) {
                    return functionDefinition;
                }
                return super.getSignature();
            }

            @Override
            public String getName() {
                if (functionDefinition != null) {
                    return functionDefinition.getName();
                }
                return "newFunction";
            }
        };
        PluginTool tool = this.plugin.getTool();
        DTMEditFunctionSignatureDialog editSigDialog = new DTMEditFunctionSignatureDialog(this.plugin.getTool(), "Edit Function Signature", function, category, functionDefinition);
        editSigDialog.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Function_Definition"));
        tool.showDialog((DialogComponentProvider)editSigDialog);
    }

    private class DTMEditFunctionSignatureDialog
    extends EditFunctionSignatureDialog {
        private final Category category;
        private final FunctionDefinition functionDefinitionDataType;

        DTMEditFunctionSignatureDialog(PluginTool pluginTool, String title, Function function, Category category, FunctionDefinition functionDefinition) {
            super(pluginTool, title, function);
            this.category = category;
            this.functionDefinitionDataType = functionDefinition;
            if (this.functionDefinitionDataType != null) {
                this.setCallingConvention(this.functionDefinitionDataType.getGenericCallingConvention().toString());
            }
        }

        @Override
        protected void installCallingConventionWidget(JPanel parentPanel) {
            this.callingConventionComboBox = new GhidraComboBox();
            GenericCallingConvention[] values = GenericCallingConvention.values();
            String[] choices = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                choices[i] = values[i].toString();
            }
            this.setCallingConventionChoices(choices);
            parentPanel.add(new JLabel("Calling Convention:"));
            parentPanel.add(this.callingConventionComboBox);
        }

        @Override
        protected void installInlineWidget(JPanel parentPanel) {
            this.inlineCheckBox = new JCheckBox("Inline");
        }

        @Override
        protected void installNoReturnWidget(JPanel parentPanel) {
            this.noReturnCheckBox = new JCheckBox("No Return");
        }

        @Override
        protected void installCallFixupWidget(JPanel parentPanel) {
        }

        @Override
        protected void setCallingConvention(String callingConvention) {
            ComboBoxModel model = this.callingConventionComboBox.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                Object item = model.getElementAt(i);
                if (!item.equals(callingConvention)) continue;
                this.callingConventionComboBox.setSelectedItem(callingConvention);
                return;
            }
            this.callingConventionComboBox.setSelectedItem(GenericCallingConvention.unknown);
        }

        @Override
        protected boolean applyChanges() {
            FunctionDefinitionDataType newDefinition = this.parseSignature();
            if (newDefinition == null) {
                return false;
            }
            GenericCallingConvention callingConvention = GenericCallingConvention.getGenericCallingConvention((String)this.getCallingConvention());
            newDefinition.setGenericCallingConvention(callingConvention);
            DataTypeManager manager = this.category.getDataTypeManager();
            SourceArchive sourceArchive = manager.getLocalSourceArchive();
            if (this.functionDefinitionDataType == null) {
                newDefinition.setSourceArchive(sourceArchive);
                newDefinition.setCategoryPath(this.category.getCategoryPath());
                int id = manager.startTransaction("Create Function Definition");
                manager.addDataType((DataType)newDefinition, DataTypeConflictHandler.REPLACE_HANDLER);
                manager.endTransaction(id, true);
            } else {
                int id = manager.startTransaction("Edit Function Definition");
                try {
                    if (!this.functionDefinitionDataType.getName().equals(newDefinition.getName())) {
                        this.functionDefinitionDataType.setName(newDefinition.getName());
                    }
                    this.functionDefinitionDataType.setArguments(newDefinition.getArguments());
                    this.functionDefinitionDataType.setGenericCallingConvention(newDefinition.getGenericCallingConvention());
                    this.functionDefinitionDataType.setReturnType(newDefinition.getReturnType());
                    this.functionDefinitionDataType.setVarArgs(newDefinition.hasVarArgs());
                }
                catch (InvalidNameException | DuplicateNameException e) {
                    Msg.error((Object)((Object)this), (Object)"Unexpected Exception", (Throwable)e);
                }
                manager.endTransaction(id, true);
            }
            return true;
        }
    }
}

