/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.plugin.core.bookmark.BookmarkNavigator;
import ghidra.app.plugin.core.bookmark.BookmarkPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CreateBookmarkDialog
extends DialogComponentProvider {
    private BookmarkPlugin plugin;
    private Program program;
    private Address address;
    private JTextField locationTextField;
    private JComboBox<String> categoryComboBox;
    private JTextField categoryTextField;
    private JTextField commentTextField;
    private JCheckBox selectionCB;

    CreateBookmarkDialog(BookmarkPlugin plugin, CodeUnit cu, boolean hasSelection) {
        super("Note Bookmark", true, true, true, false);
        this.plugin = plugin;
        this.program = plugin.getCurrentProgram();
        this.address = cu.getMinAddress();
        this.addWorkPanel(this.buildWorkPanel(hasSelection));
        this.addOKButton();
        this.addCancelButton();
        this.populateDisplay(cu.getComment(0));
        this.commentTextField.selectAll();
        this.setFocusComponent(this.commentTextField);
        this.setHelpLocation(new HelpLocation("BookmarkPlugin", "CreateBookmarkDialog"));
    }

    public void dispose() {
        this.plugin = null;
        this.program = null;
        this.address = null;
    }

    protected void okCallback() {
        JTextField textField = (JTextField)this.categoryComboBox.getEditor().getEditorComponent();
        String cat = textField.getText();
        String com = this.commentTextField.getText();
        if (this.selectionCB.isSelected()) {
            this.plugin.setNote(null, cat, com);
        } else {
            this.plugin.setNote(this.address, cat, com);
        }
        this.cancelCallback();
    }

    private JPanel buildWorkPanel(boolean hasSelection) {
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Object src = e.getSource();
                    if (src == CreateBookmarkDialog.this.locationTextField) {
                        CreateBookmarkDialog.this.categoryComboBox.requestFocus();
                        CreateBookmarkDialog.this.categoryTextField.requestFocus();
                    } else if (src == CreateBookmarkDialog.this.categoryComboBox || src == CreateBookmarkDialog.this.categoryTextField) {
                        CreateBookmarkDialog.this.commentTextField.requestFocus();
                    } else if (src == CreateBookmarkDialog.this.commentTextField) {
                        CreateBookmarkDialog.this.okCallback();
                    }
                }
            }
        };
        int ranges = 0;
        if (hasSelection) {
            ranges = this.plugin.getProgramSelection().getNumAddressRanges();
        }
        JLabel locationLabel = new JLabel("Address: ", 4);
        this.locationTextField = new JTextField(50);
        this.locationTextField.setText(this.address.toString());
        if (hasSelection && ranges > 1) {
            this.locationTextField.setText(this.address.toString() + " (plus " + (ranges - 1) + " more)");
        }
        this.locationTextField.setCaretPosition(0);
        this.locationTextField.setEditable(false);
        DockingUtils.setTransparent((JComponent)this.locationTextField);
        this.locationTextField.setMinimumSize(this.locationTextField.getPreferredSize());
        this.locationTextField.addKeyListener(listener);
        JLabel categoryLabel = new JLabel("Category: ", 4);
        this.categoryComboBox = new GhidraComboBox(this.getModel());
        this.categoryComboBox.setEditable(true);
        this.categoryComboBox.addKeyListener(listener);
        this.categoryTextField = (JTextField)this.categoryComboBox.getEditor().getEditorComponent();
        this.categoryTextField.addKeyListener(listener);
        JLabel commentLabel = new JLabel("Description: ", 4);
        this.commentTextField = new JTextField(20);
        this.commentTextField.addKeyListener(listener);
        this.selectionCB = new JCheckBox("Bookmark Top of Each Selection", hasSelection);
        this.selectionCB.setEnabled(false);
        if (hasSelection) {
            this.selectionCB.setEnabled(ranges > 1);
        }
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        mainPanel.add((Component)categoryLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        mainPanel.add(this.categoryComboBox, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        mainPanel.add((Component)locationLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        mainPanel.add((Component)this.locationTextField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        mainPanel.add((Component)commentLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        mainPanel.add((Component)this.commentTextField, gbc);
        ImageIcon icon = BookmarkNavigator.NOTE_ICON;
        JLabel imageLabel = new JLabel(icon);
        imageLabel.setPreferredSize(new Dimension(icon.getIconWidth() + 20, icon.getIconHeight() + 20));
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        selectionPanel.add(this.selectionCB);
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.add((Component)mainPanel, "Center");
        workPanel.add((Component)imageLabel, "West");
        workPanel.add((Component)selectionPanel, "South");
        return workPanel;
    }

    private ComboBoxModel<String> getModel() {
        BookmarkManager mgr = this.program.getBookmarkManager();
        String[] categories = mgr.getCategories("Note");
        Object[] array = new String[categories.length + 1];
        array[0] = "";
        System.arraycopy(categories, 0, array, 1, categories.length);
        Arrays.sort(array);
        return new DefaultComboBoxModel<Object>(array);
    }

    private void populateDisplay(String defaultComment) {
        defaultComment = defaultComment == null ? "" : defaultComment.replace('\n', ' ');
        BookmarkManager bmMgr = this.program.getBookmarkManager();
        Bookmark[] bookmarks = bmMgr.getBookmarks(this.address, "Note");
        if (bookmarks.length != 0) {
            this.categoryComboBox.setSelectedItem(bookmarks[0].getCategory());
            this.commentTextField.setText(bookmarks[0].getComment());
        } else {
            this.commentTextField.setText(defaultComment);
        }
        this.commentTextField.setCaretPosition(0);
    }
}

