/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.stream;

import db.buffers.BlockStream;
import generic.random.SecureRandomFactory;
import ghidra.server.stream.BlockStreamServer;
import ghidra.util.StringUtilities;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public abstract class RemoteBlockStreamHandle<T extends BlockStream>
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static boolean enableCompressedSerializationOutput = Boolean.parseBoolean(System.getProperty("db.buffers.DataBuffer.compressedOutput", "false"));
    public static final String HEADER_PREFIX = "@stream:";
    public static final String HEADER_SUFFIX = "@";
    public static final int HEADER_LENGTH = "@stream:".length() + 16 + 16 + "@".length();
    public static final String TERM_PREFIX = "@end:";
    public static final String TERM_SUFFIX = "@";
    public static final int TERM_LENGTH = "@end:".length() + 16 + "@".length();
    private String streamServerIPAddress;
    private int streamServerPort;
    private long streamID;
    private long authenticationToken;
    private final int blockCount;
    private final int blockSize;
    protected final boolean compressed = enableCompressedSerializationOutput;
    private boolean connectionPending = true;

    public RemoteBlockStreamHandle(BlockStreamServer server, int blockCount, int blockSize) throws IOException {
        this.streamServerIPAddress = server.getServerIpAddress();
        if (!server.isRunning() || this.streamServerIPAddress == null) {
            throw new IOException("block stream server is not running");
        }
        this.streamServerPort = server.getServerPort();
        this.streamID = server.getNextStreamID();
        this.authenticationToken = RemoteBlockStreamHandle.getRandom();
        this.blockCount = blockCount;
        this.blockSize = blockSize;
    }

    public synchronized boolean isPending() {
        return this.connectionPending;
    }

    long getStreamID() {
        return this.streamID;
    }

    long getAuthenticationToken() {
        return this.authenticationToken;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    protected int getPreferredBufferSize() {
        return (this.getBlockSize() + 4) * 12;
    }

    private static synchronized long getRandom() {
        SecureRandom random = SecureRandomFactory.getSecureRandom();
        return random.nextLong();
    }

    private String getStreamRequestHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(HEADER_PREFIX);
        buf.append(StringUtilities.pad((String)Long.toHexString(this.streamID), (char)'0', (int)16));
        buf.append(StringUtilities.pad((String)Long.toHexString(this.authenticationToken), (char)'0', (int)16));
        buf.append("@");
        return buf.toString();
    }

    private String getStreamTerminator() {
        StringBuilder buf = new StringBuilder();
        buf.append(TERM_PREFIX);
        buf.append(StringUtilities.pad((String)Long.toHexString(this.streamID), (char)'0', (int)16));
        buf.append("@");
        return buf.toString();
    }

    void checkTerminator(byte[] terminatorBytes) throws IOException {
        String term = new String(terminatorBytes);
        if (terminatorBytes.length != TERM_LENGTH) {
            throw new IllegalArgumentException("invalid terminatorBytes length");
        }
        if (!term.startsWith(TERM_PREFIX) || !term.endsWith("@")) {
            throw new IOException("invalid block stream terminator");
        }
        String streamIdStr = term.substring(TERM_PREFIX.length(), TERM_PREFIX.length() + 16);
        try {
            if (this.streamID != Long.parseUnsignedLong(streamIdStr, 16)) {
                throw new IOException("invalid block stream terminator stream ID");
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("invalid block stream terminator stream ID: " + streamIdStr);
        }
    }

    static StreamRequest parseStreamRequestHeader(byte[] headerBytes) throws IOException {
        String head = new String(headerBytes);
        if (headerBytes.length != HEADER_LENGTH) {
            throw new IllegalArgumentException("invalid headerBytes length");
        }
        if (!head.startsWith(HEADER_PREFIX) || !head.endsWith("@")) {
            throw new IOException("invalid block stream header");
        }
        String streamIdStr = head.substring(HEADER_PREFIX.length(), HEADER_PREFIX.length() + 16);
        String authTokenStr = head.substring(HEADER_PREFIX.length() + 16, HEADER_PREFIX.length() + 32);
        try {
            long streamID = Long.parseUnsignedLong(streamIdStr, 16);
            long authToken = Long.parseUnsignedLong(authTokenStr, 16);
            return new StreamRequest(streamID, authToken);
        }
        catch (NumberFormatException e) {
            throw new IOException("invalid request header stream ID: " + streamIdStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket connect() throws IOException {
        RemoteBlockStreamHandle remoteBlockStreamHandle = this;
        synchronized (remoteBlockStreamHandle) {
            if (!this.connectionPending) {
                throw new IOException("already connected");
            }
            this.connectionPending = false;
        }
        SocketFactory socketFactory = SSLSocketFactory.getDefault();
        Socket socket = socketFactory.createSocket(this.streamServerIPAddress, this.streamServerPort);
        OutputStream out = socket.getOutputStream();
        out.write(this.getStreamRequestHeader().getBytes());
        out.flush();
        return socket;
    }

    protected void writeStreamEnd(Socket socket) throws IOException {
        OutputStream out = socket.getOutputStream();
        out.write(this.getStreamTerminator().getBytes());
        out.flush();
    }

    protected void readStreamEnd(Socket socket, boolean enableTimeout) throws IOException {
        int readlen;
        InputStream in = socket.getInputStream();
        byte[] term = new byte[TERM_LENGTH];
        for (int total = 0; total < term.length; total += readlen) {
            readlen = in.read(term, total, term.length - total);
            if (readlen >= 0) continue;
            throw new EOFException("unexpected end of stream");
        }
        this.checkTerminator(term);
    }

    abstract void serveBlockStream(Socket var1, BlockStream var2) throws IOException;

    static class StreamRequest {
        final long streamID;
        final long authenticationToken;

        StreamRequest(long streamID, long authenticationToken) {
            this.streamID = streamID;
            this.authenticationToken = authenticationToken;
        }
    }
}

