/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import generic.jar.ResourceFile;
import generic.random.SecureRandomFactory;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.OperatingSystem;
import ghidra.framework.remote.GhidraPrincipal;
import ghidra.framework.remote.GhidraServerHandle;
import ghidra.framework.remote.InetNameLookup;
import ghidra.framework.remote.RemoteRepositoryServerHandle;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.SSLContextInitializer;
import ghidra.server.RepositoryManager;
import ghidra.server.remote.GhidraSSLServerSocket;
import ghidra.server.remote.GhidraServerApplicationLayout;
import ghidra.server.remote.RepositoryServerHandleImpl;
import ghidra.server.remote.ServerPortFactory;
import ghidra.server.security.AnonymousAuthenticationModule;
import ghidra.server.security.AuthenticationModule;
import ghidra.server.security.PKIAuthenticationModule;
import ghidra.server.security.PasswordFileAuthenticationModule;
import ghidra.server.security.SSHAuthenticationModule;
import ghidra.server.stream.BlockStreamServer;
import ghidra.server.stream.RemoteBlockStreamHandle;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import resources.ResourceManager;
import utility.application.ApplicationLayout;

public class GhidraServer
extends UnicastRemoteObject
implements GhidraServerHandle {
    private static SslRMIServerSocketFactory serverSocketFactory;
    private static SslRMIClientSocketFactory clientSocketFactory;
    private static Logger log;
    private static String HELP_FILE;
    private static String USAGE_ARGS;
    private static final String RMI_SERVER_PROPERTY = "java.rmi.server.hostname";
    private static final String[] AUTH_MODES;
    public static final int NO_AUTH_LOGIN = -1;
    public static final int PASSWORD_FILE_LOGIN = 0;
    public static final int OS_PASSWORD_LOGIN = 1;
    public static final int PKI_LOGIN = 2;
    public static final int ALT_OS_PASSWORD_LOGIN = 3;
    private static GhidraServer server;
    private RepositoryManager mgr;
    private AuthenticationModule authModule;
    private SSHAuthenticationModule sshAuthModule;
    private AnonymousAuthenticationModule anonymousAuthModule;
    private BlockStreamServer blockStreamServer;
    private static final int IP_INTERFACE_RETRY_TIME_SEC = 5;
    private static final int IP_INTERFACE_MAX_RETRIES = 12;

    GhidraServer(File rootDir, int authMode, String loginDomain, boolean nameCallbackAllowed, boolean altSSHLoginAllowed, int defaultPasswordExpirationDays, boolean allowAnonymousAccess) throws IOException, CertificateException {
        super(ServerPortFactory.getRMISSLPort(), clientSocketFactory, serverSocketFactory);
        if (log == null) {
            log = LogManager.getLogger(GhidraServer.class);
        }
        if (allowAnonymousAccess) {
            this.anonymousAuthModule = new AnonymousAuthenticationModule();
        }
        boolean supportLocalPasswords = false;
        boolean requireExplicitPasswordReset = true;
        switch (authMode) {
            case 0: {
                supportLocalPasswords = true;
                requireExplicitPasswordReset = false;
                this.authModule = new PasswordFileAuthenticationModule(nameCallbackAllowed);
                break;
            }
            case 2: {
                if (altSSHLoginAllowed) {
                    log.warn("SSH authentication option ignored when PKI authentication used");
                    altSSHLoginAllowed = false;
                }
                SecureRandomFactory.getSecureRandom();
                this.authModule = new PKIAuthenticationModule(allowAnonymousAccess);
                break;
            }
            case -1: {
                if (!altSSHLoginAllowed) break;
                log.warn("SSH authentication option ignored when no authentication used");
                altSSHLoginAllowed = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Authentication mode: " + authMode);
            }
        }
        if (altSSHLoginAllowed) {
            SecureRandomFactory.getSecureRandom();
            this.sshAuthModule = new SSHAuthenticationModule(nameCallbackAllowed);
        }
        this.mgr = new RepositoryManager(rootDir, supportLocalPasswords, requireExplicitPasswordReset, defaultPasswordExpirationDays, allowAnonymousAccess);
        server = this;
        this.blockStreamServer = BlockStreamServer.getBlockStreamServer();
        this.blockStreamServer.startServer();
    }

    public Callback[] getAuthenticationCallbacks() throws RemoteException {
        log.info("Authentication callbacks requested by " + RepositoryManager.getRMIClient());
        try {
            Callback[] callbacks;
            Callback[] callbackArray = callbacks = this.authModule != null ? this.authModule.getAuthenticationCallbacks() : null;
            if (this.sshAuthModule != null) {
                callbacks = this.sshAuthModule.addAuthenticationCallbacks(callbacks);
            }
            if (this.anonymousAuthModule != null && (this.authModule == null || this.authModule.anonymousCallbacksAllowed())) {
                callbacks = this.anonymousAuthModule.addAuthenticationCallbacks(callbacks);
            }
            return callbacks;
        }
        catch (Throwable t) {
            log.error("Failed to generate authentication callbacks", t);
            throw new RemoteException("Failed to generate authentication callbacks", t);
        }
    }

    public void checkCompatibility(int serverInterfaceVersion) throws RemoteException {
        if (serverInterfaceVersion > 11) {
            throw new RemoteException("Incompatible server interface, a newer Ghidra Server version is required.");
        }
        if (serverInterfaceVersion < 11) {
            throw new RemoteException("Incompatible server interface, the minimum supported Ghidra version is 9.0");
        }
    }

    public RemoteRepositoryServerHandle getRepositoryServer(Subject user, Callback[] authCallbacks) throws LoginException, RemoteException {
        System.gc();
        GhidraPrincipal principal = GhidraPrincipal.getGhidraPrincipal((Subject)user);
        if (principal == null) {
            throw new FailedLoginException("GhidraPrincipal required");
        }
        boolean anonymousAccess = false;
        String username = principal.getName();
        if (this.anonymousAuthModule != null && this.anonymousAuthModule.anonymousAccessRequested(authCallbacks)) {
            username = "-anonymous-";
            anonymousAccess = true;
            RepositoryManager.log(null, null, "Anonymous access allowed", principal.getName());
        } else if (this.authModule != null) {
            for (Callback cb : authCallbacks) {
                if (!(cb instanceof NameCallback)) continue;
                if (!this.authModule.isNameCallbackAllowed()) {
                    RepositoryManager.log(null, null, "Illegal authentictaion callback: NameCallback not permitted", username);
                    throw new LoginException("Illegal authentictaion callback");
                }
                NameCallback nameCb = (NameCallback)cb;
                String name = nameCb.getName();
                if (name == null) {
                    RepositoryManager.log(null, null, "Illegal authentictaion callback: NameCallback must specify login name", username);
                    throw new LoginException("Illegal authentictaion callback");
                }
                username = name;
                break;
            }
        }
        RepositoryManager.log(null, null, "Repository server handle requested", username);
        boolean supportPasswordChange = false;
        if (!anonymousAccess) {
            if (this.sshAuthModule != null && this.sshAuthModule.hasSignedSSHCallback(authCallbacks)) {
                try {
                    username = this.sshAuthModule.authenticate(this.mgr.getUserManager(), user, authCallbacks);
                }
                catch (LoginException e) {
                    RepositoryManager.log(null, null, "SSH Authentication failed (" + e.getMessage() + ")", username);
                    throw e;
                }
            }
            if (this.authModule != null) {
                try {
                    username = this.authModule.authenticate(this.mgr.getUserManager(), user, authCallbacks);
                    anonymousAccess = "-anonymous-".equals(username);
                    if (!anonymousAccess) {
                        RepositoryManager.log(null, null, "User '" + username + "' authenticated", principal.getName());
                    }
                }
                catch (LoginException e) {
                    RepositoryManager.log(null, null, "Login failed (" + e.getMessage() + ")", username);
                    throw e;
                }
                if (this.authModule instanceof PasswordFileAuthenticationModule) {
                    supportPasswordChange = true;
                }
            } else if (!this.mgr.getUserManager().isValidUser(username)) {
                FailedLoginException e = new FailedLoginException("Unknown user: " + username);
                RepositoryManager.log(null, null, "Login failed (" + e.getMessage() + ")", username);
                throw e;
            }
        }
        if (anonymousAccess) {
            RepositoryManager.log(null, null, "Anonymous server access granted", null);
        }
        return new RepositoryServerHandleImpl(username, anonymousAccess, this.mgr, supportPasswordChange);
    }

    public void dispose() {
        try {
            GhidraServer.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        if (this.mgr != null) {
            this.mgr.dispose();
            this.mgr = null;
            log.info("Ghidra server terminated.");
        }
        if (server == this) {
            server = null;
        }
        if (this.blockStreamServer != null && this.blockStreamServer.isRunning()) {
            this.blockStreamServer.stopServer();
            this.blockStreamServer = null;
        }
    }

    private static void displayUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("Usage: java " + GhidraServer.class.getName() + USAGE_ARGS);
    }

    private static void displayHelp() {
        InputStream in = ResourceManager.getResourceAsStream((String)HELP_FILE);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static InetAddress findHost() {
        for (int attempt = 0; attempt < 12; ++attempt) {
            try {
                if (attempt != 0) {
                    log.warn("Failed to discover IP interface - retry in 5 seconds...");
                    Thread.sleep(5000L);
                }
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface nic = e.nextElement();
                    Enumeration<InetAddress> e2 = nic.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        InetAddress ia = e2.nextElement();
                        if (ia.isLoopbackAddress()) continue;
                        if (attempt != 0) {
                            log.info("Discovered IP interface: " + ia.getHostAddress());
                        }
                        return ia;
                    }
                }
                log.info("No interfaces found: using loopback interface");
                return InetAddress.getLoopbackAddress();
            }
            catch (SocketException e) {
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return null;
    }

    public static synchronized void main(String[] args) {
        if (serverSocketFactory != null) {
            throw new IllegalStateException("Server previously started within JVM");
        }
        if (args.length == 0) {
            GhidraServer.displayHelp();
            System.exit(-1);
        }
        if (server != null) {
            throw new AssertException("Server already started");
        }
        int basePort = 13100;
        int authMode = -1;
        boolean nameCallbackAllowed = false;
        boolean altSSHLoginAllowed = false;
        boolean allowAnonymousAccess = false;
        String loginDomain = null;
        String rootPath = null;
        int defaultPasswordExpiration = -1;
        InetNameLookup.setLookupEnabled((boolean)false);
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("-p")) {
                try {
                    basePort = Integer.parseInt(s.substring(2));
                }
                catch (NumberFormatException e1) {
                    basePort = -1;
                }
                if (basePort > 0 && basePort <= 65535) continue;
                GhidraServer.displayUsage("Invalid registry port specified");
                System.exit(-1);
                continue;
            }
            if (s.startsWith("-a") && s.length() == 3) {
                try {
                    authMode = Integer.parseInt(s.substring(2));
                }
                catch (NumberFormatException e1) {
                    GhidraServer.displayUsage("Invalid option: " + s);
                    System.exit(-1);
                }
                continue;
            }
            if (s.startsWith("-ip")) {
                System.setProperty(RMI_SERVER_PROPERTY, s.substring(3));
                continue;
            }
            if (s.startsWith("-d") && s.length() > 2) {
                loginDomain = s.substring(2);
                continue;
            }
            if (s.equals("-u")) {
                nameCallbackAllowed = true;
                continue;
            }
            if (s.equals("-n")) {
                InetNameLookup.setLookupEnabled((boolean)true);
                continue;
            }
            if (s.equals("-anonymous")) {
                allowAnonymousAccess = true;
                continue;
            }
            if (s.equals("-ssh")) {
                altSSHLoginAllowed = true;
                continue;
            }
            if (s.startsWith("-e")) {
                try {
                    defaultPasswordExpiration = Integer.parseInt(s.substring(2));
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
                if (defaultPasswordExpiration < 0) {
                    GhidraServer.displayUsage("Invalid default password expiration");
                    System.exit(-1);
                    continue;
                }
                if (defaultPasswordExpiration != 0) continue;
                System.out.println("Default password expiration has been disbaled.");
                continue;
            }
            if (i < args.length - 1) {
                GhidraServer.displayUsage("Invalid usage!");
                System.exit(-1);
            }
            rootPath = s;
        }
        if (authMode < -1 || authMode > 3) {
            GhidraServer.displayUsage("Invalid authentication mode!");
            System.exit(-1);
        }
        if ((authMode == 1 || authMode == 3) && OperatingSystem.CURRENT_OPERATING_SYSTEM != OperatingSystem.WINDOWS) {
            GhidraServer.displayUsage("Authentication mode (" + authMode + ") only supported under Microsoft Windows");
            System.exit(-1);
        }
        if (rootPath == null) {
            GhidraServer.displayUsage("Repository directory must be specified!");
            System.exit(-1);
        }
        try {
            GhidraServerApplicationLayout layout = new GhidraServerApplicationLayout();
            ApplicationConfiguration configuration = new ApplicationConfiguration();
            configuration.setInitializeLogging(false);
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        }
        catch (IOException e) {
            System.err.println("Failed to initialize the application!");
            System.exit(-1);
        }
        File serverRoot = new File(rootPath);
        if (!serverRoot.isAbsolute()) {
            ResourceFile installRoot = Application.getInstallationDirectory();
            if (installRoot == null || installRoot.getFile(false) == null) {
                System.err.println("Failed to resolve installation root directory!");
                System.exit(-1);
            }
            serverRoot = new File(installRoot.getFile(false), rootPath);
        }
        try {
            serverRoot = serverRoot.getCanonicalFile();
        }
        catch (IOException e1) {
            System.err.println("Failed to resolve repository directory: " + serverRoot.getAbsolutePath());
            System.exit(-1);
        }
        if (!serverRoot.exists() && !serverRoot.mkdirs()) {
            System.err.println("Failed to create repository directory: " + serverRoot.getAbsolutePath());
            System.exit(-1);
        }
        Application.initializeLogging((File)new File(serverRoot, "server.log"), null);
        SSLContextInitializer.initialize();
        log = LogManager.getLogger(GhidraServer.class);
        ServerPortFactory.setBasePort(basePort);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (server != null) {
                server.dispose();
            }
        }, "Ghidra Server Disposer"));
        try {
            String hostname = System.getProperty(RMI_SERVER_PROPERTY);
            if (hostname == null) {
                InetAddress localhost = InetAddress.getLocalHost();
                if (localhost.isLoopbackAddress() && (localhost = GhidraServer.findHost()) == null) {
                    log.fatal("Can't find host ip address!");
                    System.exit(0);
                    return;
                }
                System.setProperty(RMI_SERVER_PROPERTY, localhost.getHostAddress());
                hostname = localhost.getCanonicalHostName();
            } else {
                log.warn("forcing server to bind to " + hostname);
            }
            if (ApplicationKeyManagerFactory.getPreferredKeyStore() == null) {
                ApplicationKeyManagerFactory.setDefaultIdentity((X500Principal)new X500Principal("CN=GhidraServer"));
            }
            if (!ApplicationKeyManagerFactory.initialize()) {
                log.fatal("Failed to initialize PKI/SSL keystore");
                System.exit(0);
                return;
            }
            log.info("Ghidra Server " + Application.getApplicationVersion());
            log.info("   Server bound to " + System.getProperty(RMI_SERVER_PROPERTY));
            log.info("   RMI Registry port: " + ServerPortFactory.getRMIRegistryPort());
            log.info("   RMI SSL port: " + ServerPortFactory.getRMISSLPort());
            log.info("   Block Stream port: " + ServerPortFactory.getStreamPort());
            log.info("   Block Stream compression: " + (RemoteBlockStreamHandle.enableCompressedSerializationOutput ? "enabled" : "disabled"));
            log.info("   Root: " + rootPath);
            log.info("   Auth: " + AUTH_MODES[authMode + 1]);
            if (authMode == 0 && defaultPasswordExpiration >= 0) {
                log.info("   Default password expiration: " + (String)(defaultPasswordExpiration == 0 ? "disabled" : defaultPasswordExpiration + " days"));
            }
            if (authMode != 2) {
                log.info("   Prompt for user ID: " + (nameCallbackAllowed ? "yes" : "no"));
            }
            if (altSSHLoginAllowed) {
                log.info("   SSH authentication option enabled");
            }
            log.info("   Anonymous server access: " + (allowAnonymousAccess ? "enabled" : "disabled"));
            log.info(SystemUtilities.getUserName() + " starting Ghidra Server...");
            serverSocketFactory = new SslRMIServerSocketFactory(null, null, authMode == 2){

                @Override
                public ServerSocket createServerSocket(int port) throws IOException {
                    return new GhidraSSLServerSocket(port, this.getEnabledCipherSuites(), this.getEnabledProtocols(), this.getNeedClientAuth());
                }
            };
            clientSocketFactory = new SslRMIClientSocketFactory();
            GhidraServer svr = new GhidraServer(serverRoot, authMode, loginDomain, nameCallbackAllowed, altSSHLoginAllowed, defaultPasswordExpiration, allowAnonymousAccess);
            log.info("Registering Ghidra Server...");
            Registry registry = LocateRegistry.createRegistry(ServerPortFactory.getRMIRegistryPort());
            registry.bind("GhidraServer9.0", svr);
            log.info("Registered Ghidra Server.");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            System.exit(-1);
        }
        catch (Throwable t) {
            log.fatal("Server error: " + t.getMessage(), t);
            System.exit(-1);
        }
    }

    static synchronized void stop() {
        if (server == null) {
            throw new IllegalStateException("Invalid Stop request, Server is not running");
        }
        server.dispose();
    }

    public static RMIServerSocketFactory getRMIServerSocketFactory() {
        return serverSocketFactory;
    }

    public static RMIClientSocketFactory getRMIClientSocketFactory() {
        return clientSocketFactory;
    }

    static {
        HELP_FILE = "/ghidra/server/remote/ServerHelp.txt";
        USAGE_ARGS = " [-p<port>] [-a<authMode>] [-d<domain>] [-u] [-anonymous] [-ssh] [-ip<ipAddr>] [-e<expireDays>] [-n] <serverPath>";
        AUTH_MODES = new String[]{"None", "Password File", "OS Password", "PKI", "OS Password & Password File"};
    }
}

