/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.StringColumnConstraint;
import ghidra.util.UserSearchUtils;
import java.util.regex.Pattern;

public class StringContainsColumnConstraint
extends StringColumnConstraint {
    public StringContainsColumnConstraint(String patternString) {
        super(patternString);
    }

    @Override
    public String getName() {
        return "Contains";
    }

    @Override
    public ColumnConstraint<String> copy(String newPatternString) {
        return new StringContainsColumnConstraint(newPatternString);
    }

    @Override
    protected Pattern generateMatchesPattern(String patternString) {
        return UserSearchUtils.createContainsPattern((String)patternString.trim(), (boolean)true, (int)66);
    }
}

