/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.DockingUtils;
import ghidra.util.SystemUtilities;
import javax.swing.Icon;

public class MenuData {
    public static final int NO_MNEMONIC = -1;
    public static final String NO_SUBGROUP = Character.toString('\uffff');
    private String[] menuPath;
    private Icon icon;
    private int mnemonic = -1;
    private String menuGroup;
    private String menuSubGroup;

    public MenuData(String[] menuPath) {
        this(menuPath, null, null);
    }

    public MenuData(String[] menuPath, String group) {
        this(menuPath, null, group);
    }

    public MenuData(String[] menuPath, Icon icon) {
        this(menuPath, icon, null);
    }

    public MenuData(String[] menuPath, Icon icon, String menuGroup) {
        this(MenuData.processMenuPath(menuPath), icon, menuGroup, MenuData.getMnemonic(menuPath), null);
    }

    public MenuData(String[] menuPath, Icon icon, String menuGroup, int mnemonic, String menuSubGroup) {
        if (menuPath == null || menuPath.length == 0) {
            throw new IllegalArgumentException("Menu path cannot be null or empty");
        }
        this.menuPath = menuPath;
        this.menuGroup = menuGroup;
        this.menuSubGroup = menuSubGroup == null ? NO_SUBGROUP : menuSubGroup;
        this.mnemonic = mnemonic;
        this.icon = DockingUtils.scaleIconAsNeeded(icon);
    }

    public MenuData(MenuData menuData) {
        this.menuPath = menuData.menuPath;
        this.icon = menuData.icon;
        this.menuGroup = menuData.menuGroup;
        this.menuSubGroup = menuData.menuSubGroup;
        this.mnemonic = menuData.mnemonic;
    }

    public MenuData cloneData() {
        return new MenuData(this.menuPath, this.icon, this.menuGroup, this.mnemonic, this.menuSubGroup);
    }

    protected void firePropertyChanged(MenuData oldData) {
    }

    public String[] getMenuPath() {
        return this.menuPath;
    }

    public String getMenuPathAsString() {
        if (this.menuPath == null || this.menuPath.length == 0) {
            return null;
        }
        StringBuilder buildy = new StringBuilder();
        for (int i = 0; i < this.menuPath.length; ++i) {
            buildy.append(this.menuPath[i]);
            if (i == this.menuPath.length - 1) continue;
            buildy.append("->");
        }
        return buildy.toString();
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public Icon getMenuIcon() {
        return this.icon;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public String getMenuSubGroup() {
        return this.menuSubGroup;
    }

    public void setIcon(Icon newIcon) {
        if (this.icon == newIcon) {
            return;
        }
        MenuData oldData = this.cloneData();
        this.icon = DockingUtils.scaleIconAsNeeded(newIcon);
        this.firePropertyChanged(oldData);
    }

    public void setMenuGroup(String newGroup) {
        if (SystemUtilities.isEqual((Object)this.menuGroup, (Object)newGroup)) {
            return;
        }
        MenuData oldData = this.cloneData();
        this.menuGroup = newGroup;
        this.firePropertyChanged(oldData);
    }

    public void setMenuSubGroup(String newSubGroup) {
        if (SystemUtilities.isEqual((Object)this.menuSubGroup, (Object)newSubGroup)) {
            return;
        }
        MenuData oldData = this.cloneData();
        this.menuSubGroup = newSubGroup;
        this.firePropertyChanged(oldData);
    }

    public void setMenuPath(String[] newPath) {
        MenuData oldData = this.cloneData();
        this.menuPath = MenuData.processMenuPath(newPath);
        int newMnemonic = MenuData.getMnemonic(newPath);
        if (newMnemonic != -1) {
            this.mnemonic = newMnemonic;
        }
        this.firePropertyChanged(oldData);
    }

    public void setMnemonic(Character newMnemonic) {
        MenuData oldData = this.cloneData();
        this.mnemonic = newMnemonic.charValue();
        this.firePropertyChanged(oldData);
    }

    public void setMenuItemName(String newMenuItemName) {
        String processedMenuItemName = MenuData.processMenuItemName(newMenuItemName);
        if (processedMenuItemName.equals(this.menuPath[this.menuPath.length - 1])) {
            return;
        }
        MenuData oldData = this.cloneData();
        this.menuPath = (String[])this.menuPath.clone();
        this.menuPath[this.menuPath.length - 1] = processedMenuItemName;
        int newMnemonic = MenuData.getMnemonic(newMenuItemName);
        if (newMnemonic != -1) {
            this.mnemonic = newMnemonic;
        }
        this.firePropertyChanged(oldData);
    }

    private static int getMnemonic(String[] menuPath) {
        if (menuPath == null || menuPath.length == 0) {
            return -1;
        }
        return MenuData.getMnemonic(menuPath[menuPath.length - 1]);
    }

    private static int getMnemonic(String string) {
        int indexOf = string.indexOf(38);
        if (indexOf >= 0 && indexOf < string.length() - 1) {
            return string.charAt(indexOf + 1);
        }
        return -1;
    }

    private static String[] processMenuPath(String[] menuPath) {
        if (menuPath != null && menuPath.length > 0) {
            menuPath[menuPath.length - 1] = MenuData.processMenuItemName(menuPath[menuPath.length - 1]);
        }
        return menuPath;
    }

    private static String processMenuItemName(String string) {
        int indexOf = string.indexOf(38);
        if (indexOf >= 0 && indexOf < string.length() - 1) {
            return string.substring(0, indexOf) + string.substring(indexOf + 1);
        }
        return string;
    }

    public String getMenuItemName() {
        if (this.menuPath == null) {
            return "Missing Menu Path!";
        }
        return this.menuPath[this.menuPath.length - 1];
    }
}

