/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class ShowComponentAction
extends DockingAction
implements Comparable<ShowComponentAction> {
    private static final int MAX_LENGTH = 40;
    protected static final ImageIcon EMPTY_ICON = ResourceManager.loadImage((String)"images/EmptyIcon16.gif");
    protected static final String MENU_WINDOW = "&Window";
    private ComponentPlaceholder info;
    protected DockingWindowManager winMgr;

    private static String truncateTitleAsNeeded(String title) {
        if (title.length() <= 40) {
            return title;
        }
        return title.substring(0, 37) + "...";
    }

    protected ShowComponentAction(DockingWindowManager winMgr, String name, String subMenuName) {
        super(ShowComponentAction.truncateTitleAsNeeded(name), "DockingWindows");
    }

    ShowComponentAction(DockingWindowManager winMgr, ComponentPlaceholder info, String subMenuName, boolean isTransient) {
        super(ShowComponentAction.truncateTitleAsNeeded(info.getTitle()), "DockingWindows");
        String group = isTransient ? "Transient" : "Permanent";
        Icon icon = info.getIcon();
        if (icon == null) {
            icon = EMPTY_ICON;
        }
        if (subMenuName != null) {
            this.setMenuBarData(new MenuData(new String[]{MENU_WINDOW, subMenuName, info.getFullTitle()}, icon, "Permanent"));
            winMgr.doSetMenuGroup(new String[]{MENU_WINDOW, subMenuName}, group);
        } else {
            this.setMenuBarData(new MenuData(new String[]{MENU_WINDOW, this.getName()}, icon, "Permanent"));
        }
        this.info = info;
        this.winMgr = winMgr;
        ComponentProvider provider = info.getProvider();
        HelpLocation helpLocation = provider.getHelpLocation();
        if (helpLocation != null) {
            this.setHelpLocation(helpLocation);
        } else {
            this.markHelpUnnecessary();
        }
    }

    @Override
    public void actionPerformed(ActionContext context) {
        this.winMgr.showComponent(this.info, true, true);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    @Override
    public int compareTo(ShowComponentAction other) {
        String[] myMenuPath = this.getMenuBarData().getMenuPath();
        String[] otherMenuPath = other.getMenuBarData().getMenuPath();
        int loopLength = Math.min(myMenuPath.length, otherMenuPath.length);
        for (int i = 0; i < loopLength; ++i) {
            int result = myMenuPath[i].compareTo(otherMenuPath[i]);
            if (result == 0) continue;
            return result;
        }
        return myMenuPath.length - otherMenuPath.length;
    }

    @Override
    public String getHelpInfo() {
        StringBuilder buffy = new StringBuilder(super.getHelpInfo());
        Class<?> clazz = this.info.getProvider().getClass();
        String className = clazz.getName();
        String filename = className.substring(className.lastIndexOf(46) + 1);
        String javaName = filename + ".java";
        buffy.append("    ").append("PROVIDER:    ").append(this.info.getName()).append(' ');
        buffy.append('(').append(javaName).append(":1)");
        buffy.append("\n    ");
        return buffy.toString();
    }
}

