/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.menu.MenuHandler;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class MenuBarMenuHandler
extends MenuHandler {
    private final DockingWindowManager windowManager;

    public MenuBarMenuHandler(DockingWindowManager windowManager) {
        this.windowManager = windowManager;
    }

    @Override
    public void menuItemEntered(DockingActionIf action) {
        DockingWindowManager.setMouseOverAction(action);
    }

    @Override
    public void menuItemExited(DockingActionIf action) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void processMenuAction(final DockingActionIf action, ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        ComponentProvider provider = this.windowManager.getActiveComponentProvider();
        ActionContext context = provider == null ? null : provider.getActionContext(null);
        ActionContext localContext = context == null ? new ActionContext() : context;
        ActionContext globalContext = this.windowManager.getGlobalContext();
        ActionContext tempContext = null;
        if (action.isValidContext(localContext)) {
            tempContext = localContext;
        } else if (action.isValidGlobalContext(globalContext)) {
            tempContext = globalContext;
        } else {
            return;
        }
        tempContext.setSource(event.getSource());
        final ActionContext finalContext = tempContext;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuBarMenuHandler.this.windowManager.setStatusText("");
                if (action.isEnabledForContext(finalContext)) {
                    if (action instanceof ToggleDockingActionIf) {
                        ToggleDockingActionIf toggleAction;
                        toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                    }
                    action.actionPerformed(finalContext);
                }
            }
        });
    }
}

