/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockingUtils;
import docking.ToolTipManager;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.EmptyBorderButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class EmptyBorderToggleButton
extends EmptyBorderButton {
    private ActionListener toggleButtonActionListener = e -> this.doActionPerformed(e);
    protected PropertyChangeListener propertyChangeListener = evt -> this.doPropertyChange(evt);

    public EmptyBorderToggleButton() {
        this.init();
    }

    public EmptyBorderToggleButton(Icon icon) {
        super(icon);
        this.init();
    }

    public EmptyBorderToggleButton(DockingActionIf action) {
        this.initFromAction(action);
        this.updateBorder();
        this.init();
    }

    protected void initFromAction(DockingActionIf action) {
        if (action == null) {
            return;
        }
        ToolBarData toolBarData = action.getToolBarData();
        Icon icon = toolBarData == null ? null : toolBarData.getIcon();
        this.setIcon(icon);
        String tt = action.getDescription();
        if (tt == null || tt.length() == 0) {
            tt = action.getName();
        }
        this.setToolTipText(tt);
        this.setEnabled(action.isEnabled());
    }

    private void init() {
        this.addActionListener(this.toggleButtonActionListener);
        this.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void removeListeners() {
        super.removeListeners();
        this.removeActionListener(this.toggleButtonActionListener);
        this.removePropertyChangeListener(this.propertyChangeListener);
    }

    private void updateBorder() {
        if (this.isButtonSelected()) {
            this.setBorder(LOWERED_BUTTON_BORDER);
        } else {
            this.setBorder(NO_BUTTON_BORDER);
        }
    }

    protected boolean isButtonSelected() {
        return this.isSelected();
    }

    protected void doActionPerformed(ActionEvent e) {
        this.setSelected(!this.isSelected());
        Action buttonAction = this.getAction();
        if (buttonAction == null) {
            return;
        }
        buttonAction.actionPerformed(e);
    }

    private void doPropertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("enabled")) {
            this.setEnabled((Boolean)e.getNewValue());
        } else if (name.equals("ShortDescription")) {
            ToolTipManager.setToolTipText(this, (String)e.getNewValue());
        } else if (name.equals("SmallIcon")) {
            this.setIcon((Icon)e.getNewValue());
        } else if (name.equals("CheckBoxState")) {
            this.updateBorder();
        }
    }

    @Override
    public void clearBorder() {
        if (this.isButtonSelected()) {
            this.setBorder(LOWERED_BUTTON_BORDER);
            return;
        }
        super.clearBorder();
    }

    @Override
    public void raiseBorder() {
        if (this.isButtonSelected()) {
            return;
        }
        super.raiseBorder();
    }

    @Override
    public void setIcon(Icon newIcon) {
        super.setIcon(DockingUtils.scaleIconAsNeeded(newIcon));
    }

    protected void doSetIcon(Icon newIcon) {
        super.setIcon(newIcon);
    }

    @Override
    public void setSelected(boolean b) {
        boolean state = this.updateStateFromButtonGroup(b);
        super.setSelected(state);
        this.updateBorder();
    }

    private boolean updateStateFromButtonGroup(boolean b) {
        ButtonModel bm = this.getModel();
        if (!(bm instanceof DefaultButtonModel)) {
            return b;
        }
        DefaultButtonModel model = (DefaultButtonModel)bm;
        ButtonGroup group = model.getGroup();
        if (group == null) {
            return b;
        }
        group.setSelected(model, b);
        boolean isSelected = group.isSelected(model);
        return isSelected;
    }

    public void toggle() {
        this.doClick();
    }

    @Override
    protected void updateBorderBasedOnState() {
        if (this.isButtonSelected()) {
            return;
        }
        super.updateBorderBasedOnState();
    }
}

