/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentLoadedListener;
import docking.ComponentNode;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DefaultHelpService;
import docking.DetachedWindowNode;
import docking.DialogComponentProvider;
import docking.DockWinListener;
import docking.DockableComponent;
import docking.DockingActionManager;
import docking.DockingContextListener;
import docking.DockingDialog;
import docking.DropTargetFactory;
import docking.EditListener;
import docking.EditWindow;
import docking.KeyBindingOverrideKeyEventDispatcher;
import docking.PlaceholderInstaller;
import docking.PlaceholderManager;
import docking.RootNode;
import docking.ShowAllComponentsAction;
import docking.ShowComponentAction;
import docking.ShowWindowAction;
import docking.WindowNode;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.help.HelpService;
import generic.util.WindowUtilities;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.options.PreferenceState;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.LRUSet;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jdom.Content;
import org.jdom.Element;
import util.CollectionUtils;

public class DockingWindowManager
implements PropertyChangeListener,
PlaceholderInstaller {
    static final String COMPONENT_MENU_NAME = "Window";
    private static final List<DockingActionIf> EMPTY_LIST = Collections.emptyList();
    private static DockingActionIf actionUnderMouse;
    private static Object objectUnderMouse;
    public static final String TOOL_PREFERENCES_XML_NAME = "PREFERENCES";
    public static final String DOCKING_WINDOWS_OWNER = "DockingWindows";
    private static HelpService helpService;
    private static List<DockingWindowManager> instanceList;
    private RootNode root;
    private PlaceholderManager placeholderManager;
    private LRUSet<ComponentPlaceholder> lastFocusedPlaceholders = new LRUSet(20);
    private ActivatedInfo activatedInfo = new ActivatedInfo();
    private ComponentPlaceholder focusedPlaceholder;
    private ComponentPlaceholder nextFocusedPlaceholder;
    private ComponentProvider defaultProvider;
    private static Component pendingRequestFocusComponent;
    private Map<String, ComponentProvider> providerNameCache = new HashMap<String, ComponentProvider>();
    private Map<String, PreferenceState> preferenceStateMap = new HashMap<String, PreferenceState>();
    private DockWinListener docListener;
    private DockingActionManager actionManager;
    private WeakSet<DockingContextListener> contextListeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();
    private SwingUpdateManager rebuildUpdater = new SwingUpdateManager(100, 750, this::doUpdate);
    private boolean isVisible;
    private boolean isDocking;
    private boolean hasStatusBar;
    private EditWindow editWindow;
    private boolean windowsOnTop;
    private Window lastActiveWindow;

    public DockingWindowManager(String toolName, List<Image> images, DockWinListener docListener) {
        this(toolName, images, docListener, false, true, true, null);
    }

    public DockingWindowManager(String toolName, List<Image> images, DockWinListener docListener, boolean modal, boolean isDocking, boolean hasStatusBar, DropTargetFactory factory) {
        KeyBindingOverrideKeyEventDispatcher.install();
        this.docListener = docListener;
        this.isDocking = isDocking;
        this.hasStatusBar = hasStatusBar;
        if (images == null) {
            images = new ArrayList<Image>();
        }
        this.root = new RootNode(this, toolName, images, modal, factory);
        this.actionManager = new DockingActionManager(this);
        KeyboardFocusManager km = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        km.addPropertyChangeListener("permanentFocusOwner", this);
        DockingWindowManager.addInstance(this);
        this.placeholderManager = new PlaceholderManager(this);
    }

    public String toString() {
        return "DockingWindowManager: " + this.root.getTitle();
    }

    public static void enableDiagnosticActions(boolean enable) {
        DockingActionManager.enableDiagnosticActions(enable);
    }

    public static void setHelpService(HelpService helpSvc) {
        if (helpSvc == null) {
            throw new IllegalArgumentException("HelpService may not be null");
        }
        helpService = helpSvc;
    }

    public static HelpService getHelpService() {
        return helpService;
    }

    List<DockingActionIf> getTemporaryPopupActions(ActionContext context) {
        return this.docListener.getPopupActions(context);
    }

    private static synchronized void addInstance(DockingWindowManager winMgr) {
        instanceList.add(winMgr);
    }

    private static synchronized void removeInstance(DockingWindowManager winMgr) {
        instanceList.remove(winMgr);
    }

    private static DockingWindowManager getInstanceForWindow(Window win) {
        if (win == null) {
            return null;
        }
        for (DockingWindowManager winMgr : instanceList) {
            if (winMgr.root.getFrame() == win) {
                return winMgr;
            }
            List<DetachedWindowNode> detachedWindows = winMgr.root.getDetachedWindows();
            LinkedList<DetachedWindowNode> safeAccessCopy = new LinkedList<DetachedWindowNode>(detachedWindows);
            for (DetachedWindowNode dw : safeAccessCopy) {
                if (dw.getWindow() != win) continue;
                return winMgr;
            }
        }
        return null;
    }

    public static synchronized DockingWindowManager getInstance(Component component) {
        for (Window window = WindowUtilities.windowForComponent((Component)component); window != null; window = window.getOwner()) {
            DockingWindowManager windowManager = DockingWindowManager.getInstanceForWindow(window);
            if (windowManager == null) continue;
            return windowManager;
        }
        return null;
    }

    public static synchronized DockingWindowManager getActiveInstance() {
        for (int i = instanceList.size() - 1; i >= 0; --i) {
            DockingWindowManager mgr = instanceList.get(i);
            if (!mgr.root.isVisible()) continue;
            return mgr;
        }
        return null;
    }

    public static synchronized List<DockingWindowManager> getAllDockingWindowManagers() {
        return new ArrayList<DockingWindowManager>(instanceList);
    }

    static synchronized void setActiveManager(DockingWindowManager mgr) {
        if (instanceList.remove(mgr)) {
            instanceList.add(mgr);
        }
    }

    public static void setHelpLocation(JComponent c, HelpLocation helpLocation) {
        DockingActionManager.setHelpLocation(c, helpLocation);
    }

    public void setToolName(String toolName) {
        this.root.setToolName(toolName);
    }

    public void setIcon(ImageIcon icon) {
        this.root.setIcon(icon);
    }

    Action getActionForKeyStroke(KeyStroke keyStroke) {
        return this.actionManager.getDockingKeyAction(keyStroke);
    }

    public boolean containsProvider(ComponentProvider provider) {
        return this.placeholderManager.containsProvider(provider);
    }

    PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    DockingActionManager getActionManager() {
        return this.actionManager;
    }

    RootNode getRootNode() {
        return this.root;
    }

    public JFrame getRootFrame() {
        if (this.root == null) {
            return null;
        }
        return this.root.getFrame();
    }

    public void setDefaultComponent(ComponentProvider provider) {
        this.defaultProvider = provider;
    }

    public ActionContext getGlobalContext() {
        ActionContext actionContext;
        if (this.defaultProvider != null && (actionContext = this.defaultProvider.getActionContext(null)) != null) {
            return actionContext;
        }
        return new ActionContext();
    }

    public Window getProviderWindow(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            return this.root.getWindow(placeholder);
        }
        return null;
    }

    ComponentPlaceholder getActivePlaceholder(ComponentProvider provider) {
        return this.placeholderManager.getActivePlaceholder(provider);
    }

    public Window getActiveWindow() {
        if (this.lastActiveWindow != null) {
            return this.lastActiveWindow;
        }
        return this.root.getFrame();
    }

    public Component getActiveComponent() {
        if (this.focusedPlaceholder != null) {
            return this.focusedPlaceholder.getComponent();
        }
        return null;
    }

    public ComponentPlaceholder getFocusedComponent() {
        return this.focusedPlaceholder;
    }

    private ComponentPlaceholder getDefaultFocusComponent() {
        return this.placeholderManager.getActivePlaceholder(this.defaultProvider);
    }

    public boolean isActiveProvider(ComponentProvider provider) {
        boolean isActiveWindowManager = this == DockingWindowManager.getActiveInstance();
        boolean isFocusedProvider = this.focusedPlaceholder != null && this.focusedPlaceholder.getProvider() == provider;
        return isActiveWindowManager && isFocusedProvider;
    }

    public synchronized void setVisible(boolean state) {
        if (state != this.isVisible) {
            this.isVisible = state;
            if (state) {
                this.scheduleUpdate();
            }
            this.root.setVisible(state);
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isVisible(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            return placeholder.isShowing();
        }
        return false;
    }

    public void addComponent(ComponentProvider provider) {
        this.addComponent(provider, true);
    }

    public void addComponent(ComponentProvider provider, boolean show) {
        this.checkIfAlreadyAdded(provider);
        HelpLocation helpLoc = provider.getHelpLocation();
        this.registerHelpLocation(provider, helpLoc);
        ComponentPlaceholder placeholder = this.placeholderManager.createOrRecyclePlaceholder(provider);
        this.showComponent(placeholder, show, true);
        this.scheduleUpdate();
    }

    private void registerHelpLocation(ComponentProvider provider, HelpLocation helpLocation) {
        HelpLocation registeredHelpLocation = helpService.getHelpLocation(provider);
        if (registeredHelpLocation != null) {
            return;
        }
        if (helpLocation == null) {
            helpLocation = new HelpLocation(provider.getOwner(), provider.getName());
        }
        helpService.registerHelp(provider, helpLocation);
    }

    private void checkIfAlreadyAdded(ComponentProvider provider) {
        if (this.containsProvider(provider)) {
            throw new AssertException("ComponentProvider " + provider.getName() + " was already added.");
        }
    }

    public ComponentProvider getComponentProvider(String name) {
        ComponentProvider cachedProvider = this.providerNameCache.get(name);
        if (cachedProvider != null) {
            if (this.containsProvider(cachedProvider)) {
                return cachedProvider;
            }
            this.providerNameCache.remove(name);
        }
        Set<ComponentProvider> providers = this.placeholderManager.getActiveProviders();
        for (ComponentProvider provider : providers) {
            if (!name.equals(provider.getName())) continue;
            this.providerNameCache.put(name, provider);
            return provider;
        }
        return null;
    }

    public <T extends ComponentProvider> T getComponentProvider(Class<T> clazz) {
        List<T> allProviders = this.getComponentProviders(clazz);
        return (T)((ComponentProvider)CollectionUtils.any(allProviders));
    }

    public <T extends ComponentProvider> List<T> getComponentProviders(Class<T> clazz) {
        ArrayList<ComponentProvider> list = new ArrayList<ComponentProvider>();
        Set<ComponentProvider> providers = this.placeholderManager.getActiveProviders();
        for (ComponentProvider provider : providers) {
            if (!clazz.isAssignableFrom(provider.getClass())) continue;
            list.add((ComponentProvider)clazz.cast(provider));
        }
        return list;
    }

    DockableComponent getDockableComponent(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.placeholderManager.getPlaceholder(provider);
        return placeholder.getComponent();
    }

    ComponentPlaceholder getPlaceholder(ComponentProvider provider) {
        return this.placeholderManager.getPlaceholder(provider);
    }

    public void showComponentHeader(ComponentProvider provider, boolean b) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            placeholder.showHeader(b);
            this.scheduleUpdate();
        }
    }

    public void setIcon(ComponentProvider provider, Icon icon) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        placeholder.setIcon(icon);
        this.scheduleUpdate();
    }

    public void updateTitle(ComponentProvider provider) {
        ComponentPlaceholder placeholder;
        String title = provider.getTitle();
        if (title == null) {
            title = "";
        }
        if ((placeholder = this.getActivePlaceholder(provider)) == null) {
            return;
        }
        placeholder.update();
        this.scheduleUpdate();
        DetachedWindowNode wNode = placeholder.getWindowNode();
        if (wNode != null) {
            wNode.updateTitle();
        }
    }

    public String getSubTitle(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            return placeholder.getSubTitle();
        }
        return "";
    }

    public void removeComponent(ComponentProvider provider) {
        this.placeholderManager.removeComponent(provider);
    }

    public Iterator<DockingActionIf> getComponentActions(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            return placeholder.getActions();
        }
        return EMPTY_LIST.iterator();
    }

    public void removeAll(String owner) {
        this.actionManager.removeAll(owner);
        this.placeholderManager.removeAll(owner);
        this.scheduleUpdate();
    }

    public void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder == null) {
            throw new IllegalArgumentException("Unknown component provider: " + provider);
        }
        placeholder.addAction(action);
        this.actionManager.addLocalAction(action, provider);
    }

    public void removeProviderAction(ComponentProvider provider, DockingActionIf action) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            this.actionManager.removeLocalAction(action);
            placeholder.removeAction(action);
        }
    }

    public void addToolAction(DockingActionIf action) {
        this.actionManager.addToolAction(action);
        this.scheduleUpdate();
    }

    public void removeToolAction(DockingActionIf action) {
        this.actionManager.removeToolAction(action);
        this.scheduleUpdate();
    }

    public Collection<DockingActionIf> getActions(String fullActionName) {
        return this.actionManager.getAllDockingActionsByFullActionName(fullActionName);
    }

    public void showComponent(ComponentProvider provider, boolean visibleState) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder != null) {
            this.showComponent(placeholder, visibleState, true);
        }
    }

    public void toFront(ComponentProvider provider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(provider);
        if (placeholder == null) {
            return;
        }
        if (!placeholder.isShowing()) {
            this.showComponent(placeholder, true, false);
        }
        this.movePlaceholderToFront(placeholder, false);
    }

    public void toFront(Window window) {
        if (window == null) {
            return;
        }
        if (window == this.getMainWindow()) {
            window.toFront();
            return;
        }
        OperatingSystem operatingSystem = Platform.CURRENT_PLATFORM.getOperatingSystem();
        if (operatingSystem == OperatingSystem.WINDOWS) {
            Frame frame;
            int state;
            if (window instanceof Frame && ((state = (frame = (Frame)window).getState()) & 1) == 1) {
                frame.setState(0);
                return;
            }
            window.setVisible(false);
            window.setVisible(true);
        } else if (operatingSystem == OperatingSystem.LINUX) {
            Frame frame;
            int state;
            if (window instanceof Frame && ((state = (frame = (Frame)window).getState()) & 1) == 1) {
                frame.setState(0);
            }
            window.toFront();
        } else {
            window.toFront();
        }
    }

    public synchronized void dispose() {
        if (this.root == null) {
            return;
        }
        this.rebuildUpdater.dispose();
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        mgr.removePropertyChangeListener("permanentFocusOwner", this);
        this.actionManager.dispose();
        this.root.dispose();
        this.placeholderManager.disposePlaceholders();
        this.setNextFocusPlaceholder(null);
        DockingWindowManager.removeInstance(this);
        this.root = null;
    }

    void showComponent(ComponentPlaceholder placeholder, boolean visibleState, boolean requestFocus) {
        if (this.root == null) {
            return;
        }
        if (visibleState == placeholder.isShowing()) {
            if (visibleState) {
                this.movePlaceholderToFront(placeholder, true);
                this.setNextFocusPlaceholder(placeholder);
                this.scheduleUpdate();
            }
            return;
        }
        placeholder.show(visibleState);
        this.movePlaceholderToFront(placeholder, false);
        if (visibleState) {
            if (placeholder.getNode() == null) {
                this.root.add(placeholder);
            }
            if (requestFocus) {
                this.setNextFocusPlaceholder(placeholder);
            }
        } else if (this.focusedPlaceholder == placeholder) {
            this.clearFocusedComponent();
        }
        this.scheduleUpdate();
    }

    private void movePlaceholderToFront(ComponentPlaceholder placeholder, boolean emphasisze) {
        placeholder.toFront();
        if (emphasisze) {
            this.activatedInfo.activated(placeholder);
        }
        this.toFront(this.root.getWindow(placeholder));
    }

    public void saveToXML(Element rootXMLElement) {
        Element rootNodeElement = this.saveWindowingDataToXml();
        if (this.focusedPlaceholder != null) {
            rootNodeElement.setAttribute("FOCUSED_OWNER", this.focusedPlaceholder.getOwner());
            rootNodeElement.setAttribute("FOCUSED_NAME", this.focusedPlaceholder.getName());
            rootNodeElement.setAttribute("FOCUSED_TITLE", this.focusedPlaceholder.getTitle());
        }
        rootXMLElement.removeChild(rootNodeElement.getName());
        rootXMLElement.addContent((Content)rootNodeElement);
        Element preferencesElement = this.savePreferencesToXML();
        rootXMLElement.removeChild(preferencesElement.getName());
        rootXMLElement.addContent((Content)preferencesElement);
    }

    public Element saveWindowingDataToXml() {
        return this.root.saveToXML();
    }

    public void restoreFromXML(Element rootXMLElement) {
        Element rootNodeElement = rootXMLElement.getChild("ROOT_NODE");
        this.restoreWindowDataFromXml(rootNodeElement);
        this.restorePreferencesFromXML(rootXMLElement);
    }

    public void restoreWindowDataFromXml(Element windowData) {
        this.clearFocusedComponent();
        this.lastFocusedPlaceholders.clear();
        Map<ComponentProvider, ComponentPlaceholder> activeProviders = this.placeholderManager.getActiveProvidersToPlaceholders();
        List<ComponentPlaceholder> restoredPlaceholders = this.root.restoreFromXML(windowData);
        this.placeholderManager = new PlaceholderManager(this, restoredPlaceholders);
        String focusedOwner = windowData.getAttributeValue("FOCUSED_OWNER");
        String focusedName = windowData.getAttributeValue("FOCUSED_NAME");
        String focusedTitle = windowData.getAttributeValue("FOCUSED_TITLE");
        ComponentPlaceholder lastFoundFocusReplacement = null;
        List<Map.Entry<ComponentProvider, ComponentPlaceholder>> sortedProviders = this.sortActiveProviders(activeProviders);
        for (Map.Entry<ComponentProvider, ComponentPlaceholder> entry : sortedProviders) {
            ComponentProvider provider = entry.getKey();
            ComponentPlaceholder oldPlaceholder = entry.getValue();
            ComponentPlaceholder newPlaceholder = this.placeholderManager.replacePlaceholder(provider, oldPlaceholder);
            if (!SystemUtilities.isEqual((Object)focusedTitle, (Object)oldPlaceholder.getTitle())) continue;
            lastFoundFocusReplacement = newPlaceholder;
        }
        this.restoreSavedFocusedPlaceholder(focusedOwner, focusedName, focusedTitle, lastFoundFocusReplacement);
        this.placeholderManager.resetPlaceholdersWithoutProviders();
        this.scheduleUpdate();
    }

    private void restoreSavedFocusedPlaceholder(String focusOwner, String focusName, String focusTitle, ComponentPlaceholder bestFocusReplacementPlaceholder) {
        if (bestFocusReplacementPlaceholder != null) {
            this.setNextFocusPlaceholder(bestFocusReplacementPlaceholder);
            return;
        }
        this.restoreFocusOwner(focusOwner, focusName);
    }

    private List<Map.Entry<ComponentProvider, ComponentPlaceholder>> sortActiveProviders(Map<ComponentProvider, ComponentPlaceholder> activeProviders) {
        Set<Map.Entry<ComponentProvider, ComponentPlaceholder>> entrySet = activeProviders.entrySet();
        ArrayList<Map.Entry<ComponentProvider, ComponentPlaceholder>> list = new ArrayList<Map.Entry<ComponentProvider, ComponentPlaceholder>>(entrySet);
        Collections.sort(list, (e1, e2) -> {
            ComponentProvider p1 = (ComponentProvider)e1.getKey();
            ComponentProvider p2 = (ComponentProvider)e2.getKey();
            String g1 = p1.getWindowGroup();
            String g2 = p2.getWindowGroup();
            return g1.compareToIgnoreCase(g2);
        });
        return list;
    }

    @Override
    public void installPlaceholder(ComponentPlaceholder placeholder, WindowPosition position) {
        this.root.add(placeholder, position);
    }

    @Override
    public void uninstallPlaceholder(ComponentPlaceholder placeholder, boolean keepAround) {
        this.disposePlaceholder(placeholder, keepAround);
        this.clearCurrentOrPendingFocusForRemovedPlaceholder(placeholder);
    }

    private void disposePlaceholder(ComponentPlaceholder placeholder, boolean keepAround) {
        Iterator<DockingActionIf> iter = placeholder.getActions();
        while (iter.hasNext()) {
            DockingActionIf action = iter.next();
            this.actionManager.removeLocalAction(action);
        }
        ComponentNode node = placeholder.getNode();
        if (node == null) {
            return;
        }
        node.remove(placeholder, keepAround);
    }

    synchronized void clearCurrentOrPendingFocusForRemovedPlaceholder(ComponentPlaceholder placeholder) {
        if (this.focusedPlaceholder == placeholder) {
            this.clearFocusedComponent();
        } else if (this.nextFocusedPlaceholder == placeholder) {
            this.clearFocusedComponent();
        }
    }

    void movePlaceholder(ComponentPlaceholder source, Point p) {
        ComponentNode sourceNode = source.getNode();
        sourceNode.remove(source);
        this.root.add(source, p);
        this.scheduleUpdate();
    }

    void movePlaceholder(ComponentPlaceholder source, ComponentPlaceholder destination, WindowPosition windowPosition) {
        ComponentNode sourceNode = source.getNode();
        if (destination != null) {
            ComponentNode destinationNode = destination.getNode();
            sourceNode.remove(source);
            if (windowPosition == WindowPosition.STACK) {
                destinationNode.add(source);
            } else {
                destinationNode.split(source, windowPosition);
            }
        } else {
            sourceNode.remove(source);
            this.root.add(source, WindowPosition.RIGHT);
        }
        this.setNextFocusPlaceholder(source);
        this.scheduleUpdate();
    }

    void close() {
        this.docListener.close();
    }

    boolean isDocking() {
        return this.isDocking;
    }

    private void buildComponentMenu() {
        if (!this.isDocking || !this.isVisible) {
            return;
        }
        if (this.isWindowMenuShowing()) {
            this.scheduleUpdate();
            return;
        }
        this.actionManager.removeAll(DOCKING_WINDOWS_OWNER);
        HashMap<String, List<ComponentPlaceholder>> permanentMap = new HashMap<String, List<ComponentPlaceholder>>();
        HashMap<String, List<ComponentPlaceholder>> transientMap = new HashMap<String, List<ComponentPlaceholder>>();
        Map<ComponentProvider, ComponentPlaceholder> map = this.placeholderManager.getActiveProvidersToPlaceholders();
        Set<Map.Entry<ComponentProvider, ComponentPlaceholder>> entrySet = map.entrySet();
        for (Map.Entry<ComponentProvider, ComponentPlaceholder> entry : entrySet) {
            ComponentProvider provider = entry.getKey();
            ComponentPlaceholder placeholder = entry.getValue();
            String subMenuName = provider.getWindowSubMenuName();
            if (provider.isTransient()) {
                this.addToMap(transientMap, subMenuName, placeholder);
                continue;
            }
            this.addToMap(permanentMap, subMenuName, placeholder);
        }
        this.promoteSingleMenuGroups(permanentMap);
        this.promoteSingleMenuGroups(transientMap);
        this.createActions(transientMap, true);
        this.createActions(permanentMap, false);
        this.createWindowActions();
        this.actionManager.update();
    }

    private boolean isWindowMenuShowing() {
        MenuElement[] selectedPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (selectedPath == null || selectedPath.length == 0) {
            return false;
        }
        JMenu menu = this.getMenuForSelection(selectedPath);
        if (menu == null) {
            return false;
        }
        String text = menu.getText();
        return text.equals(COMPONENT_MENU_NAME);
    }

    private JMenu getMenuForSelection(MenuElement[] selectedPath) {
        for (MenuElement element : selectedPath) {
            if (!(element instanceof JMenu)) continue;
            return (JMenu)element;
        }
        return null;
    }

    private void createActions(Map<String, List<ComponentPlaceholder>> map, boolean isTransient) {
        ArrayList<ShowComponentAction> actionList = new ArrayList<ShowComponentAction>();
        for (String subMenuName : map.keySet()) {
            List<ComponentPlaceholder> placeholders = map.get(subMenuName);
            for (ComponentPlaceholder placeholder : placeholders) {
                actionList.add(new ShowComponentAction(this, placeholder, subMenuName, isTransient));
            }
            if (subMenuName == null) continue;
            actionList.add(new ShowAllComponentsAction(this, placeholders, subMenuName));
        }
        Collections.sort(actionList);
        for (ShowComponentAction action : actionList) {
            this.actionManager.addToolAction(action);
        }
    }

    private void promoteSingleMenuGroups(Map<String, List<ComponentPlaceholder>> map) {
        ArrayList<String> lists = new ArrayList<String>(map.keySet());
        for (String key : lists) {
            List<ComponentPlaceholder> list = map.get(key);
            if (key == null || list.size() != 1) continue;
            this.addToMap(map, null, list.get(0));
            map.remove(key);
        }
    }

    private void addToMap(Map<String, List<ComponentPlaceholder>> map, String menuGroup, ComponentPlaceholder placeholder) {
        List<ComponentPlaceholder> list = map.get(menuGroup);
        if (list == null) {
            list = new ArrayList<ComponentPlaceholder>();
            map.put(menuGroup, list);
        }
        list.add(placeholder);
    }

    private void createWindowActions() {
        List<DetachedWindowNode> windows = this.root.getDetachedWindows();
        ArrayList<ShowWindowAction> actions = new ArrayList<ShowWindowAction>();
        for (DetachedWindowNode node : windows) {
            Window window = node.getWindow();
            if (window == null) continue;
            actions.add(new ShowWindowAction(node));
        }
        Collections.sort(actions);
        for (ShowWindowAction action : actions) {
            this.actionManager.addToolAction(action);
        }
    }

    void scheduleUpdate() {
        this.rebuildUpdater.updateLater();
    }

    private boolean updatePending() {
        return this.rebuildUpdater.isBusy();
    }

    private synchronized void doUpdate() {
        if (!this.isVisible) {
            return;
        }
        this.root.update();
        this.buildComponentMenu();
        SystemUtilities.runSwingLater(() -> this.updateFocus());
    }

    private void updateFocus() {
        if (this.updatePending()) {
            return;
        }
        if (this.root == null) {
            return;
        }
        if (!this.getMainWindow().isShowing()) {
            this.scheduleUpdate();
            return;
        }
        this.updateFocus(this.maybeGetPlaceholderToFocus());
    }

    private synchronized void setNextFocusPlaceholder(ComponentPlaceholder placeholder) {
        this.nextFocusedPlaceholder = placeholder;
    }

    private synchronized ComponentPlaceholder maybeGetPlaceholderToFocus() {
        if (this.nextFocusedPlaceholder != null) {
            ComponentPlaceholder temp = this.nextFocusedPlaceholder;
            this.setNextFocusPlaceholder(null);
            return temp;
        }
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner == null) {
            return this.findNextFocusedComponent();
        }
        return null;
    }

    private void updateFocus(ComponentPlaceholder placeholder) {
        if (placeholder == null) {
            return;
        }
        SystemUtilities.runSwingLater(() -> {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window activeWindow = kfm.getActiveWindow();
            if (activeWindow == null) {
                return;
            }
            placeholder.requestFocus();
        });
    }

    public void showEditWindow(String defaultText, Component c, Rectangle r, EditListener listener) {
        if (this.editWindow == null) {
            this.editWindow = new EditWindow(this);
        }
        this.editWindow.show(defaultText, c, r, listener);
    }

    void restoreFocusOwner(String focusOwner, String focusName) {
        if (focusOwner == null) {
            this.setNextFocusPlaceholder(this.getDefaultFocusComponent());
            return;
        }
        ComponentPlaceholder focusReplacement = this.getDefaultFocusComponent();
        Map<ComponentProvider, ComponentPlaceholder> map = this.placeholderManager.getActiveProvidersToPlaceholders();
        Set<Map.Entry<ComponentProvider, ComponentPlaceholder>> entrySet = map.entrySet();
        for (Map.Entry<ComponentProvider, ComponentPlaceholder> entry : entrySet) {
            ComponentProvider provider = entry.getKey();
            ComponentPlaceholder placeholder = entry.getValue();
            if (!provider.getOwner().equals(focusOwner) || !provider.getName().equals(focusName)) continue;
            focusReplacement = placeholder;
            break;
        }
        this.setNextFocusPlaceholder(focusReplacement);
    }

    private void setFocusedComponent(ComponentPlaceholder placeholder) {
        if (this.focusedPlaceholder != null) {
            if (this.focusedPlaceholder == placeholder) {
                return;
            }
            this.focusedPlaceholder.setSelected(false);
        }
        this.focusedPlaceholder = placeholder;
        this.lastFocusedPlaceholders.add((Object)this.focusedPlaceholder);
        this.focusedPlaceholder.setSelected(true);
        WindowNode topLevelNode = this.focusedPlaceholder.getTopLevelNode();
        if (topLevelNode == null) {
            return;
        }
        topLevelNode.setLastFocusedProviderInWindow(this.focusedPlaceholder);
        this.root.notifyWindowFocusChanged(topLevelNode);
    }

    private ComponentPlaceholder findNextFocusedComponent() {
        Iterator iterator = this.lastFocusedPlaceholders.iterator();
        while (iterator.hasNext()) {
            ComponentPlaceholder placeholder = (ComponentPlaceholder)iterator.next();
            if (placeholder.isShowing()) {
                return placeholder;
            }
            iterator.remove();
        }
        return this.getActivePlaceholder(this.defaultProvider);
    }

    private void clearFocusedComponent() {
        if (this.focusedPlaceholder != null) {
            this.lastFocusedPlaceholders.remove((Object)this.focusedPlaceholder);
            this.focusedPlaceholder.setSelected(false);
            WindowNode topLevelNode = this.focusedPlaceholder.getTopLevelNode();
            if (topLevelNode != null) {
                topLevelNode.setLastFocusedProviderInWindow(null);
                this.root.notifyWindowFocusChanged(topLevelNode);
            }
        }
        this.focusedPlaceholder = null;
        this.setNextFocusPlaceholder(null);
    }

    void setActive(Window window, boolean active) {
        if (this.root == null) {
            return;
        }
        this.actionManager.setActive(active);
        if (active) {
            DockingWindowManager.setActiveManager(this);
            if (this.focusedPlaceholder != null && this.root.getWindow(this.focusedPlaceholder) == window) {
                this.focusedPlaceholder.setSelected(true);
            }
        } else if (this.focusedPlaceholder != null) {
            this.focusedPlaceholder.setSelected(false);
        }
    }

    static void requestFocus(Component component) {
        if (component.hasFocus()) {
            return;
        }
        if (pendingRequestFocusComponent != null) {
            pendingRequestFocusComponent = null;
            return;
        }
        pendingRequestFocusComponent = component;
        pendingRequestFocusComponent.requestFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (!this.isMyWindow(win)) {
            return;
        }
        this.lastActiveWindow = win;
        Component newFocusComponent = (Component)evt.getNewValue();
        if (newFocusComponent == null) {
            return;
        }
        DockableComponent dockableComponent = this.getDockableComponentForFocusOwner(win, newFocusComponent);
        if (dockableComponent == null) {
            return;
        }
        if (!this.ensureDockableComponentContainsFocusOwner(newFocusComponent, dockableComponent)) {
            return;
        }
        ComponentPlaceholder placeholder = dockableComponent.getComponentWindowingPlaceholder();
        if (placeholder == null) {
            return;
        }
        pendingRequestFocusComponent = null;
        dockableComponent.setFocusedComponent(newFocusComponent);
        SystemUtilities.runSwingLater(() -> this.setFocusedComponent(placeholder));
    }

    private boolean ensureDockableComponentContainsFocusOwner(Component newFocusComponent, DockableComponent dockableComponent) {
        if (this.isFocusComponentInEditingWindow(newFocusComponent)) {
            return false;
        }
        if (!SwingUtilities.isDescendingFrom(newFocusComponent, dockableComponent)) {
            dockableComponent.requestFocus();
            return false;
        }
        return true;
    }

    private boolean isFocusComponentInEditingWindow(Component newFocusComponent) {
        if (this.editWindow == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(newFocusComponent, this.editWindow);
    }

    private DockableComponent getDockableComponentForFocusOwner(Window window, Component focusedComp) {
        DockableComponent dockableComponent = this.getDockableComponent(focusedComp);
        if (dockableComponent != null) {
            return dockableComponent;
        }
        WindowNode node = this.root.getNodeForWindow(window);
        if (node == null) {
            throw new AssertException("Cant find node for window!!");
        }
        ComponentPlaceholder placeHolder = node.getLastFocusedProviderInWindow();
        if (placeHolder != null) {
            return placeHolder.getComponent();
        }
        return null;
    }

    private DockableComponent getDockableComponent(Component comp) {
        while (comp != null) {
            if (comp instanceof DockableComponent) {
                return (DockableComponent)comp;
            }
            if (comp instanceof EditWindow) {
                return this.getDockableComponent(((EditWindow)comp).getAssociatedComponent());
            }
            comp = comp.getParent();
        }
        return null;
    }

    private Element savePreferencesToXML() {
        Element toolPreferencesElement = new Element(TOOL_PREFERENCES_XML_NAME);
        Set<Map.Entry<String, PreferenceState>> entrySet = this.preferenceStateMap.entrySet();
        for (Map.Entry<String, PreferenceState> entry : entrySet) {
            String key = entry.getKey();
            PreferenceState state = entry.getValue();
            Element preferenceElement = state.saveToXml();
            preferenceElement.setAttribute("NAME", key);
            toolPreferencesElement.addContent((Content)preferenceElement);
        }
        return toolPreferencesElement;
    }

    private void restorePreferencesFromXML(Element rootElement) {
        Element toolPreferencesElement = rootElement.getChild(TOOL_PREFERENCES_XML_NAME);
        if (toolPreferencesElement == null) {
            return;
        }
        List children = toolPreferencesElement.getChildren("PREFERENCE_STATE");
        for (Object name : children) {
            Element preferencesElement = (Element)name;
            this.preferenceStateMap.put(preferencesElement.getAttribute("NAME").getValue(), new PreferenceState(preferencesElement));
        }
    }

    public void putPreferenceState(String key, PreferenceState state) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null!");
        }
        this.preferenceStateMap.put(key, state);
    }

    public PreferenceState getPreferenceState(String key) {
        return this.preferenceStateMap.get(key);
    }

    public void removePreferenceState(String key) {
        this.preferenceStateMap.remove(key);
    }

    private boolean isMyWindow(Window win) {
        if (this.root == null) {
            return false;
        }
        if (this.root.getMainWindow() == win) {
            return true;
        }
        Iterator<DetachedWindowNode> iter = this.root.getDetachedWindows().iterator();
        while (iter.hasNext()) {
            if (iter.next().getWindow() != win) continue;
            return true;
        }
        return false;
    }

    public static void showDialogOnActiveWindow(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog(null, dialogComponent, null);
    }

    public static void showDialog(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialogOnActiveWindow(dialogComponent);
    }

    public static void showDialog(DialogComponentProvider dialogComponent, Component centeredOnComponent) {
        Window parent = null;
        for (Component c = centeredOnComponent; c != null; c = c.getParent()) {
            if (!(c instanceof Frame) && !(c instanceof Dialog)) continue;
            parent = (Window)c;
            break;
        }
        DockingWindowManager.showDialog(parent, dialogComponent, centeredOnComponent);
    }

    public void showDialog(DialogComponentProvider dialogComponent, ComponentProvider centeredOnProvider) {
        ComponentPlaceholder placeholder = this.getActivePlaceholder(centeredOnProvider);
        DockableComponent c = null;
        Window parent = null;
        if (placeholder != null) {
            parent = this.root.getWindow(placeholder);
            c = placeholder.getComponent();
        }
        DockingWindowManager.showDialog(parent, dialogComponent, c);
    }

    private static void doShowDialog(DialogComponentProvider provider, Component parent, Component centeredOnComponent) {
        Runnable r = () -> {
            if (provider.isVisible()) {
                provider.toFront();
                return;
            }
            Window updatedParent = DockingWindowManager.getParentWindow(parent);
            Component updatedCenter = DockingWindowManager.getCenterOnComponent(centeredOnComponent);
            DockingDialog dialog = DockingDialog.createDialog(updatedParent, provider, updatedCenter);
            dialog.setVisible(true);
        };
        if (provider.isModal()) {
            SystemUtilities.runSwingNow((Runnable)r);
        } else {
            SystemUtilities.runIfSwingOrPostSwingLater((Runnable)r);
        }
    }

    private static Component getCenterOnComponent(Component centeredOnComponent) {
        if (centeredOnComponent != null) {
            return centeredOnComponent;
        }
        Window activeWindow = DockingWindowManager.getActiveNonTransientWindow();
        return activeWindow;
    }

    public static void showDialog(Component parent, DialogComponentProvider dialogComponent) {
        DockingWindowManager.doShowDialog(dialogComponent, parent, null);
    }

    public static void showDialog(Window parent, DialogComponentProvider dialogComponent, Component centeredOnComponent) {
        DockingWindowManager.doShowDialog(dialogComponent, parent, centeredOnComponent);
    }

    private static Window getParentWindow(Component parent) {
        JFrame defaultWindow;
        if (DockingWindowManager.isNonTransientWindow(parent)) {
            return (Window)parent;
        }
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        JFrame jFrame = defaultWindow = dwm != null ? dwm.getRootFrame() : null;
        if (parent == null) {
            Window w = DockingWindowManager.getActiveNonTransientWindow();
            return w == null ? defaultWindow : w;
        }
        for (Component c = parent; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Window)c;
        }
        return defaultWindow;
    }

    private static boolean isNonTransientWindow(Component c) {
        if (c instanceof DockingDialog) {
            DockingDialog d = (DockingDialog)c;
            DialogComponentProvider provider = d.getComponent();
            if (provider == null) {
                return false;
            }
            if (provider.isTransient()) {
                return false;
            }
        }
        return c instanceof Window;
    }

    private static Window getActiveNonTransientWindow() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = kfm.getActiveWindow();
        if (!(activeWindow instanceof DockingDialog)) {
            return activeWindow;
        }
        DockingDialog d = (DockingDialog)activeWindow;
        Window ancestor = SwingUtilities.getWindowAncestor(d);
        if (!d.isShowing()) {
            if (!ancestor.isShowing()) {
                return null;
            }
            return ancestor;
        }
        DialogComponentProvider provider = d.getComponent();
        if (provider.isTransient()) {
            return ancestor;
        }
        return d;
    }

    public ComponentProvider getActiveComponentProvider() {
        if (this.focusedPlaceholder != null) {
            return this.focusedPlaceholder.getProvider();
        }
        return null;
    }

    public void setHomeButton(Icon icon, Runnable callback) {
        this.root.setHomeButton(icon, callback);
    }

    public boolean hasStatusBar() {
        return this.hasStatusBar;
    }

    public void addStatusItem(JComponent c, boolean addBorder, boolean rightSide) {
        this.root.addStatusItem(c, addBorder, rightSide);
    }

    public void removeStatusItem(JComponent c) {
        this.root.removeStatusItem(c);
    }

    public void setStatusText(String text) {
        if (this.root != null) {
            this.root.setStatusText(text);
        }
    }

    public void setMenuGroup(String[] menuPath, String group) {
        this.doSetMenuGroup(menuPath, group);
        this.scheduleUpdate();
    }

    void doSetMenuGroup(String[] menuPath, String group) {
        this.actionManager.setMenuGroup(menuPath, group);
    }

    public void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        this.actionManager.setMenuGroup(menuPath, group, menuSubGroup);
        this.scheduleUpdate();
    }

    static boolean excludeFocus(Component c) {
        return c instanceof JScrollPane || c instanceof JScrollBar || c instanceof JTabbedPane;
    }

    public void setWindowsOnTop(boolean windowsOnTop) {
        this.windowsOnTop = windowsOnTop;
        this.root.updateDialogs();
    }

    public boolean isWindowsOnTop() {
        return this.windowsOnTop;
    }

    public List<Window> getWindows(boolean includeMain) {
        ArrayList<Window> winList = new ArrayList<Window>();
        if (includeMain) {
            winList.add(this.root.getMainWindow());
        }
        for (DetachedWindowNode node : this.root.getDetachedWindows()) {
            Window win = node.getWindow();
            if (win == null) continue;
            winList.add(win);
        }
        return winList;
    }

    void iconify() {
        List<Window> winList = this.getWindows(false);
        for (Window w : winList) {
            if (!(w instanceof Frame)) continue;
            w.setVisible(false);
        }
    }

    void deIconify() {
        List<Window> winList = this.getWindows(false);
        for (Window w : winList) {
            if (!(w instanceof Frame)) continue;
            w.setVisible(true);
        }
    }

    public Window getMainWindow() {
        return this.root.getMainWindow();
    }

    public static DockingActionIf getMouseOverAction() {
        return actionUnderMouse;
    }

    public static void setMouseOverAction(DockingActionIf action) {
        actionUnderMouse = action;
    }

    public static Object getMouseOverObject() {
        return objectUnderMouse;
    }

    public static void setMouseOverObject(Object object) {
        objectUnderMouse = object;
    }

    public static void clearMouseOverHelp() {
        actionUnderMouse = null;
        objectUnderMouse = null;
    }

    public void contextChanged(ComponentProvider provider) {
        if (provider == null) {
            this.actionManager.contextChangedAll();
            return;
        }
        ComponentPlaceholder placeHolder = this.getActivePlaceholder(provider);
        if (placeHolder == null) {
            return;
        }
        placeHolder.contextChanged();
        this.actionManager.contextChanged(placeHolder);
    }

    public void addContextListener(DockingContextListener listener) {
        this.contextListeners.add((Object)listener);
    }

    public void removeContextListener(DockingContextListener listener) {
        this.contextListeners.remove((Object)listener);
    }

    public void notifyContextListeners(ComponentPlaceholder placeHolder, ActionContext actionContext) {
        if (placeHolder == this.focusedPlaceholder) {
            for (DockingContextListener listener : this.contextListeners) {
                listener.contextChanged(actionContext);
            }
        }
    }

    public static void registerComponentLoadedListener(final Component component, final ComponentLoadedListener listener) {
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                boolean isDisplayable;
                long changeFlags = e.getChangeFlags();
                if (2L == (changeFlags & 2L) && (isDisplayable = component.isDisplayable())) {
                    component.removeHierarchyListener(this);
                    DockingWindowManager windowManager = DockingWindowManager.getInstance(component);
                    listener.componentLoaded(windowManager);
                }
            }
        });
    }

    static {
        helpService = new DefaultHelpService();
        instanceList = new ArrayList<DockingWindowManager>();
    }

    private class ActivatedInfo {
        private long lastCalledTimestamp;
        private ComponentPlaceholder lastActivatedPlaceholder;

        private ActivatedInfo() {
        }

        void activated(ComponentPlaceholder placeholder) {
            if (this.lastActivatedPlaceholder == placeholder) {
                long elapsedTime = System.currentTimeMillis() - this.lastCalledTimestamp;
                if (elapsedTime < 3000L) {
                    placeholder.emphasize();
                }
            } else {
                this.lastActivatedPlaceholder = placeholder;
            }
            this.lastCalledTimestamp = System.currentTimeMillis();
        }
    }
}

