/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import generic.jar.ResourceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;

public class ApplicationProperties
extends Properties {
    public static final String PROPERTY_FILE = "application.properties";
    public static final String APPLICATION_NAME_PROPERTY = "application.name";
    public static final String APPLICATION_VERSION_PROPERTY = "application.version";
    public static final String APPLICATION_LAYOUT_VERSION_PROPERTY = "application.layout.version";
    public static final String APPLICATION_GRADLE_VERSION_PROPERTY = "application.gradle.version";
    public static final String APPLICATION_JAVA_MIN_PROPERTY = "application.java.min";
    public static final String APPLICATION_JAVA_MAX_PROPERTY = "application.java.max";
    public static final String APPLICATION_JAVA_COMPILER_PROPERTY = "application.java.compiler";
    public static final String BUILD_DATE_PROPERTY = "application.build.date";
    public static final String BUILD_DATE_SHORT_PROPERTY = "application.build.date.short";
    public static final String RELEASE_NAME_PROPERTY = "application.release.name";
    public static final String RELEASE_MARKING_PROPERTY = "application.release.marking";
    public static final String REVISION_PROPERTY_PREFIX = "application.revision.";
    public static final String TEST_RELEASE_PROPERTY = "application.test.release";
    public static final String RELEASE_SOURCE_PROPERTY = "application.release.source";
    private static final String DEFAULT_APPLICATION_NAME = "NO_APP_NAME_DEFINED";
    private static final String DEFAULT_APPLICATION_VERSION = "0.1";

    public static ApplicationProperties fromFile(String filename) throws IOException {
        String workingDir = System.getProperty("user.dir");
        if (workingDir == null) {
            throw new FileNotFoundException("Cannot determing the current working directory");
        }
        File dir = new File(workingDir);
        if (!dir.exists()) {
            throw new FileNotFoundException("Current working directory does not exist: " + dir);
        }
        File propsFile = new File(dir, filename);
        if (!propsFile.exists()) {
            throw new FileNotFoundException("No '" + filename + "' file found in " + workingDir);
        }
        ResourceFile resourceFile = new ResourceFile(propsFile);
        ApplicationProperties properties = new ApplicationProperties(resourceFile);
        return properties;
    }

    public ApplicationProperties(String name) {
        this.setProperty(APPLICATION_NAME_PROPERTY, name);
    }

    public ApplicationProperties(String name, String version) {
        Objects.requireNonNull(name, "Application name cannot be null");
        this.setProperty(APPLICATION_NAME_PROPERTY, name);
        if (version != null) {
            this.setProperty(APPLICATION_VERSION_PROPERTY, version);
        }
    }

    public ApplicationProperties(ResourceFile appPropertiesFile) throws IOException {
        if (!appPropertiesFile.exists()) {
            throw new FileNotFoundException("application.properties file does not exist: " + appPropertiesFile);
        }
        try (InputStream in = appPropertiesFile.getInputStream();){
            this.load(in);
        }
    }

    public ApplicationProperties(Collection<ResourceFile> applicationRootDirs) throws IOException {
        boolean found = false;
        for (ResourceFile appRoot : applicationRootDirs) {
            ResourceFile appPropertiesFile = new ResourceFile(appRoot, PROPERTY_FILE);
            if (!appPropertiesFile.exists()) continue;
            InputStream in = appPropertiesFile.getInputStream();
            try {
                this.load(in);
                found = true;
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        if (!found) {
            throw new IOException("application.properties was not found!");
        }
    }

    @Override
    public String getProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        return super.getProperty(propertyName);
    }

    public String getApplicationName() {
        String appName = this.getProperty(APPLICATION_NAME_PROPERTY);
        if (appName == null) {
            return DEFAULT_APPLICATION_NAME;
        }
        return appName;
    }

    public String getApplicationVersion() {
        String appVersion = this.getProperty(APPLICATION_VERSION_PROPERTY);
        if (appVersion == null) {
            return DEFAULT_APPLICATION_VERSION;
        }
        return appVersion;
    }

    public String getApplicationBuildDate() {
        String appBuildDate = this.getProperty(BUILD_DATE_PROPERTY);
        if (appBuildDate == null) {
            appBuildDate = new SimpleDateFormat("yyyy-MMM-dd").format(new Date());
        }
        return appBuildDate;
    }
}

