/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterFormattedTextField;
import ghidra.feature.vt.gui.filters.IntegerFormatterFactory;
import ghidra.feature.vt.gui.filters.IntegerInputVerifier;
import ghidra.feature.vt.gui.filters.StatusLabel;
import ghidra.framework.options.SaveState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public class LengthFilter
extends Filter<VTMatch> {
    private static final Integer BASE_COMPONENT_LAYER = 1;
    private static final Integer HOVER_COMPONENT_LAYER = 2;
    private static final Integer DEFAULT_FILTER_VALUE = 0;
    private JComponent component = this.createComponent();
    private FilterFormattedTextField textField;

    private JComponent createComponent() {
        JLabel label = new JLabel("Length Filter: ");
        Integer defaultValue = DEFAULT_FILTER_VALUE;
        this.textField = new FilterFormattedTextField(new IntegerFormatterFactory(false), defaultValue);
        this.textField.setName("Length Filter Field");
        this.textField.setInputVerifier(new IntegerInputVerifier());
        this.textField.setHorizontalAlignment(4);
        this.textField.setColumns(5);
        final JPanel panel = new JPanel(new BorderLayout());
        Border paddingBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        Border outsideBorder = BorderFactory.createBevelBorder(1);
        panel.setBorder(BorderFactory.createCompoundBorder(outsideBorder, paddingBorder));
        panel.add((Component)label, "West");
        panel.add((Component)this.textField, "East");
        JLayeredPane layeredPane = new JLayeredPane();
        StatusLabel statusLabel = new StatusLabel(this.textField, defaultValue);
        this.textField.addFilterStatusListener(statusLabel);
        this.textField.addFilterStatusListener(status -> this.fireStatusChanged(status));
        layeredPane.add((Component)panel, BASE_COMPONENT_LAYER);
        layeredPane.add((Component)statusLabel, HOVER_COMPONENT_LAYER);
        layeredPane.setPreferredSize(panel.getPreferredSize());
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = panel.getPreferredSize();
                panel.setBounds(0, 0, preferredSize.width, preferredSize.height);
                panel.validate();
            }
        });
        return layeredPane;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void clearFilter() {
        this.textField.setText(DEFAULT_FILTER_VALUE.toString());
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        return this.textField.getFilterStatus();
    }

    @Override
    public boolean passesFilter(VTMatch t) {
        String text = this.textField.getText();
        if (text == null || "".equals(text.trim())) {
            return true;
        }
        Integer lengthFilter = Integer.valueOf(text);
        Integer score = t.getSourceLength();
        if (score.compareTo(lengthFilter) < 0) {
            return false;
        }
        score = t.getDestinationLength();
        return score.compareTo(lengthFilter = Integer.valueOf(this.textField.getText())) >= 0;
    }

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        String textFieldText = this.textField.getText();
        if (textFieldText.trim().isEmpty() || this.isDefaultValue(textFieldText)) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    private boolean isDefaultValue(String textFieldText) {
        return DEFAULT_FILTER_VALUE.equals(Integer.valueOf(textFieldText));
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        saveState.putString(this.getStateKey(), this.textField.getText());
    }

    private String getStateKey() {
        return this.getClass().getName();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        this.textField.setText(saveState.getString(this.getStateKey(), "0"));
    }

    private Integer toInteger() {
        String s = this.textField.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isSubFilterOf(Filter<VTMatch> otherFilter) {
        Integer otherValue;
        if (!(otherFilter instanceof LengthFilter)) {
            return false;
        }
        LengthFilter otherLengthFilter = (LengthFilter)otherFilter;
        Integer value = this.toInteger();
        if (Objects.equals(value, otherValue = otherLengthFilter.toInteger())) {
            return true;
        }
        if (value == null || otherValue == null) {
            return false;
        }
        int result = value.compareTo(otherValue);
        return result > 0;
    }
}

