/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.numberformat.BoundedRangeDecimalFormatterFactory;
import ghidra.feature.vt.gui.filters.BoundedRangeInputVerifier;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterFormattedTextField;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.feature.vt.gui.filters.StatusLabel;
import ghidra.feature.vt.gui.provider.matchtable.NumberRangeProducer;
import ghidra.feature.vt.gui.provider.matchtable.NumberRangeSubFilterChecker;
import ghidra.framework.options.SaveState;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDoubleRangeFilter<T>
extends Filter<T>
implements NumberRangeSubFilterChecker,
NumberRangeProducer {
    private static final Integer BASE_COMPONENT_LAYER = 1;
    private static final Integer HOVER_COMPONENT_LAYER = 2;
    private static final String FORMAT = "0.000";
    private final Double maxValue;
    private final Double minValue;
    private JComponent component;
    private FilterFormattedTextField upperBoundField;
    private FilterFormattedTextField lowerBoundField;
    private String filterName;

    AbstractDoubleRangeFilter(String filterName, Double minValue, Double maxValue) {
        this.filterName = filterName;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.component = this.createComponent();
    }

    private void createLowerBoundField() {
        this.lowerBoundField = new FilterFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new BoundedRangeDecimalFormatterFactory(this.maxValue, this.minValue, FORMAT), this.minValue);
        this.lowerBoundField.setName("Lower " + this.filterName + " Filter Field");
        this.lowerBoundField.setColumns(4);
        this.lowerBoundField.setMinimumSize(this.lowerBoundField.getPreferredSize());
        this.lowerBoundField.setHorizontalAlignment(4);
    }

    private void createUpperBoundField() {
        this.upperBoundField = new FilterFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new BoundedRangeDecimalFormatterFactory(this.maxValue, this.minValue, FORMAT), this.maxValue);
        this.upperBoundField.setName("Upper " + this.filterName + " Filter Field");
        this.upperBoundField.setColumns(4);
        this.upperBoundField.setMinimumSize(this.upperBoundField.getPreferredSize());
        this.upperBoundField.setHorizontalAlignment(4);
    }

    private JComponent createComponent() {
        this.createLowerBoundField();
        this.createUpperBoundField();
        this.lowerBoundField.setInputVerifier(new BoundedRangeInputVerifier(this.upperBoundField, true, this.maxValue, this.minValue));
        this.upperBoundField.setInputVerifier(new BoundedRangeInputVerifier(this.lowerBoundField, false, this.maxValue, this.minValue));
        final JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(4));
        Border paddingBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        Border outsideBorder = BorderFactory.createBevelBorder(1);
        panel.setBorder(BorderFactory.createCompoundBorder(outsideBorder, paddingBorder));
        JLabel filterLabel = new JLabel(this.filterName + " Filter: ");
        JLabel middleLabel = new JLabel("to");
        panel.add(filterLabel);
        panel.add(this.lowerBoundField);
        panel.add(middleLabel);
        panel.add(this.upperBoundField);
        FilterStatusListener notificationListener = status -> this.fireStatusChanged(status);
        StatusLabel lowerBoundStatusLabel = new StatusLabel(this.lowerBoundField, this.minValue);
        this.lowerBoundField.addFilterStatusListener(lowerBoundStatusLabel);
        this.lowerBoundField.addFilterStatusListener(notificationListener);
        StatusLabel upperBoundStatusLabel = new StatusLabel(this.upperBoundField, this.maxValue);
        this.upperBoundField.addFilterStatusListener(upperBoundStatusLabel);
        this.upperBoundField.addFilterStatusListener(notificationListener);
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)panel, BASE_COMPONENT_LAYER);
        layeredPane.add((Component)lowerBoundStatusLabel, HOVER_COMPONENT_LAYER);
        layeredPane.add((Component)upperBoundStatusLabel, HOVER_COMPONENT_LAYER);
        layeredPane.setPreferredSize(panel.getPreferredSize());
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = panel.getPreferredSize();
                panel.setBounds(0, 0, preferredSize.width, preferredSize.height);
                panel.validate();
            }
        });
        return layeredPane;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void clearFilter() {
        this.lowerBoundField.setText(this.minValue.toString());
        this.upperBoundField.setText(this.maxValue.toString());
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        Filter.FilterEditingStatus lowerStatus = this.lowerBoundField.getFilterStatus();
        Filter.FilterEditingStatus upperStatus = this.upperBoundField.getFilterStatus();
        if (lowerStatus == Filter.FilterEditingStatus.ERROR || upperStatus == Filter.FilterEditingStatus.ERROR) {
            return Filter.FilterEditingStatus.ERROR;
        }
        if (lowerStatus == Filter.FilterEditingStatus.APPLIED || upperStatus == Filter.FilterEditingStatus.APPLIED) {
            return Filter.FilterEditingStatus.APPLIED;
        }
        return Filter.FilterEditingStatus.NONE;
    }

    @Override
    public boolean passesFilter(T t) {
        if (this.lowerBoundField.getFilterStatus() == Filter.FilterEditingStatus.ERROR || this.upperBoundField.getFilterStatus() == Filter.FilterEditingStatus.ERROR) {
            return true;
        }
        String lowerBoundText = this.lowerBoundField.getText();
        if (lowerBoundText == null || "".equals(lowerBoundText.trim())) {
            return true;
        }
        String upperBoundText = this.upperBoundField.getText();
        if (upperBoundText == null || "".equals(upperBoundText)) {
            return true;
        }
        Double lowerBoundFilter = Double.valueOf(lowerBoundText);
        Double filterableValue = this.getFilterableValue(t);
        if (filterableValue.compareTo(lowerBoundFilter) < 0) {
            return false;
        }
        Double upperBoundFilter = Double.valueOf(upperBoundText);
        return filterableValue.compareTo(upperBoundFilter) <= 0;
    }

    protected abstract Double getFilterableValue(T var1);

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        if (this.isDefaultFilterState()) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    private boolean isDefaultFilterState() {
        String lowerText = this.lowerBoundField.getText();
        if (!this.minValue.equals(Double.valueOf(lowerText))) {
            return false;
        }
        String upperText = this.upperBoundField.getText();
        return this.maxValue.equals(Double.valueOf(upperText));
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        String stateKey = this.getStateKey();
        String[] values = new String[]{this.lowerBoundField.getText(), this.upperBoundField.getText()};
        saveState.putStrings(stateKey, values);
    }

    private String getStateKey() {
        return this.getClass().getName();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        String[] values = saveState.getStrings(this.getStateKey(), null);
        if (values == null) {
            return;
        }
        this.lowerBoundField.setText(values[0]);
        this.upperBoundField.setText(values[1]);
    }

    @Override
    public boolean isSubFilterOf(Filter<T> otherFilter) {
        if (!(otherFilter instanceof NumberRangeProducer)) {
            return false;
        }
        return this.isSubFilterOf(this, (NumberRangeProducer)((Object)otherFilter));
    }

    @Override
    public Number getUpperNumber() {
        return this.upperBoundToDouble();
    }

    @Override
    public Number getLowerNumber() {
        return this.lowerBoundToDouble();
    }

    private Double lowerBoundToDouble() {
        return this.toDouble(this.lowerBoundField.getText());
    }

    private Double upperBoundToDouble() {
        return this.toDouble(this.upperBoundField.getText());
    }

    private Double toDouble(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.lowerBoundField.getText() + " - " + this.upperBoundField.getText();
    }
}

