/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.tar;

import ghidra.file.formats.tar.TarFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryWithFile;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeWithFile;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class TarFileSystemFactory
implements GFileSystemFactoryWithFile<TarFileSystem>,
GFileSystemProbeBytesOnly,
GFileSystemProbeWithFile {
    public static final int TAR_MAGIC_BYTES_REQUIRED = 265;
    private static final String[] TAR_EXTS = new String[]{".tar", ".tgz", ".tar.gz", ".tbz2", ".tar.bz2"};

    public TarFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        if (TarFileSystemFactory.isCompressedTarFile(containerFile)) {
            UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, containerFile.length());
            FileCacheEntry fce = fsService.getDerivedFile(containerFSRL, "uncompressed tar", srcFile -> {
                Msg.info(TarFileSystem.class, (Object)("Uncompressing tar file " + containerFSRL));
                return TarFileSystemFactory.newFileInputStreamAutoDetectCompressed(srcFile);
            }, (TaskMonitor)upwtm);
            containerFile = fce.file;
        }
        TarFileSystem fs = new TarFileSystem(containerFile, targetFSRL, fsService);
        fs.mount(false, monitor);
        return fs;
    }

    public int getBytesRequired() {
        return 265;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return TarArchiveInputStream.matches((byte[])startBytes, (int)startBytes.length);
    }

    public boolean probe(FSRL containerFSRL, File containerFile, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        String filename = containerFSRL.getName();
        String ext = FSUtilities.getExtension((String)filename, (int)1);
        if (ext == null) {
            return false;
        }
        String string = ext = ".gz".equals(ext = ext.toLowerCase()) || ".bz2".equals(ext) ? FSUtilities.getExtension((String)filename, (int)2) : ext;
        if (!ArrayUtils.contains((Object[])TAR_EXTS, (Object)ext)) {
            return false;
        }
        try (InputStream is = TarFileSystemFactory.newFileInputStreamAutoDetectCompressed(containerFile);){
            byte[] startBytes = new byte[265];
            if (is.read(startBytes) != 265) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.probeStartBytes(null, startBytes);
            return bl;
        }
    }

    private static int readUShort(InputStream in) throws IOException {
        byte[] buf = new byte[2];
        if (in.read(buf) != 2) {
            throw new IOException("Not enough bytes to read short");
        }
        return (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    private static InputStream newFileInputStreamAutoDetectCompressed(File f) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(f));
        ((InputStream)is).mark(2);
        int magicbytes = TarFileSystemFactory.readUShort(is);
        ((InputStream)is).reset();
        switch (magicbytes) {
            case 35615: {
                is = new GZIPInputStream(is);
                break;
            }
            case 23106: {
                is = new BZip2CompressorInputStream((InputStream)is);
            }
        }
        return is;
    }

    private static boolean isCompressedStream(InputStream is) {
        return is instanceof GZIPInputStream || is instanceof BZip2CompressorInputStream;
    }

    private static boolean isCompressedTarFile(File f) throws IOException {
        try (InputStream is = TarFileSystemFactory.newFileInputStreamAutoDetectCompressed(f);){
            boolean bl = TarFileSystemFactory.isCompressedStream(is);
            return bl;
        }
    }
}

