/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge.routing;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.edge.routing.BasicEdgeRouter;
import ghidra.graph.viewer.renderer.DebugShape;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapUtils;

class ArticulatedEdgeRouter<V extends VisualVertex, E extends VisualEdge<V>>
extends BasicEdgeRouter<V, E> {
    private Shape spaceBetweenEndPointsShape;
    private Map<V, Rectangle> cachedVertexBoundsMap;
    private static final AtomicInteger debugCounter = new AtomicInteger(1);

    ArticulatedEdgeRouter(VisualizationServer<V, E> viewer, Collection<E> edges) {
        super(viewer, edges);
        this.viewer = viewer;
        this.edges = edges;
    }

    @Override
    public void route() {
        debugCounter.set(debugCounter.incrementAndGet());
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        for (VisualEdge edge : this.edges) {
            VisualVertex end;
            Pair endpoints;
            VisualVertex start;
            Shape edgeShape;
            if (!this.isOccluded(edge, edgeShape = GraphViewerUtils.getEdgeShapeInGraphSpace(this.viewer, edge))) {
                DebugShape debugShape = new DebugShape(this.viewer, debugCounter, "Default", GraphViewerUtils.getEdgeShapeInGraphSpace(this.viewer, edge), this.getPhantomEdgeColor(edge, true));
                this.viewer.addPostRenderPaintable(debugShape);
                List<Point2D> articulations = edge.getArticulationPoints();
                if (!articulations.isEmpty()) {
                    articulations = this.removeBadlyAngledArticulations(edge, articulations);
                    edge.setArticulationPoints(articulations);
                    continue;
                }
            }
            if ((start = (VisualVertex)(endpoints = graph.getEndpoints((Object)edge)).getFirst()) == (end = (VisualVertex)endpoints.getSecond())) continue;
            Point2D startPoint = (Point2D)layout.apply((Object)start);
            Point2D endPoint = (Point2D)layout.apply((Object)end);
            Rectangle boxBetweenVertices = this.createRectangle(startPoint, endPoint);
            Shape xBox = GraphViewerUtils.translateShapeFromLayoutSpaceToGraphSpace(boxBetweenVertices, this.viewer);
            this.spaceBetweenEndPointsShape = this.constrictToVerticesInsideShape(xBox, start, end);
            DebugShape debugShape = new DebugShape(this.viewer, debugCounter, "Restricted Box", GraphViewerUtils.translateShapeFromLayoutSpaceToGraphSpace(this.spaceBetweenEndPointsShape, this.viewer), this.getRoutingBoxColor(edge));
            this.viewer.addPostRenderPaintable(debugShape);
            Shape routedShape = this.createRoutedTwoPointShape(start, end, edge, true);
            debugShape = new DebugShape(this.viewer, debugCounter, "Left Edge", routedShape, this.getPhantomEdgeColor(edge, true));
            this.viewer.addPostRenderPaintable(debugShape);
            List<Point2D> articulations = this.getArticulations(routedShape);
            if (!this.isOccluded(edge, routedShape)) {
                articulations = this.removeBadlyAngledArticulations(edge, articulations);
                edge.setArticulationPoints(articulations);
                continue;
            }
            routedShape = this.createRoutedTwoPointShape(start, end, edge, false);
            debugShape = new DebugShape(this.viewer, debugCounter, "Right edge", routedShape, this.getPhantomEdgeColor(edge, false));
            this.viewer.addPostRenderPaintable(debugShape);
            articulations = this.getArticulations(routedShape);
            if (!this.isOccluded(edge, routedShape)) {
                articulations = this.removeBadlyAngledArticulations(edge, articulations);
                edge.setArticulationPoints(articulations);
                continue;
            }
            edge.setArticulationPoints(new ArrayList<Point2D>());
        }
    }

    private Shape constrictToVerticesInsideShape(Shape boundingShape, V start, V end) {
        HashSet<VisualVertex> vertices = new HashSet<VisualVertex>();
        Map<V, Rectangle> vertexBoundsMap = this.getVertexBounds();
        Set<Map.Entry<V, Rectangle>> entrySet = vertexBoundsMap.entrySet();
        for (Map.Entry<V, Rectangle> entry : entrySet) {
            VisualVertex v = (VisualVertex)entry.getKey();
            Rectangle vertexBounds = GraphViewerUtils.getVertexBoundsInGraphSpace(this.viewer, v);
            if (!boundingShape.intersects(vertexBounds)) continue;
            vertices.add(v);
        }
        vertices.remove(start);
        vertices.remove(end);
        if (vertices.isEmpty()) {
            boundingShape.getBounds().setSize(0, 0);
            return boundingShape;
        }
        return GraphViewerUtils.getBoundsForVerticesInLayoutSpace(this.viewer, vertices);
    }

    private Rectangle createRectangle(Point2D startPoint, Point2D endPoint) {
        double smallestX = Math.min(startPoint.getX(), endPoint.getX());
        double smallestY = Math.min(startPoint.getY(), endPoint.getY());
        double largestX = Math.max(startPoint.getX(), endPoint.getX());
        double largestY = Math.max(startPoint.getY(), endPoint.getY());
        int width = (int)(largestX - smallestX);
        int height = (int)(largestY - smallestY);
        return new Rectangle((int)smallestX, (int)smallestY, width, height);
    }

    private void moveArticulationsAroundVertices(Set<V> vertices, E edge, boolean goLeft) {
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        Pair endpoints = graph.getEndpoints(edge);
        VisualVertex start = (VisualVertex)endpoints.getFirst();
        VisualVertex end = (VisualVertex)endpoints.getSecond();
        Point2D startPoint = (Point2D)layout.apply((Object)start);
        Point2D endPoint = (Point2D)layout.apply((Object)end);
        Rectangle bounds = this.spaceBetweenEndPointsShape.getBounds();
        int padding = 20;
        int x = goLeft ? bounds.x : bounds.x + bounds.width;
        Point2D.Double top = new Point2D.Double(x += goLeft ? -padding : padding, bounds.y - padding);
        Point2D.Double bottom = new Point2D.Double(x, bounds.y + bounds.height + padding);
        if (startPoint.getY() > endPoint.getY()) {
            Point2D.Double newTop = bottom;
            bottom = top;
            top = newTop;
        }
        ArrayList<Point2D> articulationPoints = new ArrayList<Point2D>();
        articulationPoints.add(top);
        articulationPoints.add(bottom);
        edge.setArticulationPoints(articulationPoints);
    }

    private Shape createRoutedTwoPointShape(V start, V end, E edge, boolean goLeft) {
        HashSet<E> edgesSet = new HashSet<E>();
        edgesSet.add(edge);
        Map occludedEdges = this.getOccludedEdges(edgesSet);
        Set<V> intersectingVertices = occludedEdges.get(edge);
        if (intersectingVertices.isEmpty()) {
            return this.createLineEdge(start, end, edge);
        }
        Object newEdge = edge.cloneEdge((VisualVertex)((VisualVertex)edge.getStart()), (VisualVertex)((VisualVertex)edge.getEnd()));
        this.moveArticulationsAroundVertices(intersectingVertices, newEdge, goLeft);
        return GraphViewerUtils.getEdgeShapeInGraphSpace(this.viewer, newEdge);
    }

    private Map<E, Set<V>> getOccludedEdges(Collection<E> edgeCollection) {
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        HashSet prototype = new HashSet();
        Factory factory = FactoryUtils.prototypeFactory(prototype);
        IterableMap map = MapUtils.lazyMap(new HashMap(), (Factory)factory);
        Map<V, Rectangle> vertexBoundsMap = this.getVertexBounds();
        Set<Map.Entry<V, Rectangle>> entrySet = vertexBoundsMap.entrySet();
        for (Map.Entry<V, Rectangle> entry : entrySet) {
            VisualVertex v = (VisualVertex)entry.getKey();
            Rectangle vertexBounds = GraphViewerUtils.getVertexBoundsInGraphSpace(this.viewer, v);
            for (VisualEdge edge : edgeCollection) {
                Shape edgeShape = GraphViewerUtils.getEdgeShapeInGraphSpace(this.viewer, edge);
                Pair endpoints = graph.getEndpoints((Object)edge);
                if (v == endpoints.getFirst() || v == endpoints.getSecond() || !edgeShape.intersects(vertexBounds)) continue;
                Set set = (Set)map.get(edge);
                set.add(v);
            }
        }
        return map;
    }

    private Map<V, Rectangle> getVertexBounds() {
        if (this.cachedVertexBoundsMap != null) {
            return this.cachedVertexBoundsMap;
        }
        Layout layout = this.viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        Collection vertices = graph.getVertices();
        HashMap<Rectangle, Rectangle> map = new HashMap<Rectangle, Rectangle>();
        for (VisualVertex v : vertices) {
            Rectangle vertexBounds = GraphViewerUtils.getVertexBoundsInGraphSpace(this.viewer, v);
            map.put((Rectangle)((Object)v), vertexBounds);
        }
        this.cachedVertexBoundsMap = map;
        return map;
    }

    private List<Point2D> getArticulations(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        ArrayList<Point2D> articulations = new ArrayList<Point2D>();
        double[] coords = new double[6];
        pathIterator.next();
        pathIterator.currentSegment(coords);
        Point2D.Double pathPoint = new Point2D.Double(coords[0], coords[1]);
        Point layoutSpacePoint = GraphViewerUtils.translatePointFromGraphSpaceToLayoutSpace(pathPoint, this.viewer);
        articulations.add(layoutSpacePoint);
        pathIterator.next();
        pathIterator.currentSegment(coords);
        pathPoint = new Point2D.Double(coords[0], coords[1]);
        layoutSpacePoint = GraphViewerUtils.translatePointFromGraphSpaceToLayoutSpace(pathPoint, this.viewer);
        articulations.add(layoutSpacePoint);
        return articulations;
    }

    private Shape createLineEdge(V start, V end, E edge) {
        edge.setArticulationPoints(new ArrayList<Point2D>());
        return GraphViewerUtils.getEdgeShapeInGraphSpace(this.viewer, edge);
    }

    private Color getRoutingBoxColor(E edge) {
        if (this.isTrueEdge(edge)) {
            return Color.MAGENTA;
        }
        return Color.ORANGE;
    }

    private Color getPhantomEdgeColor(E edge, boolean isLeft) {
        if (isLeft) {
            if (this.isTrueEdge(edge)) {
                return new Color(0x999900);
            }
            return new Color(39168);
        }
        if (this.isTrueEdge(edge)) {
            return new Color(0x3300CC);
        }
        return new Color(0x3399FF);
    }

    private boolean isTrueEdge(E edge) {
        return true;
    }
}

