/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.jung.renderer.DecompilerDominanceArticulatedEdgeTransformer;
import ghidra.app.plugin.core.functiongraph.graph.layout.AbstractFGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.CodeFlowEdgeLabelRenderer;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.LayoutLocationMap;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.BlockCopy;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class DecompilerNestedLayout
extends AbstractFGLayout {
    private static final int VERTEX_TO_EDGE_ARTICULATION_OFFSET = 20;
    private DecompilerBlockGraph blockGraphRoot;

    public DecompilerNestedLayout(FunctionGraph graph) {
        this(graph, true);
    }

    private DecompilerNestedLayout(FunctionGraph graph, boolean initialize) {
        super(graph);
        if (initialize) {
            this.initialize();
        }
    }

    public Function<FGEdge, Shape> getEdgeShapeTransformer() {
        return new DecompilerDominanceArticulatedEdgeTransformer();
    }

    public Renderer.EdgeLabel<FGVertex, FGEdge> getEdgeLabelRenderer() {
        return new CodeFlowEdgeLabelRenderer<FGVertex, FGEdge>();
    }

    protected double getCondenseFactor() {
        return 0.3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridLocationMap<FGVertex, FGEdge> performInitialGridLayout(VisualGraph<FGVertex, FGEdge> jungGraph) throws CancelledException {
        BlockGraph outgraph = null;
        DecompileOptions decompilerOptions = new DecompileOptions();
        DecompInterface ifc = new DecompInterface();
        try {
            ifc.setOptions(decompilerOptions);
            FGVertex aVertex = (FGVertex)jungGraph.getVertices().iterator().next();
            Program program = aVertex.getProgram();
            if (!ifc.openProgram(program)) {
                throw new RuntimeException("Unable to initialize: " + ifc.getLastMessage());
            }
            BlockGraph ingraph = this.buildCurrentFunctionGraph(program, jungGraph, this.monitor);
            if (ingraph == null) {
                throw new RuntimeException("Unable to initialize: " + ifc.getLastMessage());
            }
            outgraph = ifc.structureGraph(ingraph, program.getAddressFactory(), 0, this.monitor);
        }
        finally {
            ifc.dispose();
        }
        if (outgraph == null) {
            throw new RuntimeException("No results from the Decompiler: " + ifc.getLastMessage());
        }
        if (outgraph.getSize() == 0) {
            throw new RuntimeException("No results from the Decompiler: " + ifc.getLastMessage());
        }
        this.blockGraphRoot = new DecompilerBlockGraph(null, outgraph);
        this.printGraphStrucure(outgraph);
        this.debug("\n\n");
        this.printParts(0, outgraph);
        this.debug("\n\n");
        this.printConvertedStructure(0, this.blockGraphRoot);
        GridLocationMap<FGVertex, FGEdge> gridLocations = this.assignCoordinates(jungGraph, this.blockGraphRoot);
        this.labelEdges(jungGraph, gridLocations, this.blockGraphRoot);
        Address entryPoint = this.function.getEntryPoint();
        FGVertex vertex = this.getVertex(jungGraph, entryPoint);
        Integer row = gridLocations.row((Object)vertex);
        Integer col = gridLocations.col((Object)vertex);
        if (row != 0 || col != 0) {
            Msg.debug((Object)((Object)this), (Object)("Function graph has entry point not at top of layout: " + entryPoint));
        }
        return gridLocations;
    }

    private void labelEdges(VisualGraph<FGVertex, FGEdge> jungGraph, GridLocationMap<FGVertex, FGEdge> gridLocations, DecompilerBlockGraph root) {
        Collection edges = jungGraph.getEdges();
        for (FGEdge e : edges) {
            boolean hasBranching;
            FGVertex start = (FGVertex)e.getStart();
            FGVertex end = (FGVertex)e.getEnd();
            Address startAddress = start.getVertexAddress();
            Address endAddress = end.getVertexAddress();
            int result = startAddress.compareTo((Object)endAddress);
            DecompilerBlock endBlock = this.blockGraphRoot.getBlock(end);
            DecompilerBlock loop = endBlock.getParentLoop();
            if (result > 0 && loop != null) {
                DecompilerBlock startBlock = root.getBlock(start);
                startBlock = startBlock.parent;
                e.setLabel(startBlock.getName());
                continue;
            }
            Integer startCol = gridLocations.col((Object)start);
            Integer endCol = gridLocations.col((Object)end);
            boolean isFallthrough = startCol >= endCol;
            Collection outEdges = jungGraph.getOutEdges((Object)start);
            boolean bl = hasBranching = outEdges.size() > 1;
            if (isFallthrough && hasBranching) continue;
            DecompilerBlock startBlock = root.getBlock(start);
            startBlock = startBlock.parent;
            e.setLabel(startBlock.getName());
        }
    }

    protected Map<FGEdge, List<Point2D>> positionEdgeArticulationsInLayoutSpace(VisualGraphVertexShapeTransformer<FGVertex> transformer, Map<FGVertex, Point2D> vertexLayoutLocations, Collection<FGEdge> edges, LayoutLocationMap<FGVertex, FGEdge> layoutLocations) throws CancelledException {
        HashMap<FGEdge, List<Point2D>> newEdgeArticulations = new HashMap<FGEdge, List<Point2D>>();
        for (FGEdge e : edges) {
            double y3;
            double x3;
            double y2;
            double x2;
            double y1;
            double x1;
            double vertexBottom;
            Rectangle bounds;
            Shape shape;
            int offsetFromVertex;
            this.monitor.checkCanceled();
            FGVertex startVertex = (FGVertex)e.getStart();
            FGVertex endVertex = (FGVertex)e.getEnd();
            Address startAddress = startVertex.getVertexAddress();
            Address endAddress = endVertex.getVertexAddress();
            int result = startAddress.compareTo((Object)endAddress);
            DecompilerBlock block = this.blockGraphRoot.getBlock(endVertex);
            DecompilerBlock loop = block.getParentLoop();
            if (result > 0 && loop != null) {
                this.routeLoopEdge(vertexLayoutLocations, layoutLocations, newEdgeArticulations, e, startVertex, endVertex);
                continue;
            }
            Column startCol = layoutLocations.col((Object)startVertex);
            Column endCol = layoutLocations.col((Object)endVertex);
            Point2D start = vertexLayoutLocations.get(startVertex);
            Point2D end = vertexLayoutLocations.get(endVertex);
            ArrayList<Point2D.Double> articulations = new ArrayList<Point2D.Double>();
            int direction = 20;
            if (startCol.index >= endCol.index && startCol.index > endCol.index) {
                direction = -direction;
            }
            int n = offsetFromVertex = this.isCondensedLayout() ? (int)(20.0 * (1.0 - this.getCondenseFactor())) : 20;
            if (startCol.index < endCol.index) {
                shape = transformer.apply((VisualVertex)startVertex);
                bounds = shape.getBounds();
                vertexBottom = start.getY() + (double)(bounds.height >> 1);
                x1 = start.getX() + (double)direction;
                y1 = start.getY();
                articulations.add(new Point2D.Double(x1, y1));
                x2 = x1;
                y2 = vertexBottom + (double)offsetFromVertex;
                y2 = end.getY();
                articulations.add(new Point2D.Double(x2, y2));
                x3 = end.getX() + (double)(-direction);
                y3 = y2;
                articulations.add(new Point2D.Double(x3, y3));
            } else if (startCol.index > endCol.index) {
                e.setAlpha(0.25);
                shape = transformer.apply((VisualVertex)startVertex);
                bounds = shape.getBounds();
                vertexBottom = start.getY() + (double)(bounds.height >> 1);
                x1 = start.getX() + (double)direction;
                y1 = start.getY();
                articulations.add(new Point2D.Double(x1, y1));
                x2 = x1;
                y2 = vertexBottom + (double)offsetFromVertex;
                articulations.add(new Point2D.Double(x2, y2));
                x3 = end.getX() + (double)(-direction);
                y3 = y2;
                articulations.add(new Point2D.Double(x3, y3));
                double x4 = x3;
                double y4 = end.getY();
                articulations.add(new Point2D.Double(x4, y4));
            } else {
                e.setAlpha(0.25);
            }
            newEdgeArticulations.put(e, articulations);
        }
        return newEdgeArticulations;
    }

    private void routeLoopEdge(Map<FGVertex, Point2D> vertexLayoutLocations, LayoutLocationMap<FGVertex, FGEdge> layoutLocations, Map<FGEdge, List<Point2D>> newEdgeArticulations, FGEdge e, FGVertex startVertex, FGVertex endVertex) {
        ArrayList<Point2D.Double> articulations = new ArrayList<Point2D.Double>();
        DecompilerBlock block = this.blockGraphRoot.getBlock(endVertex);
        DecompilerBlock loop = block.getParentLoop();
        Set<FGVertex> vertices = loop.getVertices();
        Column outermostCol = this.getOutermostCol(layoutLocations, vertices);
        Column afterColumn = layoutLocations.nextColumn(outermostCol);
        int halfWidth = afterColumn.getPaddedWidth(this.isCondensedLayout()) >> 1;
        double x = afterColumn.x + halfWidth;
        Point2D startVertexPoint = vertexLayoutLocations.get(startVertex);
        double y1 = startVertexPoint.getY();
        Point2D.Double first = new Point2D.Double(x, y1);
        articulations.add(first);
        Point2D endVertexPoint = vertexLayoutLocations.get(endVertex);
        double y2 = endVertexPoint.getY();
        Point2D.Double second = new Point2D.Double(x, y2);
        articulations.add(second);
        newEdgeArticulations.put(e, articulations);
    }

    private Column getOutermostCol(LayoutLocationMap<FGVertex, FGEdge> layoutLocations, Set<FGVertex> vertices) {
        Column outermost = null;
        for (FGVertex v : vertices) {
            Column col = layoutLocations.col((Object)v);
            if (outermost == null) {
                outermost = col;
                continue;
            }
            if (col.x <= outermost.x) continue;
            outermost = col;
        }
        return outermost;
    }

    public boolean usesEdgeArticulations() {
        return true;
    }

    protected Point2D getVertexLocation(FGVertex v, Column col, Row<FGVertex> row, Rectangle bounds) {
        return this.getCenteredVertexLocation((VisualVertex)v, col, row, bounds);
    }

    private void debug(String text) {
    }

    private void printParts(int depth, BlockGraph block) {
        PcodeBlock child;
        int i;
        int blockSize = block.getSize();
        this.debug(this.printDepth(0, depth) + PcodeBlock.typeToName((int)block.getType()) + "  - (" + block.getStart() + "->" + block.getStop() + ") ");
        for (i = 0; i < blockSize; ++i) {
            child = block.getBlock(i);
            StringBuilder buffy = new StringBuilder();
            buffy.append(this.printDepth(1, depth + 1)).append(' ').append(child);
            this.debug(buffy.toString());
        }
        for (i = 0; i < blockSize; ++i) {
            child = block.getBlock(i);
            if (!(child instanceof BlockGraph)) continue;
            this.printParts(depth + 1, (BlockGraph)child);
        }
    }

    private void printConvertedStructure(int depth, DecompilerBlockGraph blockGraph) {
        String depthString = this.printDepth(depth, depth);
        String blockName = blockGraph.getName();
        if (blockName != null) {
            this.debug(depthString + blockName);
            String childrenString = blockGraph.getChildrenString(depth + 1);
            if (!childrenString.isEmpty()) {
                this.debug(childrenString);
            }
        }
        List<DecompilerBlock> list = blockGraph.allChildren;
        for (DecompilerBlock block : list) {
            if (block instanceof DecompilerBlockGraph) {
                this.printConvertedStructure(depth + 1, (DecompilerBlockGraph)block);
                continue;
            }
            this.debug(depthString + "::" + block.getName());
        }
    }

    private void printGraphStrucure(BlockGraph blockGraph) {
        this.printBlock(new AtomicInteger(0), 0, blockGraph);
    }

    private void printBlock(AtomicInteger parentID, int depth, BlockGraph block) {
        this.debug(parentID + " " + this.printDepth(depth, depth) + (parentID.get() - 1) + " " + PcodeBlock.typeToName((int)block.getType()) + "  - (" + block.getStart() + "->" + block.getStop() + ") ");
        int blockSize = block.getSize();
        int ID = parentID.getAndIncrement();
        for (int i = 0; i < blockSize; ++i) {
            PcodeBlock child = block.getBlock(i);
            if (child instanceof BlockGraph) {
                this.printBlock(parentID, depth + 1, (BlockGraph)child);
                continue;
            }
            BlockCopy copy = (BlockCopy)child;
            StringBuilder buffy = new StringBuilder();
            buffy.append(this.printDepth(depth, depth + 1)).append(' ').append(ID).append(" plain - ").append(copy.getRef());
            this.debug(buffy.toString());
        }
    }

    private String printDepth(int level, int depth) {
        if (depth == 0) {
            return "";
        }
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < depth * 2; ++i) {
            buffy.append(' ');
        }
        buffy.append(' ');
        return buffy.toString();
    }

    private GridLocationMap<FGVertex, FGEdge> assignCoordinates(VisualGraph<FGVertex, FGEdge> jungGraph, DecompilerBlockGraph root) {
        GridLocationMap gridLocations = new GridLocationMap();
        root.setCol(0);
        this.debug("\n\n");
        root.setRows(0);
        Collection vertices = jungGraph.getVertices();
        for (FGVertex vertex : vertices) {
            DecompilerBlock block = root.getBlock(vertex);
            int col = block.getCol();
            int row = block.getRow();
            gridLocations.set((Object)vertex, row, col);
        }
        return gridLocations;
    }

    private FGVertex getVertex(VisualGraph<FGVertex, FGEdge> jungGraph, Address address) {
        Collection vertices = jungGraph.getVertices();
        for (FGVertex v : vertices) {
            if (!v.containsAddress(address)) continue;
            return v;
        }
        Msg.debug((Object)((Object)this), (Object)("Unable to find vertex for address; has the program changed?: " + address));
        return null;
    }

    private BlockGraph buildCurrentFunctionGraph(Program program, VisualGraph<FGVertex, FGEdge> jungGraph, TaskMonitor taskMonitor) throws CancelledException {
        BasicBlockModel blockModel = new BasicBlockModel(program);
        AddressSetView addresses = this.function.getBody();
        CodeBlockIterator iterator = blockModel.getCodeBlocksContaining(addresses, taskMonitor);
        BlockGraph blockGraph = new BlockGraph();
        DualHashBidiMap bidiMap = new DualHashBidiMap();
        while (iterator.hasNext()) {
            taskMonitor.checkCanceled();
            CodeBlock codeBlock = iterator.next();
            FGVertex vertex = this.getVertex(jungGraph, codeBlock.getMinAddress());
            if (vertex == null) continue;
            BlockCopy pcodeBlock = new BlockCopy((Object)vertex, codeBlock.getMinAddress());
            bidiMap.put((Object)codeBlock, (Object)pcodeBlock);
            blockGraph.addBlock((PcodeBlock)pcodeBlock);
        }
        for (CodeBlock block : bidiMap.keySet()) {
            taskMonitor.checkCanceled();
            CodeBlockReferenceIterator destinations = block.getDestinations(taskMonitor);
            while (destinations.hasNext()) {
                taskMonitor.checkCanceled();
                CodeBlockReference ref = destinations.next();
                if (ref.getFlowType().isCall()) continue;
                CodeBlock destination = ref.getDestinationBlock();
                PcodeBlock sourcePcodeBlock = (PcodeBlock)bidiMap.get((Object)block);
                PcodeBlock destPcodeBlock = (PcodeBlock)bidiMap.get((Object)destination);
                if (destPcodeBlock == null) continue;
                blockGraph.addEdge(sourcePcodeBlock, destPcodeBlock);
            }
        }
        blockGraph.setIndices();
        return blockGraph;
    }

    protected AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedFGLayout(FunctionGraph newGraph) {
        return new DecompilerNestedLayout(newGraph, false);
    }

    private DecompilerBlockGraph getDecompilerBlock(DecompilerBlockGraph parent, BlockGraph block) {
        switch (block.getType()) {
            case 0: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 1: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 2: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 3: {
                return new PlainBlock(parent, block);
            }
            case 4: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 5: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 6: {
                return new ListBlock(parent, block);
            }
            case 7: {
                return new ConditionBlock(parent, block);
            }
            case 8: {
                return new IfBlock(parent, block);
            }
            case 9: {
                return new IfElseBlock(parent, block);
            }
            case 10: {
                return new IfBlock(parent, block);
            }
            case 11: {
                return new WhileLoopBlock(parent, block);
            }
            case 12: {
                return new DoLoopBlock(parent, block);
            }
            case 13: {
                return new SwitchBlock(parent, block);
            }
            case 14: {
                return new DecompilerBlockGraph(parent, block);
            }
        }
        throw new AssertException("Unhandled Decompiler Type: " + PcodeBlock.typeToName((int)block.getType()));
    }

    private class SwitchBlock
    extends DecompilerBlockGraph {
        SwitchBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "Switch";
        }
    }

    private class IfElseBlock
    extends DecompilerBlockGraph {
        IfElseBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "If / Else";
        }
    }

    private class IfBlock
    extends DecompilerBlockGraph {
        IfBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "If";
        }
    }

    private class DoLoopBlock
    extends DecompilerLoop {
        DoLoopBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        void setCol(int col) {
            int column = col + 1;
            for (int i = 0; i < this.allChildren.size(); ++i) {
                DecompilerBlock block = (DecompilerBlock)this.allChildren.get(i);
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return "Do Loop";
        }
    }

    private class WhileLoopBlock
    extends DecompilerLoop {
        WhileLoopBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "While Loop";
        }
    }

    private class ConditionBlock
    extends DecompilerBlockGraph {
        ConditionBlock(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        void setCol(int col) {
            int column = col;
            for (int i = 0; i < this.allChildren.size(); ++i) {
                DecompilerBlock block = (DecompilerBlock)this.allChildren.get(i);
                block.setCol(column);
                ++column;
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return "Condition";
        }
    }

    private class ListBlock
    extends DecompilerBlockGraph {
        ListBlock(DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        void setCol(int col) {
            for (int i = 0; i < this.allChildren.size(); ++i) {
                int column = col;
                DecompilerBlock block = (DecompilerBlock)this.allChildren.get(i);
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return this.parent.getName();
        }
    }

    private class PlainBlock
    extends DecompilerBlockGraph {
        PlainBlock(DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        String getName() {
            return "Plain";
        }
    }

    private abstract class DecompilerLoop
    extends DecompilerBlockGraph {
        DecompilerLoop(DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        DecompilerBlock getParentLoop() {
            return this;
        }
    }

    private class DecompilerCopy
    extends DecompilerBlock {
        private BlockCopy copy;
        private Set<FGVertex> vertexSet;

        DecompilerCopy(DecompilerBlockGraph parent, BlockCopy copy) {
            super(parent, (PcodeBlock)copy);
            this.vertexSet = new HashSet<FGVertex>();
            this.copy = copy;
            this.vertexSet.add((FGVertex)copy.getRef());
            this.vertexSet = Collections.unmodifiableSet(this.vertexSet);
        }

        FGVertex getVertex() {
            return (FGVertex)this.copy.getRef();
        }

        @Override
        DecompilerBlock getBlock(FGVertex vertex) {
            if (vertex instanceof GroupedFunctionGraphVertex) {
                Set vertices = ((GroupedFunctionGraphVertex)vertex).getVertices();
                for (FGVertex collapsedVertex : vertices) {
                    DecompilerBlock block = this.getBlock(collapsedVertex);
                    if (block == null) continue;
                    return block;
                }
            }
            FGVertex myVertex = this.getVertex();
            DecompilerBlock block = this.compareToMyVertex(myVertex, vertex);
            return block;
        }

        private DecompilerBlock compareToMyVertex(FGVertex myVertex, FGVertex vertex) {
            if (myVertex instanceof GroupedFunctionGraphVertex) {
                Set vertices = ((GroupedFunctionGraphVertex)myVertex).getVertices();
                for (FGVertex myCollapsedVertex : vertices) {
                    DecompilerBlock block = this.compareToMyVertex(myCollapsedVertex, vertex);
                    if (block == null) continue;
                    return block;
                }
            }
            if (myVertex.equals(vertex)) {
                return this;
            }
            return null;
        }

        @Override
        DecompilerBlock getParentLoop() {
            return this.parent.getParentLoop();
        }

        @Override
        Set<FGVertex> getVertices() {
            return this.vertexSet;
        }

        @Override
        String getName() {
            return "Copy";
        }

        @Override
        String getChildrenString(int depth) {
            return null;
        }
    }

    private abstract class DecompilerBlock {
        protected DecompilerBlock parent;
        protected PcodeBlock pcodeBlock;
        private int row;
        private int col;

        DecompilerBlock(DecompilerBlock parent, PcodeBlock pcodeBlock) {
            this.parent = parent;
            this.pcodeBlock = pcodeBlock;
        }

        void setRow(int row) {
            this.row = row;
        }

        void setCol(int col) {
            this.col = col;
        }

        int getRow() {
            return this.row;
        }

        int getCol() {
            return this.col;
        }

        abstract DecompilerBlock getBlock(FGVertex var1);

        abstract Set<FGVertex> getVertices();

        abstract DecompilerBlock getParentLoop();

        abstract String getName();

        abstract String getChildrenString(int var1);

        public String toString() {
            return PcodeBlock.typeToName((int)this.pcodeBlock.getType()) + " - " + this.pcodeBlock.getStart();
        }
    }

    private class DecompilerBlockGraph
    extends DecompilerBlock {
        protected List<DecompilerBlock> allChildren;

        DecompilerBlockGraph(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, (PcodeBlock)blockGraph);
            this.allChildren = new ArrayList<DecompilerBlock>();
            int childCount = blockGraph.getSize();
            for (int i = 0; i < childCount; ++i) {
                PcodeBlock block = blockGraph.getBlock(i);
                if (block instanceof BlockGraph) {
                    DecompilerBlockGraph decompilerBlock = DecompilerNestedLayout.this.getDecompilerBlock(this, (BlockGraph)block);
                    this.allChildren.add(decompilerBlock);
                }
                if (!(block instanceof BlockCopy)) continue;
                DecompilerCopy decompilerCopy = new DecompilerCopy(this, (BlockCopy)block);
                this.allChildren.add(decompilerCopy);
            }
        }

        @Override
        DecompilerBlock getBlock(FGVertex vertex) {
            for (DecompilerBlock child : this.allChildren) {
                DecompilerBlock block = child.getBlock(vertex);
                if (block == null) continue;
                return block;
            }
            return null;
        }

        @Override
        DecompilerBlock getParentLoop() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getParentLoop();
        }

        @Override
        Set<FGVertex> getVertices() {
            HashSet<FGVertex> set = new HashSet<FGVertex>();
            for (DecompilerBlock child : this.allChildren) {
                set.addAll(child.getVertices());
            }
            return set;
        }

        @Override
        void setCol(int col) {
            for (int i = 0; i < this.allChildren.size(); ++i) {
                int column = i == 0 ? col : col + 1;
                DecompilerBlock block = this.allChildren.get(i);
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        protected void doSetCol(int col) {
            super.setCol(col);
        }

        int setRows(int startRow) {
            int row = startRow;
            for (int i = 0; i < this.allChildren.size(); ++i) {
                DecompilerBlock block = this.allChildren.get(i);
                if (block instanceof DecompilerBlockGraph) {
                    row = ((DecompilerBlockGraph)block).setRows(row);
                    continue;
                }
                block.setRow(row++);
            }
            return row;
        }

        @Override
        String getName() {
            return null;
        }

        @Override
        String getChildrenString(int depth) {
            StringBuilder buffy = new StringBuilder();
            int childCount = 0;
            for (int i = 0; i < this.allChildren.size(); ++i) {
                String blockName;
                DecompilerBlock block = this.allChildren.get(i);
                if (!(block instanceof DecompilerBlockGraph) || (blockName = block.getName()) == null) continue;
                if (++childCount > 1) {
                    buffy.append('\n');
                }
                buffy.append(DecompilerNestedLayout.this.printDepth(depth, depth));
                buffy.append(' ');
                buffy.append(blockName);
            }
            return buffy.toString();
        }
    }
}

