/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.condition;

import io.netty.util.internal.logging.InternalLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ScriptFactory;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class Condition {
    Script _script;
    YajswConfigurationImpl _config;
    WrappedProcess _wp;
    boolean _hasTrigger = false;
    boolean _triggered = false;
    long _period = -1L;
    static Timer _timer = new Timer("yajsw.condition");
    InternalLogger _log;
    int _debug = 3;

    public Condition(YajswConfigurationImpl config, WrappedProcess wrappedProcess, InternalLogger log) {
        this._config = config;
        this._wp = wrappedProcess;
        this._log = log;
    }

    public void init() {
        String fileName = this._config.getString("wrapper.condition.script");
        if (fileName == null) {
            return;
        }
        File f = new File(fileName);
        if (!f.exists() || !f.isFile()) {
            try {
                System.out.println("file not found -> ignoring condition script " + f.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int debugLevel = this._config.getInt("wrapper.debug.level", 3);
        String dbg = this._config.getString("wrapper.debug", null);
        this._debug = dbg != null && "true".equals(dbg) ? debugLevel : 0;
        List args = this._config.getList("wrapper.condition.script.args", new ArrayList());
        String[] argsArr = new String[args.size()];
        for (int i = 0; i < argsArr.length; ++i) {
            argsArr[i] = args.get(i).toString();
        }
        this._script = ScriptFactory.createScript(fileName, "condition", this._wp, argsArr, this._log, 0, this._config.getString("wrapper.script.encoding"), this._config.getBoolean("wrapper.script.reload", false), this._debug, 1);
        this._hasTrigger = this._script != null;
        this._period = this._config.getLong("wrapper.condition.cycle", -1L) * 1000L;
    }

    public void stop() {
        _timer.cancel();
        this._triggered = false;
    }

    public boolean isHasTrigger() {
        return this._hasTrigger;
    }

    public boolean isTriggered() {
        return this._triggered;
    }

    public void start() {
        this._triggered = true;
        if (this._period > 0L) {
            _timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Condition.this._script.execute();
                }
            }, new Date(), this._period);
        } else {
            _timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Condition.this._script.execute();
                }
            }, new Date());
        }
    }
}

