/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.plugin;

import docking.DialogComponentProvider;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.script.SelectLanguageDialog;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FidFile;
import ghidra.feature.fid.db.FidFileManager;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.plugin.IngestTask;
import ghidra.feature.fid.service.DefaultFidPopulateResultReporter;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PopulateFidDialog
extends DialogComponentProvider {
    private JTextField libraryFamilyNameTextField;
    private JTextField versionTextField;
    private PluginTool tool;
    private JTextField domainFolderField;
    private JComboBox<FidFile> fidFileComboBox;
    private JComboBox<LibraryChoice> libraryComboBox;
    private JTextField variantTextField;
    private FidService fidService;
    private JTextField languageIdField;
    private JTextField symbolsFileTextField;

    protected PopulateFidDialog(PluginTool tool, FidService fidService) {
        super("Populate Fid Database");
        this.tool = tool;
        this.fidService = fidService;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.updateOkEnablement();
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("FunctionID", "populatedialog"));
    }

    protected void okCallback() {
        FidFile fidFile = (FidFile)this.fidFileComboBox.getSelectedItem();
        LibraryChoice libraryChoice = (LibraryChoice)this.libraryComboBox.getSelectedItem();
        LibraryRecord libraryRecord = libraryChoice.getLibraryRecord();
        String libraryFamilyName = this.libraryFamilyNameTextField.getText().trim();
        String libraryVersion = this.versionTextField.getText().trim();
        String libraryVariant = this.variantTextField.getText().trim();
        DomainFolder folder = this.getDomainFolder();
        String languageFilter = this.languageIdField.getText().trim();
        File commonSymbolsFile = this.getCommonSymbolsFile();
        IngestTask task = new IngestTask("Populate Library Task", fidFile, libraryRecord, folder, libraryFamilyName, libraryVersion, libraryVariant, languageFilter, commonSymbolsFile, this.fidService, new DefaultFidPopulateResultReporter());
        this.close();
        this.tool.execute((Task)task);
    }

    private File getCommonSymbolsFile() {
        String symbolsFilePath = this.symbolsFileTextField.getText().trim();
        if (symbolsFilePath.isEmpty()) {
            return null;
        }
        return new File(symbolsFilePath);
    }

    private DomainFolder getDomainFolder() {
        Project project = AppInfo.getActiveProject();
        ProjectData pd = project.getProjectData();
        return pd.getFolder(this.domainFolderField.getText().trim());
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel("Fid Database: ", 4);
        jLabel.setToolTipText("Choose the Fid Database to populate");
        panel.add(jLabel);
        panel.add(this.buildFidCombo());
        panel.add(new JLabel("Library Family Name: ", 4));
        this.libraryFamilyNameTextField = new JTextField(20);
        this.libraryFamilyNameTextField.getDocument().addUndoableEditListener(e -> this.updateOkEnablement());
        panel.add(this.libraryFamilyNameTextField);
        panel.add(new JLabel("Library Version: ", 4));
        this.versionTextField = new JTextField();
        this.versionTextField.getDocument().addUndoableEditListener(e -> this.updateOkEnablement());
        panel.add(this.versionTextField);
        panel.add(new JLabel("Library Variant: ", 4));
        this.variantTextField = new JTextField();
        this.variantTextField.getDocument().addUndoableEditListener(e -> this.updateOkEnablement());
        panel.add(this.variantTextField);
        panel.add(new JLabel("Base Library: ", 4));
        panel.add(this.buildLibraryCombo());
        panel.add(new JLabel("Root Folder: ", 4));
        panel.add(this.buildDomainFolderChooserField());
        panel.add(new JLabel("Language: ", 4));
        panel.add(this.buildLanguageField());
        panel.add(new JLabel("Common Symbols File: ", 4));
        panel.add((Component)this.buildSymbolsFileField(), (Object)jLabel);
        return panel;
    }

    private JComponent buildSymbolsFileField() {
        JPanel panel = new JPanel(new BorderLayout());
        this.symbolsFileTextField = new JTextField();
        panel.add((Component)this.symbolsFileTextField, "Center");
        JButton browseButton = this.createBrowseButton();
        browseButton.addActionListener(e -> {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getToolFrame());
            chooser.setTitle("Choose Common Symbols File");
            chooser.setFileSelectionMode(0);
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile != null) {
                this.symbolsFileTextField.setText(selectedFile.getAbsolutePath());
            }
        });
        this.symbolsFileTextField.getDocument().addUndoableEditListener(e -> this.updateOkEnablement());
        panel.add((Component)browseButton, "East");
        return panel;
    }

    private Component buildLanguageField() {
        JPanel panel = new JPanel(new BorderLayout());
        this.languageIdField = new JTextField();
        panel.add((Component)this.languageIdField, "Center");
        JButton browseButton = this.createBrowseButton();
        browseButton.addActionListener(e -> {
            SelectLanguageDialog selectLanguageDialog = new SelectLanguageDialog("Select Language", "Ok");
            LanguageCompilerSpecPair selectedLanguage = selectLanguageDialog.getSelectedLanguage();
            if (selectedLanguage != null) {
                this.languageIdField.setText(selectedLanguage.languageID.toString());
            }
        });
        this.languageIdField.getDocument().addUndoableEditListener(e -> this.updateOkEnablement());
        panel.add((Component)browseButton, "East");
        return panel;
    }

    private Component buildLibraryCombo() {
        LibraryChoice[] choices = this.getChoicesForLibraryCombo();
        this.libraryComboBox = new JComboBox<LibraryChoice>(choices);
        return this.libraryComboBox;
    }

    private LibraryChoice[] getChoicesForLibraryCombo() {
        ArrayList<LibraryChoice> list = new ArrayList<LibraryChoice>();
        list.add(new LibraryChoice("None", null));
        FidFile selectedItem = (FidFile)this.fidFileComboBox.getSelectedItem();
        if (selectedItem != null) {
            try (FidDB fidDB = selectedItem.getFidDB(false);){
                List<LibraryRecord> allLibraries = fidDB.getAllLibraries();
                for (LibraryRecord libraryRecord : allLibraries) {
                    list.add(new LibraryChoice(libraryRecord.toString(), libraryRecord));
                }
            }
            catch (VersionException e) {
                Msg.showError((Object)((Object)this), null, (String)"Failed to open FidDb", (Object)("Failed to open incompatible FidDb (may need to regenerate with this version of Ghidra): " + selectedItem.getPath()));
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Failed to open FidDb", (Object)("Failed to open FidDb: " + selectedItem.getPath()), (Throwable)e);
            }
        }
        return list.toArray(new LibraryChoice[list.size()]);
    }

    private Component buildDomainFolderChooserField() {
        JPanel panel = new JPanel(new BorderLayout());
        this.domainFolderField = new JTextField();
        this.domainFolderField.setEditable(false);
        panel.add((Component)this.domainFolderField, "Center");
        JButton browseButton = this.createBrowseButton();
        browseButton.addActionListener(e -> {
            DataTreeDialog dialog = new DataTreeDialog((Component)this.tool.getToolFrame(), "Choose Root Folder", 2);
            this.tool.showDialog((DialogComponentProvider)dialog);
            DomainFolder domainFolder = dialog.getDomainFolder();
            if (domainFolder != null) {
                this.domainFolderField.setText(domainFolder.getPathname());
            }
            this.updateOkEnablement();
        });
        panel.add((Component)browseButton, "East");
        return panel;
    }

    private Component buildFidCombo() {
        List<FidFile> fidFileList = FidFileManager.getInstance().getUserAddedFiles();
        FidFile[] files = fidFileList.toArray(new FidFile[fidFileList.size()]);
        this.fidFileComboBox = new JComboBox<FidFile>(files);
        this.fidFileComboBox.addActionListener(e -> this.updateLibraryChoices());
        return this.fidFileComboBox;
    }

    private void updateLibraryChoices() {
        LibraryChoice[] choices = this.getChoicesForLibraryCombo();
        this.libraryComboBox.setModel(new DefaultComboBoxModel<LibraryChoice>(choices));
        this.updateOkEnablement();
    }

    private void updateOkEnablement() {
        this.setOkEnabled(this.isUserInputComplete());
    }

    private boolean isUserInputComplete() {
        if (this.fidFileComboBox.getSelectedItem() == null) {
            return false;
        }
        if (this.libraryFamilyNameTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.versionTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.variantTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.domainFolderField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.languageIdField.getText().trim().isEmpty()) {
            return false;
        }
        String symbolsFilePath = this.symbolsFileTextField.getText().trim();
        return symbolsFilePath.isEmpty() || new File(symbolsFilePath).exists();
    }

    private JButton createBrowseButton() {
        JButton browseButton = ButtonPanelFactory.createButton((int)2);
        Font font = browseButton.getFont();
        browseButton.setFont(new Font(font.getName(), 1, font.getSize()));
        return browseButton;
    }

    private static class LibraryChoice {
        private final String name;
        private final LibraryRecord libraryRecord;

        LibraryChoice(String name, LibraryRecord libraryRecord) {
            this.name = name;
            this.libraryRecord = libraryRecord;
        }

        public String toString() {
            return this.name;
        }

        public LibraryRecord getLibraryRecord() {
            return this.libraryRecord;
        }
    }
}

