/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.DockingKeyBindingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginStatus;
import java.awt.Color;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class PluginDetailsPanel
extends AbstractDetailsPanel {
    private static SimpleAttributeSet nameAttrSet;
    private static SimpleAttributeSet depNameAttrSet;
    private static SimpleAttributeSet descrAttrSet;
    private static SimpleAttributeSet categoriesAttrSet;
    private static SimpleAttributeSet classAttrSet;
    private static SimpleAttributeSet locAttrSet;
    private static SimpleAttributeSet developerAttrSet;
    private static SimpleAttributeSet dependencyAttrSet;
    private static SimpleAttributeSet noValueAttrSet;
    private final PluginConfigurationModel model;

    PluginDetailsPanel(PluginConfigurationModel model) {
        this.model = model;
        this.createFieldAttributes();
        this.createMainPanel();
    }

    void setPluginDescription(PluginDescription pluginDescription) {
        this.textLabel.setText("");
        if (pluginDescription == null) {
            return;
        }
        List<PluginDescription> dependencies = this.model.getDependencies(pluginDescription);
        Collections.sort(dependencies, (pd1, pd2) -> pd1.getName().compareTo(pd2.getName()));
        StringBuilder buffer = new StringBuilder("<HTML>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, pluginDescription.getName(), !dependencies.isEmpty() ? depNameAttrSet : nameAttrSet);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, this.formatDescription(pluginDescription.getDescription()), descrAttrSet);
        this.insertRowTitle(buffer, "Status");
        this.insertRowValue(buffer, pluginDescription.getStatus().getDescription(), pluginDescription.getStatus() == PluginStatus.RELEASED ? titleAttrSet : developerAttrSet);
        this.insertRowTitle(buffer, "Package");
        this.insertRowValue(buffer, pluginDescription.getPluginPackage().getName(), categoriesAttrSet);
        this.insertRowTitle(buffer, "Category");
        this.insertRowValue(buffer, pluginDescription.getCategory(), categoriesAttrSet);
        this.insertRowTitle(buffer, "Plugin Class");
        this.insertRowValue(buffer, pluginDescription.getPluginClass().getName(), classAttrSet);
        this.insertRowTitle(buffer, "Class Location");
        this.insertRowValue(buffer, pluginDescription.getSourceLocation(), locAttrSet);
        this.insertRowTitle(buffer, "Used By");
        buffer.append("<TD VALIGN=\"TOP\">");
        if (dependencies.isEmpty()) {
            this.insertHTMLLine("None", titleAttrSet, buffer);
        } else {
            for (int i = 0; i < dependencies.size(); ++i) {
                this.insertHTMLString(dependencies.get(i).getPluginClass().getName(), dependencyAttrSet, buffer);
                if (i >= dependencies.size() - 1) continue;
                this.insertHTMLString("<BR>", dependencyAttrSet, buffer);
            }
            this.insertHTMLLine("", titleAttrSet, buffer);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.insertRowTitle(buffer, "Services Required");
        buffer.append("<TD VALIGN=\"TOP\">");
        List<Class<?>> servicesRequired = pluginDescription.getServicesRequired();
        if (servicesRequired.isEmpty()) {
            this.insertHTMLLine("None", titleAttrSet, buffer);
        } else {
            for (int i = 0; i < servicesRequired.size(); ++i) {
                this.insertHTMLString(servicesRequired.get(i).getName(), dependencyAttrSet, buffer);
                if (i >= dependencies.size() - 1) continue;
                this.insertHTMLString("<BR>", dependencyAttrSet, buffer);
            }
            this.insertHTMLLine("", titleAttrSet, buffer);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.addLoadedActionsContent(buffer, pluginDescription);
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    private void addLoadedActionsContent(StringBuilder buffer, PluginDescription pluginDescription) {
        if (!this.model.isLoaded(pluginDescription)) {
            return;
        }
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine("Loaded Actions:", titleAttrSet, buffer);
        buffer.append("</TD>");
        List<DockingActionIf> actionList = this.model.getActionsForPlugin(pluginDescription);
        if (actionList.size() == 0) {
            buffer.append("<TD VALIGN=\"TOP\">");
            this.insertHTMLLine("No actions for plugin", noValueAttrSet, buffer);
            buffer.append("</TD>");
            buffer.append("</TR>");
            return;
        }
        buffer.append("<TD VALIGN=\"TOP\">");
        buffer.append("<TABLE BORDER=1><TR><TH>Action Name</TH><TH>Menu Path</TH><TH>Keybinding</TH></TR>");
        for (DockingActionIf dockableAction : actionList) {
            buffer.append("<TR><TD WIDTH=\"200\">");
            this.insertHTMLString(dockableAction.getName(), locAttrSet, buffer);
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"300\">");
            MenuData menuBarData = dockableAction.getMenuBarData();
            String[] menuPath = menuBarData == null ? null : menuBarData.getMenuPath();
            String menuPathString = this.createStringForMenuPath(menuPath);
            if (menuPathString != null) {
                this.insertHTMLString(menuPathString, locAttrSet, buffer);
            } else {
                String[] popupPath;
                MenuData popupMenuData = dockableAction.getPopupMenuData();
                String[] stringArray = popupPath = popupMenuData == null ? null : popupMenuData.getMenuPath();
                if (popupPath != null) {
                    this.insertHTMLString("(in a context popup menu)", noValueAttrSet, buffer);
                } else {
                    this.insertHTMLString("Not in a menu", noValueAttrSet, buffer);
                }
            }
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"100\">");
            KeyStroke keyBinding = dockableAction.getKeyBinding();
            if (keyBinding != null) {
                String keyStrokeString = DockingKeyBindingAction.parseKeyStroke((KeyStroke)keyBinding);
                this.insertHTMLString(keyStrokeString, locAttrSet, buffer);
            } else {
                this.insertHTMLString("No keybinding", noValueAttrSet, buffer);
            }
            buffer.append("</TD></TR>");
        }
        buffer.append("</TABLE>");
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    private String createStringForMenuPath(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuffer buffy = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            buffy.append(path[i].replaceAll("\\&", ""));
            if (i == path.length - 1) continue;
            buffy.append("-&gt;");
        }
        return buffy.toString();
    }

    @Override
    protected void createFieldAttributes() {
        titleAttrSet = new SimpleAttributeSet();
        titleAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        titleAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        titleAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        titleAttrSet.addAttribute(StyleConstants.Foreground, new Color(140, 0, 0));
        nameAttrSet = new SimpleAttributeSet();
        nameAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        nameAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        nameAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        nameAttrSet.addAttribute(StyleConstants.Foreground, new Color(0, 204, 51));
        depNameAttrSet = new SimpleAttributeSet();
        depNameAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        depNameAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        depNameAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        depNameAttrSet.addAttribute(StyleConstants.Foreground, Color.RED);
        descrAttrSet = new SimpleAttributeSet();
        descrAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        descrAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        descrAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        descrAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        categoriesAttrSet = new SimpleAttributeSet();
        categoriesAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        categoriesAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        categoriesAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        categoriesAttrSet.addAttribute(StyleConstants.Foreground, new Color(204, 0, 204));
        classAttrSet = new SimpleAttributeSet();
        classAttrSet.addAttribute(StyleConstants.FontFamily, "monospaced");
        classAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        classAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        classAttrSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
        locAttrSet = new SimpleAttributeSet();
        locAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        locAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        locAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        locAttrSet.addAttribute(StyleConstants.Foreground, Color.DARK_GRAY);
        developerAttrSet = new SimpleAttributeSet();
        developerAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        developerAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        developerAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        developerAttrSet.addAttribute(StyleConstants.Foreground, new Color(230, 15, 85));
        dependencyAttrSet = new SimpleAttributeSet();
        dependencyAttrSet.addAttribute(StyleConstants.FontFamily, "monospaced");
        dependencyAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        dependencyAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        dependencyAttrSet.addAttribute(StyleConstants.Foreground, new Color(23, 100, 30));
        noValueAttrSet = new SimpleAttributeSet();
        noValueAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        noValueAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        noValueAttrSet.addAttribute(StyleConstants.Italic, Boolean.TRUE);
        noValueAttrSet.addAttribute(StyleConstants.Foreground, new Color(192, 192, 192));
    }
}

