/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import com.google.common.collect.Iterables;
import docking.DialogComponentProvider;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.list.ListPanel;
import ghidra.framework.ToolUtils;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.ToolTemplate;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

class ImportGhidraToolsDialog
extends DialogComponentProvider {
    private static final String SELECT_ALL = "Select All";
    private static final String DESELECT_ALL = "Select None";
    private ListPanel listPanel;
    private JPanel mainPanel;
    private JCheckBox[] checkboxes;
    private String[] tools;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private FrontEndTool tool;
    private boolean cancelled = false;

    ImportGhidraToolsDialog(FrontEndTool tool) {
        super("Import Ghidra Tools", true);
        this.setHelpLocation(new HelpLocation("Tool", "Import Ghidra Tools"));
        this.tool = tool;
        this.mainPanel = this.createPanel();
        this.addWorkPanel(this.mainPanel);
        this.addOKButton();
        this.addCancelButton();
        this.addListeners();
    }

    void showDialog() {
        this.clearStatusText();
        this.loadListData();
        this.tool.showDialog(this);
    }

    protected void okCallback() {
        this.close();
    }

    protected void cancelCallback() {
        this.cancelled = true;
        this.close();
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel availableToolsPanel = new JPanel(new BorderLayout());
        this.selectAllButton = new JButton(SELECT_ALL);
        this.selectAllButton.setMnemonic('A');
        this.deselectAllButton = new JButton(DESELECT_ALL);
        this.deselectAllButton.setMnemonic('N');
        JPanel buttonPanel = ButtonPanelFactory.createButtonPanel((JButton[])new JButton[]{this.selectAllButton, this.deselectAllButton});
        this.listPanel = new ListPanel();
        this.listPanel.setCellRenderer((ListCellRenderer)new DataCellRenderer());
        this.listPanel.setMouseListener((MouseListener)new ListMouseListener());
        availableToolsPanel.add((Component)buttonPanel, "East");
        availableToolsPanel.add((Component)this.listPanel, "Center");
        availableToolsPanel.setBorder(new TitledBorder("Available Tools"));
        panel.add((Component)availableToolsPanel, "Center");
        return panel;
    }

    private void addListeners() {
        this.selectAllButton.addActionListener(e -> this.selectAll());
        this.deselectAllButton.addActionListener(e -> this.deselectAll());
    }

    private void selectAll() {
        for (JCheckBox checkboxe : this.checkboxes) {
            checkboxe.setSelected(true);
        }
        this.listPanel.repaint();
    }

    private void deselectAll() {
        for (JCheckBox checkboxe : this.checkboxes) {
            checkboxe.setSelected(false);
        }
        this.listPanel.repaint();
    }

    private void loadListData() {
        Set<ToolTemplate> defaultTools = ToolUtils.getDefaultApplicationTools();
        Set<ToolTemplate> extraTools = ToolUtils.getExtraApplicationTools();
        Iterable defaultToolNames = Iterables.transform(defaultTools, ToolTemplate::getPath);
        Iterable extraToolNames = Iterables.transform(extraTools, ToolTemplate::getPath);
        int elementCount = defaultTools.size() + extraTools.size();
        this.tools = new String[elementCount];
        this.checkboxes = new JCheckBox[elementCount];
        Iterator itr = defaultToolNames.iterator();
        int count = 0;
        while (itr.hasNext()) {
            this.tools[count] = (String)itr.next();
            this.checkboxes[count] = new JCheckBox(this.tools[count], false);
            this.checkboxes[count].setBackground(Color.WHITE);
            ++count;
        }
        itr = extraToolNames.iterator();
        while (itr.hasNext()) {
            this.tools[count] = (String)itr.next();
            this.checkboxes[count] = new JCheckBox(this.tools[count], false);
            this.checkboxes[count].setBackground(Color.LIGHT_GRAY);
            ++count;
        }
        this.listPanel.refreshList((Object[])this.checkboxes);
    }

    public List<String> getSelectedList() {
        ArrayList<String> ret = new ArrayList<String>();
        for (JCheckBox checkboxe : this.checkboxes) {
            if (!checkboxe.isSelected()) continue;
            ret.add(checkboxe.getText());
        }
        return ret;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImportGhidraToolsDialog.this.clearStatusText();
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            boolean selected = ImportGhidraToolsDialog.this.checkboxes[index].isSelected();
            ImportGhidraToolsDialog.this.checkboxes[index].setSelected(!selected);
            ImportGhidraToolsDialog.this.listPanel.repaint();
        }
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private Font boldFont;

        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.boldFont == null) {
                Font font = list.getFont();
                this.boldFont = new Font(font.getName(), font.getStyle() | 1, font.getSize());
            }
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return null;
                }
                index = selected;
            }
            return ImportGhidraToolsDialog.this.checkboxes[index];
        }
    }
}

