/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlets.gzip.AbstractCompressedStream;
import org.eclipse.jetty.servlets.gzip.CompressedResponseWrapper;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.RegexSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected String _vary = "Accept-Encoding, User-Agent";
    private final IncludeExclude<String> _agentPatterns = new IncludeExclude(RegexSet.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();

    public GzipHandler() {
        this._methods.include(HttpMethod.GET.asString());
        for (String type : MimeTypes.getKnownMimeTypes()) {
            if ("image/svg+xml".equals(type)) {
                this._paths.exclude("*.svgz");
                continue;
            }
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude(type);
        }
        this._mimeTypes.exclude("application/compress");
        this._mimeTypes.exclude("application/zip");
        this._mimeTypes.exclude("application/gzip");
        this._mimeTypes.exclude("application/bzip2");
        this._mimeTypes.exclude("application/x-rar-compressed");
        LOG.debug("{} mime types {}", this, this._mimeTypes);
        this._agentPatterns.exclude(".*MSIE 6.0.*");
    }

    public void addExcludedAgentPatterns(String ... patterns) {
        this._agentPatterns.exclude((P[])patterns);
    }

    public void addExcludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.exclude(m);
        }
    }

    public void addExcludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.exclude((P[])StringUtil.csvSplit(t));
        }
    }

    public void addExcludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.exclude((P[])StringUtil.csvSplit(p));
        }
    }

    public void addIncludedAgentPatterns(String ... patterns) {
        this._agentPatterns.include((P[])patterns);
    }

    public void addIncludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.include(m);
        }
    }

    public void addIncludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.include((P[])StringUtil.csvSplit(t));
        }
    }

    public void addIncludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.include((P[])StringUtil.csvSplit(p));
        }
    }

    public String[] getExcludedAgentPatterns() {
        Set excluded = this._agentPatterns.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedMethods() {
        Set excluded = this._methods.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedMimeTypes() {
        Set excluded = this._mimeTypes.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedPaths() {
        Set excluded = this._paths.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getIncludedAgentPatterns() {
        Set includes = this._agentPatterns.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedMethods() {
        Set includes = this._methods.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedMimeTypes() {
        Set includes = this._mimeTypes.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedPaths() {
        Set includes = this._paths.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    @Deprecated
    public Set<String> getMimeTypes() {
        throw new UnsupportedOperationException("Use getIncludedMimeTypes or getExcludedMimeTypes instead");
    }

    @Deprecated
    public void setMimeTypes(Set<String> mimeTypes) {
        throw new UnsupportedOperationException("Use setIncludedMimeTypes or setExcludedMimeTypes instead");
    }

    @Deprecated
    public void setMimeTypes(String mimeTypes) {
        throw new UnsupportedOperationException("Use setIncludedMimeTypes or setExcludedMimeTypes instead");
    }

    @Deprecated
    public void setExcludeMimeTypes(boolean exclude) {
        throw new UnsupportedOperationException("Use setExcludedMimeTypes instead");
    }

    public Set<String> getExcluded() {
        return this._agentPatterns.getExcluded();
    }

    public void setExcluded(Set<String> excluded) {
        this._agentPatterns.getExcluded().clear();
        this._agentPatterns.getExcluded().addAll(excluded);
    }

    public void setExcluded(String excluded) {
        this._agentPatterns.getExcluded().clear();
        if (excluded != null) {
            this._agentPatterns.exclude((P[])StringUtil.csvSplit(excluded));
        }
    }

    public String getVary() {
        return this._vary;
    }

    public void setVary(String vary) {
        this._vary = vary;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block12: {
            block11: {
                if (this._handler == null || !this.isStarted()) {
                    return;
                }
                if (!this.isGzippable(baseRequest, request, response)) break block11;
                CompressedResponseWrapper wrappedResponse = this.newGzipResponseWrapper(request, response);
                boolean exceptional = true;
                try {
                    this._handler.handle(target, baseRequest, request, wrappedResponse);
                    exceptional = false;
                }
                catch (Throwable throwable) {
                    if (request.isAsyncStarted()) {
                        request.getAsyncContext().addListener(new AsyncListener(wrappedResponse){
                            final /* synthetic */ CompressedResponseWrapper val$wrappedResponse;
                            {
                                this.val$wrappedResponse = compressedResponseWrapper;
                            }

                            @Override
                            public void onTimeout(AsyncEvent event) throws IOException {
                            }

                            @Override
                            public void onStartAsync(AsyncEvent event) throws IOException {
                            }

                            @Override
                            public void onError(AsyncEvent event) throws IOException {
                            }

                            @Override
                            public void onComplete(AsyncEvent event) throws IOException {
                                try {
                                    this.val$wrappedResponse.finish();
                                }
                                catch (IOException e) {
                                    LOG.warn(e);
                                }
                            }
                        });
                    } else if (exceptional && !response.isCommitted()) {
                        wrappedResponse.resetBuffer();
                        wrappedResponse.noCompression();
                    } else {
                        wrappedResponse.finish();
                    }
                    throw throwable;
                }
                if (request.isAsyncStarted()) {
                    request.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
                } else if (exceptional && !response.isCommitted()) {
                    wrappedResponse.resetBuffer();
                    wrappedResponse.noCompression();
                } else {
                    wrappedResponse.finish();
                }
                break block12;
            }
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    private boolean isGzippable(Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
        String mimeType;
        String path;
        String ae = request.getHeader("accept-encoding");
        if (ae == null || !ae.contains("gzip")) {
            return false;
        }
        if (response.containsHeader("Content-Encoding")) {
            LOG.debug("{} excluded as Content-Encoding already declared {}", this, request);
            return false;
        }
        if (HttpMethod.HEAD.is(request.getMethod())) {
            LOG.debug("{} excluded by method {}", this, request);
            return false;
        }
        if (!this._methods.matches(baseRequest.getMethod())) {
            LOG.debug("{} excluded by method {}", this, request);
            return false;
        }
        ServletContext context = baseRequest.getServletContext();
        String string = path = context == null ? baseRequest.getRequestURI() : URIUtil.addPaths(baseRequest.getServletPath(), baseRequest.getPathInfo());
        if (path != null && !this._paths.matches(path)) {
            LOG.debug("{} excluded by path {}", this, request);
            return false;
        }
        String string2 = mimeType = context == null ? null : context.getMimeType(path);
        if (mimeType != null && !this._mimeTypes.matches(mimeType = MimeTypes.getContentTypeWithoutCharset(mimeType))) {
            LOG.debug("{} excluded by path suffix mime type {}", this, request);
            return false;
        }
        String ua = request.getHeader("User-Agent");
        if (ua != null && !this._agentPatterns.matches(ua)) {
            LOG.debug("{} excluded by user-agent {}", this, request);
            return false;
        }
        return true;
    }

    protected CompressedResponseWrapper newGzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        return new CompressedResponseWrapper(request, response){
            {
                super.setMimeTypes(GzipHandler.this._mimeTypes);
                super.setBufferSize(GzipHandler.this._bufferSize);
                super.setMinCompressSize(GzipHandler.this._minGzipSize);
            }

            @Override
            protected AbstractCompressedStream newCompressedStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return new AbstractCompressedStream("gzip", request, this, GzipHandler.this._vary){

                    @Override
                    protected DeflaterOutputStream createStream() throws IOException {
                        return new GZIPOutputStream((OutputStream)this._response.getOutputStream(), GzipHandler.this._bufferSize);
                    }
                };
            }

            @Override
            protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
                return GzipHandler.this.newWriter(out, encoding);
            }
        };
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }
}

