/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jd.gui.spi.PreferencesPanel;

public class ClassFileDecompilerPreferencesProvider
extends JPanel
implements PreferencesPanel {
    protected static final String ESCAPE_UNICODE_CHARACTERS = "ClassFileDecompilerPreferences.escapeUnicodeCharacters";
    protected static final String REALIGN_LINE_NUMBERS = "ClassFileDecompilerPreferences.realignLineNumbers";
    protected PreferencesPanel.PreferencesPanelChangeListener listener = null;
    protected JCheckBox escapeUnicodeCharactersCheckBox = new JCheckBox("Escape unicode characters");
    protected JCheckBox realignLineNumbersCheckBox = new JCheckBox("Realign line numbers");

    public ClassFileDecompilerPreferencesProvider() {
        super(new GridLayout(0, 1));
        this.add(this.escapeUnicodeCharactersCheckBox);
        this.add(this.realignLineNumbersCheckBox);
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "Decompiler";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Class file";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        this.escapeUnicodeCharactersCheckBox.setSelected("true".equals(preferences.get(ESCAPE_UNICODE_CHARACTERS)));
        this.realignLineNumbersCheckBox.setSelected(!"false".equals(preferences.get(REALIGN_LINE_NUMBERS)));
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(ESCAPE_UNICODE_CHARACTERS, Boolean.toString(this.escapeUnicodeCharactersCheckBox.isSelected()));
        preferences.put(REALIGN_LINE_NUMBERS, Boolean.toString(this.realignLineNumbersCheckBox.isSelected()));
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

