/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    private static final long serialVersionUID = -937921345538462020L;
    Icon default_icon;
    Icon pressed_icon;
    Icon disabledIcon;
    Icon selectedIcon;
    Icon disabledSelectedIcon;
    Icon rolloverIcon;
    Icon rolloverSelectedIcon;
    Icon current_icon;
    String text;
    int iconTextGap;
    int verticalAlignment = 0;
    int horizontalAlignment = 0;
    int horizontalTextPosition = 11;
    int verticalTextPosition = 0;
    boolean borderPainted = true;
    boolean focusPainted = true;
    boolean contentAreaFilled = true;
    boolean rollOverEnabled;
    Action action;
    protected ButtonModel model;
    Insets margin;
    int mnemonicIndex;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected ChangeListener changeListener;
    private EventHandler eventHandler;
    long multiClickThreshhold;
    PropertyChangeListener actionPropertyChangeListener;
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    private boolean clientBorderPaintedSet = false;
    private boolean clientRolloverEnabledSet = false;
    private boolean clientIconTextGapSet = false;
    private boolean clientContentAreaFilledSet = false;
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";

    public AbstractButton() {
        this.setFocusable(true);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setDisplayedMnemonicIndex(-1);
        this.setOpaque(true);
        this.text = "";
        this.iconTextGap = 4;
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel newModel) {
        if (newModel == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.removeActionListener(this.actionListener);
            this.actionListener = null;
            this.model.removeChangeListener(this.changeListener);
            this.changeListener = null;
            this.model.removeItemListener(this.itemListener);
            this.itemListener = null;
        }
        ButtonModel old = this.model;
        this.model = newModel;
        if (this.model != null) {
            this.actionListener = this.createActionListener();
            this.model.addActionListener(this.actionListener);
            this.changeListener = this.createChangeListener();
            this.model.addChangeListener(this.changeListener);
            this.itemListener = this.createItemListener();
            this.model.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, old, this.model);
        this.revalidate();
        this.repaint();
    }

    protected void init(String text, Icon icon) {
        if (text != null) {
            this.setText(text);
        }
        if (icon != null) {
            this.default_icon = icon;
        }
        this.updateUI();
    }

    public String getActionCommand() {
        String ac = this.model.getActionCommand();
        if (ac != null) {
            return ac;
        }
        return this.text;
    }

    public void setActionCommand(String actionCommand) {
        if (this.model != null) {
            this.model.setActionCommand(actionCommand);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        e.setSource(this);
        ItemListener[] listeners = this.getItemListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].itemStateChanged(e);
            ++i;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionEvent ae = new ActionEvent(this, e.getID(), this.getActionCommand(), e.getWhen(), e.getModifiers());
        ActionListener[] listeners = this.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].actionPerformed(ae);
            ++i;
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    public int getMnemonic() {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            return mod.getMnemonic();
        }
        return -1;
    }

    public void setMnemonic(char mne) {
        this.setMnemonic((int)mne);
    }

    public void setMnemonic(int mne) {
        ButtonModel mod = this.getModel();
        int old = -1;
        if (mod != null) {
            old = mod.getMnemonic();
        }
        if (old != mne) {
            if (mod != null) {
                mod.setMnemonic(mne);
            }
            if (this.text != null && !this.text.equals("")) {
                char upperCaseMne = Character.toUpperCase((char)mne);
                String upperCaseText = this.text.toUpperCase();
                this.setDisplayedMnemonicIndex(upperCaseText.indexOf(upperCaseMne));
            }
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, old, mne);
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisplayedMnemonicIndex(int index) {
        if (index < -1 || this.text != null && index >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        this.mnemonicIndex = index;
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setRolloverEnabled(boolean r) {
        this.clientRolloverEnabledSet = true;
        if (this.rollOverEnabled != r) {
            this.rollOverEnabled = r;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, !r, r);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRolloverEnabled() {
        return this.rollOverEnabled;
    }

    public void setSelected(boolean s) {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setSelected(s);
        }
    }

    public boolean isSelected() {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            return mod.isSelected();
        }
        return false;
    }

    public void setEnabled(boolean b) {
        if (b == this.isEnabled()) {
            return;
        }
        super.setEnabled(b);
        this.setFocusable(b);
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setEnabled(b);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int a) {
        if (this.horizontalAlignment == a) {
            return;
        }
        if (a != 2 && a != 0 && a != 4 && a != 10 && a != 11) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int old = this.horizontalAlignment;
        this.horizontalAlignment = a;
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
        this.revalidate();
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int t) {
        if (this.horizontalTextPosition == t) {
            return;
        }
        if (t != 2 && t != 0 && t != 4 && t != 10 && t != 11) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int old = this.horizontalTextPosition;
        this.horizontalTextPosition = t;
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int a) {
        if (this.verticalAlignment == a) {
            return;
        }
        if (a != 1 && a != 0 && a != 3) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int old = this.verticalAlignment;
        this.verticalAlignment = a;
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
        this.revalidate();
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int t) {
        if (this.verticalTextPosition == t) {
            return;
        }
        if (t != 1 && t != 0 && t != 3) {
            throw new IllegalArgumentException("Invalid alignment.");
        }
        int old = this.verticalTextPosition;
        this.verticalTextPosition = t;
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean b) {
        this.clientBorderPaintedSet = true;
        if (this.borderPainted == b) {
            return;
        }
        boolean old = this.borderPainted;
        this.borderPainted = b;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, old, b);
        this.revalidate();
        this.repaint();
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action a) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.removeActionListener(this.action);
            if (this.actionPropertyChangeListener != null) {
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
        }
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(a);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            this.addActionListener(this.action);
        }
    }

    public Icon getIcon() {
        return this.default_icon;
    }

    public void setIcon(Icon i) {
        if (this.default_icon == i) {
            return;
        }
        Icon old = this.default_icon;
        this.default_icon = i;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, old, i);
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setText(String t) {
        if (this.text == t) {
            return;
        }
        String old = this.text;
        this.text = t;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, old, t);
        this.revalidate();
        this.repaint();
    }

    public void setIconTextGap(int i) {
        this.clientIconTextGapSet = true;
        if (this.iconTextGap == i) {
            return;
        }
        int old = this.iconTextGap;
        this.iconTextGap = i;
        this.firePropertyChange("iconTextGap", new Integer(old), new Integer(i));
        this.revalidate();
        this.repaint();
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets m) {
        if (this.margin == m) {
            return;
        }
        Insets old = this.margin;
        this.margin = m;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, old, m);
        this.revalidate();
        this.repaint();
    }

    public Icon getPressedIcon() {
        return this.pressed_icon;
    }

    public void setPressedIcon(Icon pressedIcon) {
        if (this.pressed_icon == pressedIcon) {
            return;
        }
        Icon old = this.pressed_icon;
        this.pressed_icon = pressedIcon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, old, this.pressed_icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.default_icon instanceof ImageIcon) {
            Image iconImage = ((ImageIcon)this.default_icon).getImage();
            Image grayImage = GrayFilter.createDisabledImage(iconImage);
            this.disabledIcon = new ImageIcon(grayImage);
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon d) {
        if (this.disabledIcon == d) {
            return;
        }
        Icon old = this.disabledIcon;
        this.disabledIcon = d;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, old, d);
        this.revalidate();
        this.repaint();
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean p) {
        if (this.focusPainted == p) {
            return;
        }
        boolean old = this.focusPainted;
        this.focusPainted = p;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, old, p);
        this.revalidate();
        this.repaint();
    }

    protected int checkHorizontalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected int checkVerticalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setText(null);
            this.setIcon(null);
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            String actionCommand;
            this.setText((String)a.getValue("Name"));
            this.setIcon((Icon)a.getValue("SmallIcon"));
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
            if (a.getValue("MnemonicKey") != null) {
                this.setMnemonic((Integer)a.getValue("MnemonicKey"));
            }
            if ((actionCommand = (String)a.getValue("ActionCommandKey")) != null) {
                this.setActionCommand((String)a.getValue("ActionCommandKey"));
            } else {
                this.setActionCommand(this.getText());
            }
        }
    }

    protected ActionListener createActionListener() {
        return this.getEventHandler();
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                if (e.getPropertyName().equals("enabled")) {
                    AbstractButton.this.setEnabled(act.isEnabled());
                } else if (e.getPropertyName().equals("Name")) {
                    AbstractButton.this.setText((String)act.getValue("Name"));
                } else if (e.getPropertyName().equals("SmallIcon")) {
                    AbstractButton.this.setIcon((Icon)act.getValue("SmallIcon"));
                } else if (e.getPropertyName().equals("ShortDescription")) {
                    AbstractButton.this.setToolTipText((String)act.getValue("ShortDescription"));
                } else if (e.getPropertyName().equals("MnemonicKey")) {
                    if (act.getValue("MnemonicKey") != null) {
                        AbstractButton.this.setMnemonic((Integer)act.getValue("MnemonicKey"));
                    } else if (e.getPropertyName().equals("ActionCommandKey")) {
                        AbstractButton.this.setActionCommand((String)act.getValue("ActionCommandKey"));
                    }
                }
            }
        };
    }

    protected ChangeListener createChangeListener() {
        return this.getEventHandler();
    }

    protected ItemListener createItemListener() {
        return this.getEventHandler();
    }

    public void doClick() {
        this.doClick(100);
    }

    public void doClick(int pressTime) {
        ButtonModel mod = this.getModel();
        if (mod != null) {
            mod.setArmed(true);
            mod.setPressed(true);
            try {
                Thread.sleep(pressTime);
            }
            catch (InterruptedException interruptedException) {}
            mod.setPressed(false);
            mod.setArmed(false);
        }
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon icon) {
        if (this.disabledSelectedIcon == icon) {
            return;
        }
        Icon old = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, old, icon);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon r) {
        if (this.rolloverIcon == r) {
            return;
        }
        Icon old = this.rolloverIcon;
        this.rolloverIcon = r;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, old, this.rolloverIcon);
        this.setRolloverEnabled(true);
        this.revalidate();
        this.repaint();
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon r) {
        if (this.rolloverSelectedIcon == r) {
            return;
        }
        Icon old = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = r;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, old, r);
        this.setRolloverEnabled(true);
        this.revalidate();
        this.repaint();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon s) {
        if (this.selectedIcon == s) {
            return;
        }
        Icon old = this.selectedIcon;
        this.selectedIcon = s;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, old, s);
        this.revalidate();
        this.repaint();
    }

    public Object[] getSelectedObjects() {
        if (this.isSelected()) {
            Object[] objs = new Object[]{this.getText()};
            return objs;
        }
        return null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.current_icon == img;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public void setContentAreaFilled(boolean b) {
        this.clientContentAreaFilledSet = true;
        if (this.contentAreaFilled == b) {
            return;
        }
        this.setOpaque(b);
        boolean old = this.contentAreaFilled;
        this.contentAreaFilled = b;
        this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, old, b);
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    protected String paramString() {
        CPStringBuilder sb = new CPStringBuilder();
        sb.append(super.paramString());
        sb.append(",defaultIcon=");
        if (this.getIcon() != null) {
            sb.append(this.getIcon());
        }
        sb.append(",disabledIcon=");
        if (this.getDisabledIcon() != null) {
            sb.append(this.getDisabledIcon());
        }
        sb.append(",disabledSelectedIcon=");
        if (this.getDisabledSelectedIcon() != null) {
            sb.append(this.getDisabledSelectedIcon());
        }
        sb.append(",margin=");
        if (this.getMargin() != null) {
            sb.append(this.getMargin());
        }
        sb.append(",paintBorder=").append(this.isBorderPainted());
        sb.append(",paintFocus=").append(this.isFocusPainted());
        sb.append(",pressedIcon=");
        if (this.getPressedIcon() != null) {
            sb.append(this.getPressedIcon());
        }
        sb.append(",rolloverEnabled=").append(this.isRolloverEnabled());
        sb.append(",rolloverIcon=");
        if (this.getRolloverIcon() != null) {
            sb.append(this.getRolloverIcon());
        }
        sb.append(",rolloverSelected=");
        if (this.getRolloverSelectedIcon() != null) {
            sb.append(this.getRolloverSelectedIcon());
        }
        sb.append(",selectedIcon=");
        if (this.getSelectedIcon() != null) {
            sb.append(this.getSelectedIcon());
        }
        sb.append(",text=");
        if (this.getText() != null) {
            sb.append(this.getText());
        }
        return sb.toString();
    }

    public void setUI(ButtonUI ui) {
        super.setUI(ui);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void updateUI() {
    }

    public long getMultiClickThreshhold() {
        return this.multiClickThreshhold;
    }

    public void setMultiClickThreshhold(long threshhold) {
        if (threshhold < 0L) {
            throw new IllegalArgumentException();
        }
        this.multiClickThreshhold = threshhold;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.getClientProperty("AbstractButton.customLayoutSet") == null) {
            this.setLayout(new OverlayLayout(this));
        }
        super.addImpl(comp, constraints, index);
    }

    public void setLayout(LayoutManager layout) {
        this.putClientProperty("AbstractButton.customLayoutSet", Boolean.TRUE);
        super.setLayout(layout);
    }

    void setUIProperty(String propertyName, Object value) {
        if (propertyName.equals(BORDER_PAINTED_CHANGED_PROPERTY)) {
            if (!this.clientBorderPaintedSet) {
                this.setBorderPainted((Boolean)value);
                this.clientBorderPaintedSet = false;
            }
        } else if (propertyName.equals(ROLLOVER_ENABLED_CHANGED_PROPERTY)) {
            if (!this.clientRolloverEnabledSet) {
                this.setRolloverEnabled((Boolean)value);
                this.clientRolloverEnabledSet = false;
            }
        } else if (propertyName.equals("iconTextGap")) {
            if (!this.clientIconTextGapSet) {
                this.setIconTextGap((Integer)value);
                this.clientIconTextGapSet = false;
            }
        } else if (propertyName.equals(CONTENT_AREA_FILLED_CHANGED_PROPERTY)) {
            if (!this.clientContentAreaFilledSet) {
                this.setContentAreaFilled((Boolean)value);
                this.clientContentAreaFilledSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    EventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new EventHandler();
        }
        return this.eventHandler;
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        private static final long serialVersionUID = -5673062525319836790L;

        protected AccessibleAbstractButton() {
            super(AbstractButton.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet state = super.getAccessibleStateSet();
            if (AbstractButton.this.getModel().isArmed()) {
                state.add(AccessibleState.ARMED);
            }
            if (AbstractButton.this.getModel().isPressed()) {
                state.add(AccessibleState.PRESSED);
            }
            if (AbstractButton.this.isSelected()) {
                state.add(AccessibleState.CHECKED);
            }
            return state;
        }

        public String getAccessibleName() {
            String result = super.getAccessibleName();
            if (result == null) {
                result = AbstractButton.this.text;
            }
            return result;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext ctx;
            AccessibleIcon[] ret = null;
            Icon icon = AbstractButton.this.getIcon();
            if (icon instanceof Accessible && (ctx = ((Accessible)((Object)icon)).getAccessibleContext()) instanceof AccessibleIcon) {
                ret = new AccessibleIcon[]{(AccessibleIcon)((Object)ctx)};
            }
            return ret;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            ButtonGroup group;
            AccessibleRelationSet relations = super.getAccessibleRelationSet();
            ButtonModel model = AbstractButton.this.getModel();
            if (model instanceof DefaultButtonModel && (group = ((DefaultButtonModel)model).getGroup()) != null) {
                Object[] target = new Object[group.getButtonCount()];
                Enumeration<AbstractButton> els = group.getElements();
                int index = 0;
                while (els.hasMoreElements()) {
                    target[index] = els.nextElement();
                    ++index;
                }
                AccessibleRelation rel = new AccessibleRelation(AccessibleRelation.MEMBER_OF);
                rel.setTarget(target);
                relations.add(rel);
            }
            return relations;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int actionIndex) {
            String descr = null;
            if (actionIndex == 0) {
                descr = UIManager.getString("AbstractButton.clickText");
            }
            return descr;
        }

        public boolean doAccessibleAction(int actionIndex) {
            boolean retVal = false;
            if (actionIndex == 0) {
                AbstractButton.this.doClick();
                retVal = true;
            }
            return retVal;
        }

        public Number getCurrentAccessibleValue() {
            Integer retVal = AbstractButton.this.isSelected() ? new Integer(1) : new Integer(0);
            return retVal;
        }

        public boolean setCurrentAccessibleValue(Number value) {
            boolean retVal = false;
            if (value != null) {
                if (value.intValue() == 0) {
                    AbstractButton.this.setSelected(false);
                } else {
                    AbstractButton.this.setSelected(true);
                }
                retVal = true;
            }
            return retVal;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        public AccessibleText getAccessibleText() {
            AccessibleAbstractButton accessibleText = null;
            if (AbstractButton.this.getClientProperty("html") != null) {
                accessibleText = this;
            }
            return accessibleText;
        }

        public int getIndexAtPoint(Point p) {
            int index = -1;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle shape = new Rectangle(0, 0, AbstractButton.this.getWidth(), AbstractButton.this.getHeight());
                index = view.viewToModel(p.x, p.y, shape, new Position.Bias[1]);
            }
            return index;
        }

        public Rectangle getCharacterBounds(int i) {
            Rectangle rect = null;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null) {
                Rectangle shape = new Rectangle(0, 0, AbstractButton.this.getWidth(), AbstractButton.this.getHeight());
                try {
                    Shape s = view.modelToView(i, shape, Position.Bias.Forward);
                    rect = s.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    rect = null;
                }
            }
            return rect;
        }

        public int getCharCount() {
            View view = (View)AbstractButton.this.getClientProperty("html");
            int charCount = view != null ? view.getDocument().getLength() : this.getAccessibleName().length();
            return charCount;
        }

        public int getCaretPosition() {
            return -1;
        }

        public String getAtIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(AbstractButton.this.text.charAt(index));
                    break;
                }
                case 2: {
                    startIndex = AbstractButton.this.text.lastIndexOf(32, index);
                    endIndex = AbstractButton.this.text.indexOf(32, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    startIndex = AbstractButton.this.text.lastIndexOf(46, index);
                    endIndex = AbstractButton.this.text.indexOf(46, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public String getAfterIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(AbstractButton.this.text.charAt(index + 1));
                    break;
                }
                case 2: {
                    startIndex = AbstractButton.this.text.indexOf(32, index);
                    endIndex = AbstractButton.this.text.indexOf(32, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    startIndex = AbstractButton.this.text.indexOf(46, index);
                    endIndex = AbstractButton.this.text.indexOf(46, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public String getBeforeIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(AbstractButton.this.text.charAt(index - 1));
                    break;
                }
                case 2: {
                    endIndex = AbstractButton.this.text.lastIndexOf(32, index);
                    if (endIndex == -1) {
                        endIndex = 0;
                    }
                    startIndex = AbstractButton.this.text.lastIndexOf(32, endIndex - 1);
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    endIndex = AbstractButton.this.text.lastIndexOf(46, index);
                    if (endIndex == -1) {
                        endIndex = 0;
                    }
                    startIndex = AbstractButton.this.text.lastIndexOf(46, endIndex - 1);
                    result = AbstractButton.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public AttributeSet getCharacterAttribute(int i) {
            StyledDocument sDoc;
            Element charEl;
            Document doc;
            AttributeSet atts = null;
            View view = (View)AbstractButton.this.getClientProperty("html");
            if (view != null && (doc = view.getDocument()) instanceof StyledDocument && (charEl = (sDoc = (StyledDocument)doc).getCharacterElement(i)) != null) {
                atts = charEl.getAttributes();
            }
            return atts;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public String getSelectedText() {
            return null;
        }
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 1471056094226600578L;

        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent ev) {
            AbstractButton.this.getEventHandler().stateChanged(ev);
        }
    }

    private class EventHandler
    implements ActionListener,
    ChangeListener,
    ItemListener {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent ev) {
            AbstractButton.this.fireActionPerformed(ev);
        }

        public void stateChanged(ChangeEvent ev) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }

        public void itemStateChanged(ItemEvent ev) {
            AbstractButton.this.fireItemStateChanged(ev);
        }
    }
}

