/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.UnknownFormatConversionException;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable out;
    private Locale locale;
    private boolean closed;
    private IOException ioException;
    private String format;
    private int index;
    private int length;
    private Locale fmtLocale;
    private static final String FLAGS = "--#+ 0,(";
    private static final String lineSeparator = SystemProperties.getProperty("line.separator");

    public Formatter() {
        this(null, Locale.getDefault());
    }

    public Formatter(Locale loc) {
        this(null, loc);
    }

    public Formatter(Appendable app) {
        this(app, Locale.getDefault());
    }

    public Formatter(Appendable app, Locale loc) {
        this.out = app == null ? new StringBuilder() : app;
        this.locale = loc;
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public Formatter(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, charset, Locale.getDefault());
    }

    public Formatter(File file, String charset, Locale loc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset), loc);
    }

    public Formatter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public Formatter(OutputStream out, String charset) throws UnsupportedEncodingException {
        this(out, charset, Locale.getDefault());
    }

    public Formatter(OutputStream out, String charset, Locale loc) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(out, charset), loc);
    }

    public Formatter(PrintStream out) {
        this((Appendable)out);
    }

    public Formatter(String file) throws FileNotFoundException {
        this(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public Formatter(String file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, charset, Locale.getDefault());
    }

    public Formatter(String file, String charset, Locale loc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset), loc);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException iOException) {}
        this.closed = true;
    }

    public void flush() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        try {
            if (this.out instanceof Flushable) {
                ((Flushable)((Object)this.out)).flush();
            }
        }
        catch (IOException iOException) {}
    }

    private String getName(int flags) {
        int bit = Integer.numberOfTrailingZeros(flags);
        return FLAGS.substring(bit, bit + 1);
    }

    private void checkFlags(int flags, int allowed, char conversion) {
        if ((flags &= ~allowed) != 0) {
            throw new FormatFlagsConversionMismatchException(this.getName(flags), conversion);
        }
    }

    private void noPrecision(int precision) {
        if (precision != -1) {
            throw new IllegalFormatPrecisionException(precision);
        }
    }

    private void applyLocalization(CPStringBuilder builder, int flags, int width, boolean isNegative) {
        DecimalFormatSymbols dfsyms = this.fmtLocale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(this.fmtLocale);
        char zeroDigit = dfsyms.getZeroDigit();
        int decimalOffset = -1;
        int i = builder.length() - 1;
        while (i >= 0) {
            char c = builder.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.setCharAt(i, (char)(c - 48 + zeroDigit));
            } else if (c == '.') {
                assert (decimalOffset == -1);
                decimalOffset = i;
            }
            --i;
        }
        if (decimalOffset != -1) {
            builder.deleteCharAt(decimalOffset);
            builder.insert(decimalOffset, dfsyms.getDecimalSeparator());
        }
        if ((flags & 0x40) != 0) {
            char groupSeparator = dfsyms.getGroupingSeparator();
            int groupSize = 3;
            int offset = decimalOffset == -1 ? builder.length() : decimalOffset;
            int i2 = offset - groupSize;
            while (i2 > 0) {
                builder.insert(i2, groupSeparator);
                i2 -= groupSize;
            }
        }
        if ((flags & 0x20) != 0) {
            i = width - builder.length();
            while (i > 0) {
                builder.insert(0, zeroDigit);
                --i;
            }
        }
        if (isNegative) {
            if ((flags & 0x80) != 0) {
                builder.insert(0, '(');
                builder.append(')');
            } else {
                builder.insert(0, '-');
            }
        } else if ((flags & 8) != 0) {
            builder.insert(0, '+');
        } else if ((flags & 0x10) != 0) {
            builder.insert(0, ' ');
        }
    }

    private void genericFormat(String arg, int flags, int width, int precision) throws IOException {
        int i;
        boolean leftJustify;
        if ((flags & 2) != 0) {
            arg = this.fmtLocale == null ? arg.toUpperCase() : arg.toUpperCase(this.fmtLocale);
        }
        if (precision >= 0 && arg.length() > precision) {
            arg = arg.substring(0, precision);
        }
        boolean bl = leftJustify = (flags & 1) != 0;
        if (leftJustify && width == -1) {
            throw new MissingFormatWidthException("fixme");
        }
        if (!leftJustify && arg.length() < width) {
            i = width - arg.length();
            while (i > 0) {
                this.out.append(' ');
                --i;
            }
        }
        this.out.append(arg);
        if (leftJustify && arg.length() < width) {
            i = width - arg.length();
            while (i > 0) {
                this.out.append(' ');
                --i;
            }
        }
    }

    private void booleanFormat(Object arg, int flags, int width, int precision, char conversion) throws IOException {
        this.checkFlags(flags, 3, conversion);
        String result = arg instanceof Boolean ? String.valueOf((Boolean)arg) : (arg == null ? "false" : "true");
        this.genericFormat(result, flags, width, precision);
    }

    private void hashCodeFormat(Object arg, int flags, int width, int precision, char conversion) throws IOException {
        this.checkFlags(flags, 3, conversion);
        this.genericFormat(arg == null ? "null" : Integer.toHexString(arg.hashCode()), flags, width, precision);
    }

    private void stringFormat(Object arg, int flags, int width, int precision, char conversion) throws IOException {
        if (arg instanceof Formattable) {
            this.checkFlags(flags, 7, conversion);
            Formattable fmt = (Formattable)arg;
            fmt.formatTo(this, flags, width, precision);
        } else {
            this.checkFlags(flags, 3, conversion);
            this.genericFormat(arg == null ? "null" : arg.toString(), flags, width, precision);
        }
    }

    private void characterFormat(Object arg, int flags, int width, int precision, char conversion) throws IOException {
        int theChar;
        this.checkFlags(flags, 3, conversion);
        this.noPrecision(precision);
        if (arg == null) {
            this.genericFormat("null", flags, width, precision);
            return;
        }
        if (arg instanceof Character) {
            theChar = ((Character)arg).charValue();
        } else if (arg instanceof Byte) {
            theChar = (char)((Byte)arg).byteValue();
        } else if (arg instanceof Short) {
            theChar = (char)((Short)arg).shortValue();
        } else if (arg instanceof Integer) {
            theChar = (Integer)arg;
            if (!Character.isValidCodePoint(theChar)) {
                throw new IllegalFormatCodePointException(theChar);
            }
        } else {
            throw new IllegalFormatConversionException(conversion, arg.getClass());
        }
        String result = new String(Character.toChars(theChar));
        this.genericFormat(result, flags, width, precision);
    }

    private void percentFormat(int flags, int width, int precision) throws IOException {
        this.checkFlags(flags, 1, '%');
        this.noPrecision(precision);
        this.genericFormat("%", flags, width, precision);
    }

    private void newLineFormat(int flags, int width, int precision) throws IOException {
        this.checkFlags(flags, 0, 'n');
        this.noPrecision(precision);
        if (width != -1) {
            throw new IllegalFormatWidthException(width);
        }
        this.genericFormat(lineSeparator, flags, width, precision);
    }

    private CPStringBuilder basicIntegralConversion(Object arg, int flags, int width, int precision, int radix, char conversion) {
        String result;
        assert (radix == 8 || radix == 10 || radix == 16);
        if (arg == null) {
            return new CPStringBuilder("null");
        }
        this.noPrecision(precision);
        if ((flags & 8) != 0 && (flags & 0x10) != 0) {
            throw new IllegalFormatFlagsException(this.getName(flags));
        }
        if ((flags & 1) != 0 && width == -1) {
            throw new MissingFormatWidthException("fixme");
        }
        int basicFlags = 35;
        basicFlags = radix == 10 ? (basicFlags |= 0xD8) : (basicFlags |= 4);
        if (arg instanceof BigInteger) {
            this.checkFlags(flags, basicFlags | 8 | 0x10 | 0x80, conversion);
            BigInteger bi = (BigInteger)arg;
            result = bi.toString(radix);
        } else if (arg instanceof Number && !(arg instanceof Float) && !(arg instanceof Double)) {
            this.checkFlags(flags, basicFlags, conversion);
            long value = ((Number)arg).longValue();
            result = radix == 8 ? Long.toOctalString(value) : (radix == 16 ? Long.toHexString(value) : Long.toString(value));
        } else {
            throw new IllegalFormatConversionException(conversion, arg.getClass());
        }
        return new CPStringBuilder(result);
    }

    private void hexOrOctalConversion(Object arg, int flags, int width, int precision, int radix, char conversion) throws IOException {
        int resultWidth;
        assert (radix == 8 || radix == 16);
        CPStringBuilder builder = this.basicIntegralConversion(arg, flags, width, precision, radix, conversion);
        int insertPoint = 0;
        if (builder.charAt(0) == '-') {
            ++insertPoint;
        } else if ((flags & 8) != 0) {
            builder.insert(insertPoint, '+');
            ++insertPoint;
        } else if ((flags & 0x10) != 0) {
            builder.insert(insertPoint, ' ');
            ++insertPoint;
        }
        if ((flags & 4) != 0) {
            builder.insert(insertPoint, radix == 8 ? "0" : "0x");
            insertPoint += radix == 8 ? 1 : 2;
        }
        if ((resultWidth = builder.length()) < width) {
            char fill;
            char c = fill = (flags & 0x20) != 0 ? (char)'0' : ' ';
            if ((flags & 1) != 0) {
                if (fill == ' ') {
                    insertPoint = builder.length();
                }
            } else {
                insertPoint = 0;
            }
            while (resultWidth++ < width) {
                builder.insert(insertPoint, fill);
            }
        }
        String result = builder.toString();
        if ((flags & 2) != 0) {
            result = this.fmtLocale == null ? result.toUpperCase() : result.toUpperCase(this.fmtLocale);
        }
        this.out.append(result);
    }

    private void decimalConversion(Object arg, int flags, int width, int precision, char conversion) throws IOException {
        CPStringBuilder builder = this.basicIntegralConversion(arg, flags, width, precision, 10, conversion);
        boolean isNegative = false;
        if (builder.charAt(0) == '-') {
            builder.deleteCharAt(0);
            isNegative = true;
        }
        this.applyLocalization(builder, flags, width, isNegative);
        this.genericFormat(builder.toString(), flags, width, precision);
    }

    private void singleDateTimeConversion(CPStringBuilder builder, Calendar cal, char conversion, DateFormatSymbols syms) {
        int oldLen = builder.length();
        int digits = -1;
        switch (conversion) {
            case 'H': {
                builder.append(cal.get(11));
                digits = 2;
                break;
            }
            case 'I': {
                builder.append(cal.get(10));
                digits = 2;
                break;
            }
            case 'k': {
                builder.append(cal.get(11));
                break;
            }
            case 'l': {
                builder.append(cal.get(10));
                break;
            }
            case 'M': {
                builder.append(cal.get(12));
                digits = 2;
                break;
            }
            case 'S': {
                builder.append(cal.get(13));
                digits = 2;
                break;
            }
            case 'N': {
                digits = 9;
                break;
            }
            case 'p': {
                int ampm = cal.get(9);
                builder.append(syms.getAmPmStrings()[ampm]);
                break;
            }
            case 'z': {
                int zone = cal.get(15) / 60000;
                builder.append(zone);
                digits = 4;
                if (zone >= 0) break;
                ++oldLen;
                break;
            }
            case 'Z': {
                int zone = cal.get(15) / 3600000;
                String[][] zs = syms.getZoneStrings();
                builder.append(zs[zone + 12][1]);
                break;
            }
            case 's': {
                long val = cal.getTime().getTime();
                builder.append(val / 1000L);
                break;
            }
            case 'Q': {
                long val = cal.getTime().getTime();
                builder.append(val);
                break;
            }
            case 'B': {
                int month = cal.get(2);
                builder.append(syms.getMonths()[month]);
                break;
            }
            case 'b': 
            case 'h': {
                int month = cal.get(2);
                builder.append(syms.getShortMonths()[month]);
                break;
            }
            case 'A': {
                int day = cal.get(7);
                builder.append(syms.getWeekdays()[day]);
                break;
            }
            case 'a': {
                int day = cal.get(7);
                builder.append(syms.getShortWeekdays()[day]);
                break;
            }
            case 'C': {
                builder.append(cal.get(1) / 100);
                digits = 2;
                break;
            }
            case 'Y': {
                builder.append(cal.get(1));
                digits = 4;
                break;
            }
            case 'y': {
                builder.append(cal.get(1) % 100);
                digits = 2;
                break;
            }
            case 'j': {
                builder.append(cal.get(6));
                digits = 3;
                break;
            }
            case 'm': {
                builder.append(cal.get(2) + 1);
                digits = 2;
                break;
            }
            case 'd': {
                builder.append(cal.get(5));
                digits = 2;
                break;
            }
            case 'e': {
                builder.append(cal.get(5));
                break;
            }
            case 'R': {
                this.singleDateTimeConversion(builder, cal, 'H', syms);
                builder.append(':');
                this.singleDateTimeConversion(builder, cal, 'M', syms);
                break;
            }
            case 'T': {
                this.singleDateTimeConversion(builder, cal, 'H', syms);
                builder.append(':');
                this.singleDateTimeConversion(builder, cal, 'M', syms);
                builder.append(':');
                this.singleDateTimeConversion(builder, cal, 'S', syms);
                break;
            }
            case 'r': {
                this.singleDateTimeConversion(builder, cal, 'I', syms);
                builder.append(':');
                this.singleDateTimeConversion(builder, cal, 'M', syms);
                builder.append(':');
                this.singleDateTimeConversion(builder, cal, 'S', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'p', syms);
                break;
            }
            case 'D': {
                this.singleDateTimeConversion(builder, cal, 'm', syms);
                builder.append('/');
                this.singleDateTimeConversion(builder, cal, 'd', syms);
                builder.append('/');
                this.singleDateTimeConversion(builder, cal, 'y', syms);
                break;
            }
            case 'F': {
                this.singleDateTimeConversion(builder, cal, 'Y', syms);
                builder.append('-');
                this.singleDateTimeConversion(builder, cal, 'm', syms);
                builder.append('-');
                this.singleDateTimeConversion(builder, cal, 'd', syms);
                break;
            }
            case 'c': {
                this.singleDateTimeConversion(builder, cal, 'a', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'b', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'd', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'T', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'Z', syms);
                builder.append(' ');
                this.singleDateTimeConversion(builder, cal, 'Y', syms);
                break;
            }
            default: {
                throw new UnknownFormatConversionException(String.valueOf(conversion));
            }
        }
        if (digits > 0) {
            int newLen = builder.length();
            int delta = newLen - oldLen;
            while (delta++ < digits) {
                builder.insert(oldLen, '0');
            }
        }
    }

    private void dateTimeConversion(Object arg, int flags, int width, int precision, char conversion, char subConversion) throws IOException {
        Calendar cal;
        this.noPrecision(precision);
        this.checkFlags(flags, 3, conversion);
        if (arg instanceof Calendar) {
            cal = (Calendar)arg;
        } else {
            Date date;
            if (arg instanceof Date) {
                date = (Date)arg;
            } else if (arg instanceof Long) {
                date = new Date((Long)arg);
            } else {
                throw new IllegalFormatConversionException(conversion, arg.getClass());
            }
            cal = this.fmtLocale == null ? Calendar.getInstance() : Calendar.getInstance(this.fmtLocale);
            cal.setTime(date);
        }
        DateFormatSymbols syms = this.fmtLocale == null ? new DateFormatSymbols() : new DateFormatSymbols(this.fmtLocale);
        CPStringBuilder result = new CPStringBuilder();
        this.singleDateTimeConversion(result, cal, subConversion, syms);
        this.genericFormat(result.toString(), flags, width, precision);
    }

    private void advance() {
        ++this.index;
        if (this.index >= this.length) {
            throw new IllegalArgumentException();
        }
    }

    private int parseInt() {
        int start = this.index;
        while (Character.isDigit(this.format.charAt(this.index))) {
            this.advance();
        }
        if (start == this.index) {
            return -1;
        }
        return Integer.parseInt(this.format.substring(start, this.index));
    }

    private int parseArgumentIndex() {
        int result = -1;
        int start = this.index;
        if (this.format.charAt(this.index) == '<') {
            result = 0;
            this.advance();
        } else if (Character.isDigit(this.format.charAt(this.index))) {
            result = this.parseInt();
            if (this.format.charAt(this.index) == '$') {
                this.advance();
            } else {
                this.index = start;
                result = -1;
            }
        }
        return result;
    }

    private int parseFlags() {
        int x;
        int value = 0;
        int start = this.index;
        while ((x = FLAGS.indexOf(this.format.charAt(this.index))) != -1) {
            int newValue = 1 << x;
            if ((value & newValue) != 0) {
                throw new DuplicateFormatFlagsException(this.format.substring(start, this.index + 1));
            }
            value |= newValue;
            this.advance();
        }
        return value;
    }

    private int parseWidth() {
        return this.parseInt();
    }

    private int parsePrecision() {
        if (this.format.charAt(this.index) != '.') {
            return -1;
        }
        this.advance();
        int precision = this.parseInt();
        if (precision == -1) {
            throw new IllegalArgumentException();
        }
        return precision;
    }

    public Formatter format(Locale loc, String fmt, Object ... args) {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        int implicitArgumentIndex = 1;
        int previousArgumentIndex = 0;
        try {
            this.fmtLocale = loc;
            this.format = fmt;
            this.length = this.format.length();
            this.index = 0;
            while (this.index < this.length) {
                char c = this.format.charAt(this.index);
                if (c != '%') {
                    this.out.append(c);
                } else {
                    char origConversion;
                    int start = this.index;
                    this.advance();
                    int argumentIndex = this.parseArgumentIndex();
                    int flags = this.parseFlags();
                    int width = this.parseWidth();
                    int precision = this.parsePrecision();
                    char conversion = origConversion = this.format.charAt(this.index);
                    if (Character.isUpperCase(conversion)) {
                        flags |= 2;
                        conversion = Character.toLowerCase(conversion);
                    }
                    Object argument = null;
                    if (conversion == '%' || conversion == 'n') {
                        if (argumentIndex != -1) {
                            throw new UnknownFormatConversionException("FIXME");
                        }
                    } else {
                        if (argumentIndex == -1) {
                            argumentIndex = implicitArgumentIndex++;
                        } else if (argumentIndex == 0) {
                            argumentIndex = previousArgumentIndex;
                        }
                        --argumentIndex;
                        if (args != null) {
                            if (argumentIndex < 0 || argumentIndex >= args.length) {
                                throw new MissingFormatArgumentException(this.format.substring(start, this.index));
                            }
                            argument = args[argumentIndex];
                        }
                    }
                    switch (conversion) {
                        case 'b': {
                            this.booleanFormat(argument, flags, width, precision, origConversion);
                            break;
                        }
                        case 'h': {
                            this.hashCodeFormat(argument, flags, width, precision, origConversion);
                            break;
                        }
                        case 's': {
                            this.stringFormat(argument, flags, width, precision, origConversion);
                            break;
                        }
                        case 'c': {
                            this.characterFormat(argument, flags, width, precision, origConversion);
                            break;
                        }
                        case 'd': {
                            this.checkFlags(flags & 2, 0, 'd');
                            this.decimalConversion(argument, flags, width, precision, origConversion);
                            break;
                        }
                        case 'o': {
                            this.checkFlags(flags & 2, 0, 'o');
                            this.hexOrOctalConversion(argument, flags, width, precision, 8, origConversion);
                            break;
                        }
                        case 'x': {
                            this.hexOrOctalConversion(argument, flags, width, precision, 16, origConversion);
                        }
                        case 'e': {
                            break;
                        }
                        case 'f': {
                            break;
                        }
                        case 'g': {
                            break;
                        }
                        case 'a': {
                            break;
                        }
                        case 't': {
                            this.advance();
                            char subConversion = this.format.charAt(this.index);
                            this.dateTimeConversion(argument, flags, width, precision, origConversion, subConversion);
                            break;
                        }
                        case '%': {
                            this.percentFormat(flags, width, precision);
                            break;
                        }
                        case 'n': {
                            this.newLineFormat(flags, width, precision);
                            break;
                        }
                        default: {
                            throw new UnknownFormatConversionException(String.valueOf(origConversion));
                        }
                    }
                }
                ++this.index;
            }
        }
        catch (IOException exc) {
            this.ioException = exc;
        }
        return this;
    }

    public Formatter format(String format, Object ... args) {
        return this.format(this.locale, format, args);
    }

    public IOException ioException() {
        return this.ioException;
    }

    public Locale locale() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.locale;
    }

    public Appendable out() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.out;
    }

    public String toString() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
        return this.out.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BigDecimalLayoutForm {
        DECIMAL_FLOAT,
        SCIENTIFIC;

    }
}

