/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.util.Arrays;

public final class UnresolvedPermission
extends Permission {
    private static final long serialVersionUID = -4821973115467008846L;
    private final String actions;
    private final transient Certificate[] certs;
    final String type;
    private final String name;

    public UnresolvedPermission(String type, String name, String actions, Certificate[] certs) {
        super(name);
        this.name = name;
        this.type = type;
        this.actions = actions;
        this.certs = certs;
    }

    public boolean implies(Permission perm) {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnresolvedPermission)) {
            return false;
        }
        UnresolvedPermission up = (UnresolvedPermission)obj;
        return up.name.equals(this.name) && up.actions.equals(this.actions) && up.type.equals(this.type) && Arrays.equals(up.certs, this.certs);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getActions() {
        return this.actions;
    }

    public String toString() {
        return "(unresolved " + this.type + ' ' + this.name + ' ' + this.actions + ')';
    }

    public PermissionCollection newPermissionCollection() {
        return new UnresolvedPermissionCollection();
    }

    public String getUnresolvedType() {
        return this.type;
    }

    public String getUnresolvedName() {
        return this.name;
    }

    public String getUnresolvedActions() {
        return this.actions;
    }

    public Certificate[] getUnresolvedCerts() {
        if (this.certs == null) {
            return null;
        }
        return (Certificate[])this.certs.clone();
    }
}

