/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public abstract class PackedColorModel
extends ColorModel {
    private int[] masks;
    int[] shifts;

    public PackedColorModel(ColorSpace cspace, int pixelBits, int[] colorMaskArray, int alphaMask, boolean isAlphaPremultiplied, int transparency, int transferType) {
        super(pixelBits, PackedColorModel.calcBitsPerComponent(colorMaskArray, alphaMask), cspace, alphaMask != 0, isAlphaPremultiplied, transparency, transferType);
        this.initMasks(colorMaskArray, alphaMask);
        if (pixelBits < 1 || pixelBits > 32) {
            throw new IllegalArgumentException("pixels per bits must be in the range [1, 32]");
        }
    }

    private static int[] calcBitsPerComponent(int[] colorMaskArray, int alphaMask) {
        int numComponents = colorMaskArray.length;
        if (alphaMask != 0) {
            ++numComponents;
        }
        int[] bitsPerComponent = new int[numComponents];
        BitMaskExtent extent = new BitMaskExtent();
        int b = 0;
        while (b < colorMaskArray.length) {
            extent.setMask(colorMaskArray[b]);
            bitsPerComponent[b] = extent.bitWidth;
            ++b;
        }
        if (alphaMask != 0) {
            extent.setMask(alphaMask);
            bitsPerComponent[numComponents - 1] = extent.bitWidth;
        }
        return bitsPerComponent;
    }

    private void initMasks(int[] colorMaskArray, int alphaMask) {
        int numComponents = colorMaskArray.length;
        if (alphaMask == 0) {
            this.masks = colorMaskArray;
        } else {
            this.masks = new int[numComponents + 1];
            System.arraycopy(colorMaskArray, 0, this.masks, 0, numComponents);
            this.masks[numComponents++] = alphaMask;
        }
        this.shifts = new int[numComponents];
        BitMaskExtent extent = new BitMaskExtent();
        int b = 0;
        while (b < numComponents) {
            extent.setMask(this.masks[b]);
            this.shifts[b] = extent.leastSignificantBit;
            ++b;
        }
    }

    public PackedColorModel(ColorSpace cspace, int pixelBits, int rmask, int gmask, int bmask, int amask, boolean isAlphaPremultiplied, int transparency, int transferType) {
        this(cspace, pixelBits, PackedColorModel.makeColorMaskArray(rmask, gmask, bmask), amask, isAlphaPremultiplied, transparency, transferType);
    }

    private static int[] makeColorMaskArray(int rmask, int gmask, int bmask) {
        int[] colorMaskArray = new int[]{rmask, gmask, bmask};
        return colorMaskArray;
    }

    public final int getMask(int index) {
        return this.masks[index];
    }

    public final int[] getMasks() {
        return this.masks;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(this.transferType, w, h, this.masks);
    }

    public boolean isCompatibleSampleModel(SampleModel sm) {
        if (!super.isCompatibleSampleModel(sm)) {
            return false;
        }
        if (!(sm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
        return Arrays.equals(sppsm.getBitMasks(), this.masks);
    }

    public WritableRaster getAlphaRaster(WritableRaster raster) {
        if (!this.hasAlpha()) {
            return null;
        }
        SampleModel sm = raster.getSampleModel();
        int[] alphaBand = new int[]{sm.getNumBands() - 1};
        SampleModel alphaModel = sm.createSubsetSampleModel(alphaBand);
        DataBuffer buffer = raster.getDataBuffer();
        Point origin = new Point(0, 0);
        return Raster.createWritableRaster(alphaModel, buffer, origin);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel other = (PackedColorModel)obj;
        return Arrays.equals(this.masks, other.masks);
    }
}

