/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubstringFunction
extends Expr {
    final Expr arg1;
    final Expr arg2;
    final Expr arg3;

    SubstringFunction(List<Expr> args) {
        this(args.get(0), args.get(1), args.size() > 2 ? args.get(2) : null);
    }

    SubstringFunction(Expr arg1, Expr arg2, Expr arg3) {
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
    }

    @Override
    public Object evaluate(Node context, int pos, int len) {
        Object val3;
        int v3;
        int l;
        Object val1 = this.arg1.evaluate(context, pos, len);
        Object val2 = this.arg2.evaluate(context, pos, len);
        String s = SubstringFunction._string(context, val1);
        int p = Expr.intValue(val2) - 1;
        if (p < 0) {
            p = 0;
        }
        if ((l = s.length() - p) <= 0) {
            return "";
        }
        if (this.arg3 != null && (v3 = Expr.intValue(val3 = this.arg3.evaluate(context, pos, len))) < l) {
            l = v3;
        }
        return s.substring(p, p + l);
    }

    @Override
    public Expr clone(Object context) {
        return new SubstringFunction(this.arg1.clone(context), this.arg2.clone(context), this.arg3 == null ? null : this.arg3.clone(context));
    }

    @Override
    public boolean references(QName var) {
        return this.arg1.references(var) || this.arg2.references(var) || this.arg3 == null ? false : this.arg3.references(var);
    }

    public String toString() {
        return this.arg3 == null ? "substring(" + this.arg1 + "," + this.arg2 + ")" : "substring(" + this.arg1 + "," + this.arg2 + "," + this.arg3 + ")";
    }
}

