/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import java.io.IOException;
import java.io.Reader;

class BufferedReader
extends Reader {
    static final int DEFAULT_BUFFER_SIZE = 4096;
    final Reader in;
    char[] buf;
    int pos;
    int count;
    int markpos;
    int marklimit;
    int bufferSize;

    BufferedReader(Reader in) {
        this(in, 4096);
    }

    BufferedReader(Reader in, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.bufferSize = bufferSize;
        this.buf = new char[bufferSize];
        this.pos = this.count = bufferSize;
    }

    public void close() throws IOException {
        this.buf = null;
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        this.in.close();
    }

    public void mark(int readlimit) throws IOException {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        return this.buf[this.pos++];
    }

    public int read(char[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(char[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int ret = Math.min(this.count - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, ret);
        this.pos += ret;
        off += ret;
        len -= ret;
        while (len > 0 && this.refill()) {
            int remain = Math.min(this.count - this.pos, len);
            System.arraycopy(this.buf, this.pos, b, off, remain);
            this.pos += remain;
            off += remain;
            len -= remain;
            ret += remain;
        }
        return ret;
    }

    public void reset() throws IOException {
        if (this.markpos == -1) {
            throw new IOException(this.buf == null ? "Stream closed." : "Invalid mark.");
        }
        this.pos = this.markpos;
    }

    public long skip(long n) throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        long origN = n;
        while (n > 0L) {
            if (this.pos >= this.count && !this.refill()) break;
            int numread = (int)Math.min((long)(this.count - this.pos), n);
            this.pos += numread;
            n -= (long)numread;
        }
        return origN - n;
    }

    private boolean refill() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed.");
        }
        int markcount = this.count - this.markpos;
        if (this.markpos == -1 || markcount >= this.marklimit) {
            this.markpos = -1;
            this.count = 0;
            this.pos = 0;
        } else {
            char[] newbuf = this.buf;
            if (this.markpos < this.bufferSize) {
                newbuf = new char[this.count - this.markpos + this.bufferSize];
            }
            System.arraycopy(this.buf, this.markpos, newbuf, 0, markcount);
            this.buf = newbuf;
            this.count = markcount;
            this.pos -= this.markpos;
            this.markpos = 0;
        }
        int numread = this.in.read(this.buf, this.count, this.bufferSize);
        if (numread <= 0) {
            return false;
        }
        this.count += numread;
        return true;
    }
}

