/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateBuilder
extends Certificate
implements Builder {
    public CertificateBuilder(CertificateType certType) {
        super(ByteBuffer.allocate(1024), certType);
    }

    @Override
    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setCertificates(List<? extends java.security.cert.Certificate> certificates) throws CertificateException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        for (java.security.cert.Certificate certificate : certificates) {
            byte[] encoded = certificate.getEncoded();
            out.write(encoded.length >>> 16 & 0xFF);
            out.write(encoded.length >>> 8 & 0xFF);
            out.write(encoded.length & 0xFF);
            try {
                out.write(encoded);
            }
            catch (IOException iOException) {}
        }
        byte[] byArray = out.toByteArray();
        if (this.buffer.capacity() < byArray.length + 3) {
            this.buffer = ByteBuffer.allocate(byArray.length + 3);
        }
        this.buffer.put(0, (byte)(byArray.length >>> 16));
        this.buffer.putShort(1, (short)byArray.length);
        ((ByteBuffer)this.buffer.duplicate().position(3)).put(byArray);
    }
}

