/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGException;
import gnu.javax.imageio.jpeg.JPEGImageInputStream;
import java.io.IOException;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class HuffmanTable {
    public static final int HUFFMAN_MAX_TABLES = 4;
    private short[] huffcode = new short[256];
    private short[] huffsize = new short[256];
    private short[] EHUFCO;
    private short[] EHUFSI;
    private short[] valptr = new short[16];
    private short[] mincode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private short[] maxcode = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private short[] huffval;
    private short[] bits;
    static byte JPEG_DC_TABLE = 0;
    static byte JPEG_AC_TABLE = 1;
    private short lastk = 0;

    public HuffmanTable(JPEGHuffmanTable table) {
        this.huffcode = table.getValues();
        this.bits = table.getLengths();
    }

    private void generateSizeTable() {
        short index = 0;
        int i = 0;
        while (i < this.bits.length) {
            short j = 0;
            while (j < this.bits[i]) {
                this.huffsize[index] = (short)(i + 1);
                index = (short)(index + 1);
                j = (short)(j + 1);
            }
            i = (short)(i + 1);
        }
        this.lastk = index;
    }

    /*
     * Unable to fully structure code
     */
    private void generateCodeTable() {
        k = 0;
        si = this.huffsize[0];
        code = 0;
        i = 0;
        ** GOTO lbl14
        {
            this.huffcode[k] = code;
            code = (short)(code + 1);
            k = (short)(k + 1);
            do {
                if (this.huffsize[k] == si) continue block0;
                code = (short)(code << 1);
                si = (short)(si + 1);
                i = (short)(i + 1);
lbl14:
                // 2 sources

            } while (i < this.huffsize.length);
        }
    }

    private void generateDecoderTables() {
        short bitcount = 0;
        int i = 0;
        while (i < 16) {
            if (this.bits[i] != 0) {
                this.valptr[i] = bitcount;
            }
            int j = 0;
            while (j < this.bits[i]) {
                if (this.huffcode[j + bitcount] < this.mincode[i] || this.mincode[i] == -1) {
                    this.mincode[i] = this.huffcode[j + bitcount];
                }
                if (this.huffcode[j + bitcount] > this.maxcode[i]) {
                    this.maxcode[i] = this.huffcode[j + bitcount];
                }
                ++j;
            }
            if (this.mincode[i] != -1) {
                this.valptr[i] = (short)(this.valptr[i] - this.mincode[i]);
            }
            bitcount = (short)(bitcount + this.bits[i]);
            ++i;
        }
    }

    public void orderCodes(boolean isDC) {
        this.EHUFCO = new short[isDC ? 15 : 255];
        this.EHUFSI = new short[isDC ? 15 : 255];
        int p = 0;
        while (p < this.lastk) {
            short i = this.huffval[p];
            if (i < 0 || i > this.EHUFCO.length || this.EHUFSI[i] != 0) {
                System.err.println("Error, bad huffman table.");
            }
            this.EHUFCO[i] = this.huffcode[p];
            this.EHUFSI[i] = this.huffsize[p];
            ++p;
        }
    }

    public static int extend(int diff, int t) {
        int Vt = (int)Math.pow(2.0, t - 1);
        if (diff < Vt) {
            Vt = (-1 << t) + 1;
            diff += Vt;
        }
        return diff;
    }

    public int decode(JPEGImageInputStream JPEGStream) throws IOException, JPEGException {
        int i = 0;
        short code = (short)JPEGStream.readBits(1);
        while (code > this.maxcode[i]) {
            ++i;
            code = (short)(code << 1);
            code = (short)((long)code | JPEGStream.readBits(1));
        }
        int val = this.huffval[code + this.valptr[i]];
        if (val < 0) {
            val += 256;
        }
        return val;
    }
}

