/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmiregistry;

import gnu.classpath.tools.common.Persistent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;

public class PersistentHashTable
extends Hashtable
implements Serializable,
Persistent {
    private static final long serialVersionUID = 1L;
    File database;
    WriteToDiskTask sheduled = null;
    long lastUpdated;
    transient boolean ready;

    private PersistentHashTable(File file) {
        if (file == null) {
            throw new NullPointerException("Null file provided");
        }
        this.database = file;
    }

    public static Map createInstance(File file, boolean coldStart) {
        try {
            PersistentHashTable k2v;
            System.out.println("Here1");
            if (file.exists()) {
                System.out.println("Here2");
                if (coldStart) {
                    System.out.println("Here2.5");
                    file.delete();
                    k2v = new PersistentHashTable(file);
                } else {
                    System.out.println("Here3");
                    FileInputStream fi = new FileInputStream(file);
                    System.out.println("Here3.1");
                    BufferedInputStream b = new BufferedInputStream(fi);
                    System.out.println("Here3.2");
                    ObjectInputStream oin = new ObjectInputStream(b);
                    System.out.println("Here3.3");
                    System.out.println("Here4");
                    k2v = (PersistentHashTable)oin.readObject();
                    oin.close();
                    System.out.println("Here5");
                }
            } else {
                System.out.println("Here6");
                k2v = new PersistentHashTable(file);
                System.out.println("Here7");
            }
            System.out.println("Here8");
            k2v.ready = true;
            return k2v;
        }
        catch (Exception ioex) {
            InternalError ierr = new InternalError("Unable to intialize with file " + file);
            ierr.initCause(ioex);
            throw ierr;
        }
    }

    public synchronized void writeContent() {
        try {
            FileOutputStream fou = new FileOutputStream(this.database);
            BufferedOutputStream b = new BufferedOutputStream(fou);
            ObjectOutputStream oout = new ObjectOutputStream(b);
            oout.writeObject(this);
            oout.close();
        }
        catch (Exception ioex) {
            InternalError ierr = new InternalError("Failed to write database to disk: " + this.database);
            ierr.initCause(ioex);
            throw ierr;
        }
    }

    public void markDirty() {
        if (System.currentTimeMillis() - this.lastUpdated > 300000L) {
            this.writeContent();
            this.lastUpdated = System.currentTimeMillis();
            if (this.sheduled != null) {
                this.sheduled.cancel();
                this.sheduled = null;
            }
        } else {
            if (this.sheduled != null) {
                this.sheduled.cancel();
            }
            this.sheduled = new WriteToDiskTask();
            timer.schedule((TimerTask)this.sheduled, 5000L);
        }
    }

    public void shutdown() {
        if (this.sheduled != null) {
            this.writeContent();
            this.sheduled = null;
        }
    }

    public Object put(Object key, Object value) {
        super.put(key, value);
        if (this.ready) {
            this.markDirty();
        }
        return value;
    }

    public Object remove(Object key) {
        Object removed = super.remove(key);
        if (this.ready) {
            this.markDirty();
        }
        return removed;
    }

    class WriteToDiskTask
    extends TimerTask {
        WriteToDiskTask() {
        }

        public void run() {
            PersistentHashTable.this.writeContent();
            PersistentHashTable.this.sheduled = null;
        }
    }
}

