/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class KeyCloneCmd
extends Command {
    private static final Logger log = Logger.getLogger(KeyCloneCmd.class.getName());
    protected String _alias;
    protected String _destAlias;
    protected String _password;
    protected String _newPassword;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private String destinationAlias;
    private char[] newKeyPasswordChars;

    KeyCloneCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setDest(String alias) {
        this._destAlias = alias;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setNew(String password) {
        this._newPassword = password;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        this.setDestinationAlias(this._destAlias);
        if (Configuration.DEBUG) {
            log.fine("-keyclone handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -dest=" + this.destinationAlias);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        if (this.store.containsAlias(this.destinationAlias)) {
            throw new SecurityException(Messages.getString("KeyCloneCmd.23"));
        }
        Key privateKey = this.getAliasPrivateKey();
        this.setNewKeyPassword(this._newPassword);
        Certificate[] chain = this.store.getCertificateChain(this.alias);
        this.store.setKeyEntry(this.destinationAlias, privateKey, this.newKeyPasswordChars, chain);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("keyclone", true);
        result.setHeader(Messages.getString("KeyCloneCmd.22"));
        result.setFooter(Messages.getString("KeyCloneCmd.21"));
        OptionGroup options = new OptionGroup(Messages.getString("KeyCloneCmd.20"));
        options.add(new Option("alias", Messages.getString("KeyCloneCmd.19"), Messages.getString("KeyCloneCmd.16")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._alias = argument;
            }
        });
        options.add(new Option("dest", Messages.getString("KeyCloneCmd.17"), Messages.getString("KeyCloneCmd.16")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._destAlias = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("KeyCloneCmd.15"), Messages.getString("KeyCloneCmd.6")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._password = argument;
            }
        });
        options.add(new Option("new", Messages.getString("KeyCloneCmd.13"), Messages.getString("KeyCloneCmd.6")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._newPassword = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("KeyCloneCmd.11"), Messages.getString("KeyCloneCmd.10")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("KeyCloneCmd.9"), Messages.getString("KeyCloneCmd.8")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("KeyCloneCmd.7"), Messages.getString("KeyCloneCmd.6")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("KeyCloneCmd.5"), Messages.getString("KeyCloneCmd.4")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("KeyCloneCmd.3")){

            public void parsed(String argument) throws OptionException {
                KeyCloneCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void setDestinationAlias(String name) throws IOException, UnsupportedCallbackException {
        if (name == null || name.trim().length() == 0) {
            NameCallback ncb = new NameCallback(Messages.getString("KeyCloneCmd.26"));
            this.getCallbackHandler().handle(new Callback[]{ncb});
            name = ncb.getName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException(Messages.getString("KeyCloneCmd.27"));
            }
        }
        this.destinationAlias = name.trim();
    }

    private void setNewKeyPassword(String password) throws IOException, UnsupportedCallbackException {
        if (password != null) {
            this.newKeyPasswordChars = password.toCharArray();
        } else {
            boolean ok = false;
            Callback[] prompts = new Callback[1];
            Callback[] errors = new Callback[1];
            int i = 0;
            while (i < 3) {
                if (this.prompt4NewPassword(this.getCallbackHandler(), prompts, errors)) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                throw new SecurityException(Messages.getString("StorePasswdCmd.19"));
            }
        }
    }

    private boolean prompt4NewPassword(CallbackHandler handler, Callback[] prompts, Callback[] errors) throws IOException, UnsupportedCallbackException {
        String p = Messages.getFormattedString("KeyCloneCmd.28", new String[]{this.destinationAlias, String.valueOf(this.keyPasswordChars)});
        PasswordCallback pcb = new PasswordCallback(p, false);
        prompts[0] = pcb;
        handler.handle(prompts);
        char[] pwd1 = pcb.getPassword();
        pcb.clearPassword();
        if (pwd1 == null || pwd1.length == 0) {
            this.newKeyPasswordChars = (char[])this.keyPasswordChars.clone();
            return true;
        }
        if (pwd1.length < 6) {
            errors[0] = new TextOutputCallback(2, Messages.getString("StorePasswdCmd.21"));
            handler.handle(errors);
            return false;
        }
        this.newKeyPasswordChars = pwd1;
        return true;
    }
}

